/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.client.Camera.CameraEntity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10185;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.playsi.Afkcam.client.Camera.FreecamPosition;

public class FreeCamera
extends class_746 {
    private static final class_310 MC = class_310.method_1551();
    private final int customId;
    private boolean suppressPositionUpdates = false;
    private double lastAppliedX = Double.NaN;
    private double lastAppliedY = Double.NaN;
    private double lastAppliedZ = Double.NaN;
    private float lastAppliedYaw = Float.NaN;
    private float lastAppliedPitch = Float.NaN;
    class_638 clientWorld;

    public FreeCamera(int id) {
        super(MC, FreeCamera.MC.field_1687 != null ? FreeCamera.MC.field_1687 : null, Objects.requireNonNull(MC.method_1562()), FreeCamera.MC.field_1724 != null ? FreeCamera.MC.field_1724.method_3143() : null, FreeCamera.MC.field_1724 != null ? FreeCamera.MC.field_1724.method_3130() : null, new class_10185(false, false, false, false, false, false, false), false);
        this.clientWorld = class_310.method_1551().field_1687;
        this.customId = id;
        this.method_5838(id);
        this.method_5826(UUID.randomUUID());
        this.method_18380(class_4050.field_18079);
        this.method_5875(true);
        this.field_5960 = true;
        this.method_5648(true);
        this.method_5684(true);
    }

    public void copyPosition(class_1297 entity) {
        if (entity != null) {
            this.applyPosition(new FreecamPosition(entity));
        }
    }

    public void applyPosition(FreecamPosition position) {
        if (position != null) {
            this.applyPosition(position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPosition(double x, double y, double z, float yaw, float pitch) {
        boolean positionChanged;
        boolean bl = positionChanged = Double.isNaN(this.lastAppliedX) || Math.abs(this.lastAppliedX - x) > 1.0E-4 || Double.isNaN(this.lastAppliedY) || Math.abs(this.lastAppliedY - y) > 1.0E-4 || Double.isNaN(this.lastAppliedZ) || Math.abs(this.lastAppliedZ - z) > 1.0E-4 || Float.isNaN(this.lastAppliedYaw) || Math.abs(this.lastAppliedYaw - yaw) > 0.01f || Float.isNaN(this.lastAppliedPitch) || Math.abs(this.lastAppliedPitch - pitch) > 0.01f;
        if (!positionChanged) {
            return;
        }
        this.suppressPositionUpdates = true;
        try {
            this.method_5808(x, y, z, yaw, pitch);
            this.lastAppliedX = x;
            this.lastAppliedY = y;
            this.lastAppliedZ = z;
            this.lastAppliedYaw = yaw;
            this.lastAppliedPitch = pitch;
        }
        finally {
            this.suppressPositionUpdates = false;
        }
    }

    public void applyPerspective(class_5498 perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((class_1297)this);
        switch (perspective) {
            case field_26664: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case field_26666: {
                position.mirrorRotation();
            }
            case field_26665: {
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((class_1297)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.method_52542(this.method_18376())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        if (this.clientWorld != null && this.clientWorld.method_8469(this.method_5628()) != null) {
            this.clientWorld.method_53875((class_1297)this);
        }
    }

    public void despawn() {
        if (this.clientWorld != null) {
            class_1297 entityByUuid;
            class_1297 existingEntity = this.clientWorld.method_8469(this.customId);
            if (existingEntity != null) {
                this.clientWorld.method_2945(this.customId, class_1297.class_5529.field_26999);
            }
            if ((entityByUuid = this.clientWorld.method_8469(this.method_5628())) != null && entityByUuid != existingEntity) {
                this.clientWorld.method_2945(entityByUuid.method_5628(), class_1297.class_5529.field_26999);
            }
        }
    }

    public boolean method_6115() {
        return FreeCamera.MC.field_1724 != null ? FreeCamera.MC.field_1724.method_6115() : false;
    }

    public void method_18380(class_4050 pose) {
        super.method_18380(class_4050.field_18079);
    }

    public void method_5773() {
        if (!this.suppressPositionUpdates) {
            this.method_5670();
        }
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5863() {
        return false;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (!this.suppressPositionUpdates && movementType == class_1313.field_6308) {
            super.method_5784(movementType, movement);
        }
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_7325() {
        return true;
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        if (!this.suppressPositionUpdates) {
            super.method_5641(x, y, z, yaw, pitch);
        }
    }

    public void forceUpdatePosition(double x, double y, double z, float yaw, float pitch) {
        super.method_5641(x, y, z, yaw, pitch);
    }

    public void resetPositionCache() {
        this.lastAppliedX = Double.NaN;
        this.lastAppliedY = Double.NaN;
        this.lastAppliedZ = Double.NaN;
        this.lastAppliedYaw = Float.NaN;
        this.lastAppliedPitch = Float.NaN;
    }
}

