/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client.util;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import dev.drtheo.spellwheel.client.I18n;
import dev.drtheo.spellwheel.client.config.WheelClientConfig;
import dev.drtheo.spellwheel.client.ui.WheelScreen;
import dev.drtheo.spellwheel.client.ui.Widget;
import dev.drtheo.spellwheel.client.ui.WidgetSet;
import dev.drtheo.spellwheel.client.ui.action.IconChangeAction;
import dev.drtheo.spellwheel.client.ui.action.OpenAction;
import dev.drtheo.spellwheel.client.ui.action.SwitchPageAction;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class SpellbookUtil {
    public static final Item DEFAULT_ICON = Items.f_42516_;

    public static Optional<WheelScreen> createWheel(Minecraft client) {
        ItemStack spellBook = SpellbookUtil.getSpellbook((Player)client.f_91074_);
        if (spellBook == null) {
            return Optional.empty();
        }
        int maxPage = ItemSpellbook.highestPage((ItemStack)spellBook);
        if (maxPage == 0) {
            return Optional.empty();
        }
        CompoundTag iotas = NBTHelper.getCompound((ItemStack)spellBook, (String)ItemSpellbook.TAG_PAGES);
        MutableComponent[] names = SpellbookUtil.getPageNames(spellBook);
        Widget[] widgets = maxPage > 8 ? SpellbookUtil.buildChapters(iotas, names, maxPage) : SpellbookUtil.buildPages(iotas, names, 0, maxPage);
        return Optional.of(new WheelScreen(WidgetSet.create(widgets)));
    }

    private static Widget[] buildChapters(CompoundTag iotas, MutableComponent[] names, int maxPages) {
        int chapters = Math.min((int)Math.ceil((double)maxPages / 8.0), 8);
        Widget[] widgets = new Widget[chapters];
        for (int i = 0; i < chapters; ++i) {
            int pageOffset = i * 8;
            int maxChapterPage = Math.min(pageOffset + 8, maxPages);
            MutableComponent label = I18n.chapter(i);
            for (int j = pageOffset; j < maxChapterPage; ++j) {
                int page = j + 1;
                if (!iotas.m_128441_(String.valueOf(page))) continue;
                label = label.m_7220_((Component)Component.m_237113_((String)"\n - ").m_7220_((Component)I18n.page(names[j], page)).m_130940_(ChatFormatting.GRAY));
            }
            label = I18n.numbered(i + 1, (Component)label);
            widgets[i] = new Widget((Component)label, Items.f_42517_, OpenAction.create(() -> SpellbookUtil.buildPages(iotas, names, pageOffset, maxPages)));
        }
        return widgets;
    }

    private static Widget[] buildPages(CompoundTag iotas, MutableComponent[] names, int start, int maxPages) {
        Widget[] widgets = new Widget[maxPages - start];
        for (int i = start; i < maxPages; ++i) {
            int page = i + 1;
            CompoundTag tag = (CompoundTag)iotas.m_128423_(String.valueOf(page));
            if (tag == null) continue;
            widgets[i - start] = SpellbookUtil.createPageWidget(names[i], tag, page, start);
        }
        return widgets;
    }

    private static Widget createPageWidget(@Nullable MutableComponent name, @Nullable CompoundTag iotas, int page, int offset) {
        MutableComponent label = I18n.numbered(page - offset, (Component)I18n.page(name, page));
        Item icon = WheelClientConfig.get().getIconOr((Component)name, DEFAULT_ICON);
        if (iotas != null) {
            Component displayIota = IotaType.getDisplay((CompoundTag)iotas);
            label.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{displayIota}));
        }
        return new Widget((Component)label, icon, new SwitchPageAction(page), new IconChangeAction((Component)name, DEFAULT_ICON, 0x7F0000));
    }

    public static ItemStack getSpellbook(Player player) {
        ItemStack offStack = player.m_21206_();
        if (offStack.m_41720_() instanceof ItemSpellbook) {
            return offStack;
        }
        ItemStack mainStack = player.m_21205_();
        if (mainStack.m_41720_() instanceof ItemSpellbook) {
            return mainStack;
        }
        return null;
    }

    public static MutableComponent[] getPageNames(ItemStack spellBook) {
        CompoundTag names = NBTHelper.getCompound((ItemStack)spellBook, (String)ItemSpellbook.TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, ItemSpellbook.highestPage((ItemStack)spellBook));
        MutableComponent[] components = new MutableComponent[shiftedIdx];
        for (int i = 1; i < shiftedIdx + 1; ++i) {
            String nameKey = String.valueOf(i);
            String name = NBTHelper.getString((CompoundTag)names, (String)nameKey);
            components[i - 1] = name == null ? null : Component.Serializer.m_130701_((String)name);
        }
        return components;
    }
}

