/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel;

import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import dev.drtheo.spellwheel.client.WheelKeybinds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class SpellWheelClient {
    public static void init() {
        WheelKeybinds.init();
    }

    public static ItemStack getSpellbook(Player player) {
        ItemStack offStack = player.m_21206_();
        if (offStack.m_41720_() instanceof ItemSpellbook) {
            return offStack;
        }
        ItemStack mainStack = player.m_21205_();
        if (mainStack.m_41720_() instanceof ItemSpellbook) {
            return mainStack;
        }
        return null;
    }

    public static boolean[] getRealPages(ItemStack spellBook) {
        CompoundTag data = NBTHelper.getCompound((ItemStack)spellBook, (String)ItemSpellbook.TAG_PAGES);
        int shiftedIdx = Math.max(1, ItemSpellbook.highestPage((ItemStack)spellBook));
        boolean[] result = new boolean[shiftedIdx];
        for (int i = 1; i < shiftedIdx + 1; ++i) {
            String nameKey = String.valueOf(i);
            result[i - 1] = data.m_128441_(nameKey);
        }
        return result;
    }

    public static MutableComponent[] getPageNames(ItemStack spellBook) {
        CompoundTag names = NBTHelper.getCompound((ItemStack)spellBook, (String)ItemSpellbook.TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, ItemSpellbook.highestPage((ItemStack)spellBook));
        MutableComponent[] components = new MutableComponent[shiftedIdx];
        for (int i = 1; i < shiftedIdx + 1; ++i) {
            String nameKey = String.valueOf(i);
            String name = NBTHelper.getString((CompoundTag)names, (String)nameKey);
            components[i - 1] = name == null ? null : Component.Serializer.m_130701_((String)name);
        }
        return components;
    }
}

