/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client;

import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.drtheo.spellwheel.SpellWheelClient;
import dev.drtheo.spellwheel.client.I18n;
import dev.drtheo.spellwheel.client.ui.WheelScreen;
import dev.drtheo.spellwheel.client.ui.Widget;
import dev.drtheo.spellwheel.client.ui.WidgetSet;
import dev.drtheo.spellwheel.client.ui.action.OpenAction;
import dev.drtheo.spellwheel.client.ui.action.SwitchPageAction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class WheelKeybinds {
    public static final KeyMapping OPEN_SPELL_WHEEL = new KeyMapping(I18n.key("open"), InputConstants.Type.KEYSYM, 96, I18n.keyCategory("main"));

    public static void init() {
        KeyMappingRegistry.register((KeyMapping)OPEN_SPELL_WHEEL);
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> {
            WheelScreen wheelScreen;
            block5: {
                block4: {
                    Screen patt0$temp = client.f_91080_;
                    if (!(patt0$temp instanceof WheelScreen)) break block4;
                    wheelScreen = (WheelScreen)patt0$temp;
                    if (action == 1) break block5;
                }
                return EventResult.pass();
            }
            if (keyCode < 49 || keyCode > 57) {
                return EventResult.pass();
            }
            wheelScreen.simulateClick(keyCode - 49);
            return EventResult.interruptDefault();
        });
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (minecraft.f_91074_ == null || minecraft.f_91080_ != null) {
                return;
            }
            if (!OPEN_SPELL_WHEEL.m_90859_()) {
                return;
            }
            ItemStack spellBook = SpellWheelClient.getSpellbook((Player)minecraft.f_91074_);
            if (spellBook == null) {
                return;
            }
            int maxPage = ItemSpellbook.highestPage((ItemStack)spellBook);
            if (maxPage == 0) {
                return;
            }
            boolean[] realPages = SpellWheelClient.getRealPages(spellBook);
            MutableComponent[] names = SpellWheelClient.getPageNames(spellBook);
            Widget[] widgets = maxPage > 8 ? WheelKeybinds.buildChapters(realPages, names, maxPage) : WheelKeybinds.buildPages(realPages, names, 0, maxPage);
            Minecraft.m_91087_().m_91152_((Screen)new WheelScreen(WidgetSet.create(widgets)));
        });
    }

    private static Widget[] buildChapters(boolean[] realPages, MutableComponent[] names, int maxPages) {
        int chapters = Math.min((int)Math.ceil((double)maxPages / 8.0), 8);
        Widget[] widgets = new Widget[chapters];
        for (int i = 0; i < chapters; ++i) {
            int pageOffset = i * 8;
            int maxChapterPage = Math.min(pageOffset + 8, realPages.length);
            MutableComponent prefix = Component.m_237113_((String)(i + 1 + ". ")).m_130940_(ChatFormatting.GRAY);
            MutableComponent label = I18n.chapter(i);
            for (int j = pageOffset; j < maxChapterPage; ++j) {
                if (!realPages[j]) continue;
                label = label.m_7220_((Component)Component.m_237113_((String)"\n - ").m_7220_((Component)(names[j] == null ? I18n.page(j) : names[j])).m_130940_(ChatFormatting.GRAY));
            }
            label = Component.m_237119_().m_7220_((Component)prefix).m_7220_((Component)label);
            widgets[i] = new Widget((Component)label, Items.f_42517_, OpenAction.create(() -> WheelKeybinds.buildPages(realPages, names, pageOffset, maxPages)));
        }
        return widgets;
    }

    private static Widget[] buildPages(boolean[] realPages, MutableComponent[] names, int start, int maxPages) {
        Widget[] widgets = new Widget[maxPages - start];
        for (int i = start; i < maxPages; ++i) {
            if (!realPages[i]) continue;
            MutableComponent prefix = Component.m_237113_((String)(i - start + 1 + ". ")).m_130940_(ChatFormatting.GRAY);
            MutableComponent label = I18n.page(i);
            if (names[i] != null) {
                label = names[i].m_130946_("\n").m_7220_((Component)label.m_130940_(ChatFormatting.GRAY));
            }
            label = Component.m_237119_().m_7220_((Component)prefix).m_7220_((Component)label);
            widgets[i - start] = new Widget((Component)label, Items.f_42516_, new SwitchPageAction(i + 1));
        }
        return widgets;
    }
}

