/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client.config;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.drtheo.spellwheel.SpellWheel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class WheelClientConfig {
    private static final String FILENAME = "hex-spell-wheel.txt";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("hex-spell-wheel.txt");
    private static WheelClientConfig INSTANCE;
    private final Map<String, Item> icons;

    public static void init() {
        ClientLifecycleEvent.CLIENT_STOPPING.register(instance -> {
            if (INSTANCE != null) {
                INSTANCE.write();
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(instance -> WheelClientConfig.get());
    }

    private WheelClientConfig() {
        this(new HashMap<String, Item>());
    }

    private WheelClientConfig(Map<String, Item> map) {
        this.icons = map;
    }

    public static WheelClientConfig get() {
        return INSTANCE == null ? (INSTANCE = WheelClientConfig.read()) : INSTANCE;
    }

    public static WheelClientConfig read() {
        try {
            HashMap<String, Item> icons = new HashMap<String, Item>();
            String prev = null;
            for (String s : (String[])Files.readString(CONFIG_PATH).lines().toArray(String[]::new)) {
                if (prev != null) {
                    icons.put(prev, (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)s)));
                    prev = null;
                    continue;
                }
                prev = s;
            }
            return new WheelClientConfig(icons);
        }
        catch (Exception e) {
            SpellWheel.LOGGER.error("Failed to read config", (Throwable)e);
            return new WheelClientConfig();
        }
    }

    private void write() {
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            StringBuilder result = new StringBuilder();
            this.icons.forEach((s, item) -> result.append((String)s).append('\n').append(item.arch$registryName()).append('\n'));
            Files.writeString(CONFIG_PATH, (CharSequence)result.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            SpellWheel.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public Item getIconOr(@Nullable Component name, Item def) {
        return Optional.ofNullable(name).map(Component::getString).flatMap(s -> Optional.ofNullable(this.icons.get(s))).orElse(def);
    }

    public void setIcon(Component name, Item item) {
        this.icons.put(name.getString(), item);
    }
}

