/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client.ui;

import dev.drtheo.spellwheel.client.I18n;
import dev.drtheo.spellwheel.client.ui.action.Action;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class Widget {
    private static final ItemStack EMPTY_STACK = new ItemStack((ItemLike)Items.f_42127_);
    public static final int NORMAL_COLOR = 0x2C2C2C;
    public static final int HOVER_COLOR = 3966247;
    private final Component label;
    private ItemStack preview;
    private final Action actions;
    private final boolean keepOpened;
    private int normalColor = 0x2C2C2C;
    private int hoverColor = 3966247;

    public Widget(Component label, ItemStack preview, Action actions, boolean keepOpened) {
        this.label = label;
        this.preview = preview;
        this.actions = actions;
        this.keepOpened = keepOpened;
    }

    public Widget(Component label, Item item, Action ... actions) {
        this(label, new ItemStack((ItemLike)item), Action.and(actions), false);
    }

    public void run(Minecraft client) {
        if (this.actions == null) {
            return;
        }
        this.actions.run(client, this);
    }

    public void runAlt(Minecraft client) {
        if (this.actions == null) {
            return;
        }
        this.actions.runAlt(client, this);
    }

    public static Widget empty() {
        return new Widget(I18n.emptyWidget(), EMPTY_STACK, null, true);
    }

    public Component label() {
        return this.label;
    }

    public ItemStack preview() {
        return this.preview;
    }

    public void setPreview(ItemStack preview) {
        this.preview = preview;
    }

    @Nullable
    public Action actions() {
        return this.actions;
    }

    public boolean keepOpened() {
        return this.keepOpened;
    }

    public int currentColor() {
        return this.normalColor;
    }

    public int hoverColor() {
        return this.hoverColor;
    }

    public void setNormalColor(int normalColor) {
        this.normalColor = normalColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Widget that = (Widget)obj;
        return Objects.equals(this.label, that.label) && Objects.equals(this.preview, that.preview) && Objects.equals(this.actions, that.actions) && this.keepOpened == that.keepOpened;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.preview, this.actions, this.keepOpened);
    }
}

