/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client;

import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.drtheo.spellwheel.SpellWheelClient;
import dev.drtheo.spellwheel.client.I18n;
import dev.drtheo.spellwheel.client.ui.WheelScreen;
import dev.drtheo.spellwheel.client.ui.Widget;
import dev.drtheo.spellwheel.client.ui.WidgetSet;
import dev.drtheo.spellwheel.client.ui.action.OpenAction;
import dev.drtheo.spellwheel.client.ui.action.SwitchPageAction;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class WheelKeybinds {
    public static final class_304 OPEN_SPELL_WHEEL = new class_304(I18n.key("open"), class_3675.class_307.field_1668, 96, I18n.keyCategory("main"));

    public static void init() {
        KeyMappingRegistry.register((class_304)OPEN_SPELL_WHEEL);
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> {
            WheelScreen wheelScreen;
            block5: {
                block4: {
                    class_437 patt0$temp = client.field_1755;
                    if (!(patt0$temp instanceof WheelScreen)) break block4;
                    wheelScreen = (WheelScreen)patt0$temp;
                    if (action == 1) break block5;
                }
                return EventResult.pass();
            }
            if (keyCode < 49 || keyCode > 57) {
                return EventResult.pass();
            }
            wheelScreen.simulateClick(keyCode - 49);
            return EventResult.interruptDefault();
        });
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (minecraft.field_1724 == null || minecraft.field_1755 != null) {
                return;
            }
            if (!OPEN_SPELL_WHEEL.method_1436()) {
                return;
            }
            class_1799 spellBook = SpellWheelClient.getSpellbook((class_1657)minecraft.field_1724);
            if (spellBook == null) {
                return;
            }
            int maxPage = ItemSpellbook.highestPage((class_1799)spellBook);
            if (maxPage == 0) {
                return;
            }
            boolean[] realPages = SpellWheelClient.getRealPages(spellBook);
            class_5250[] names = SpellWheelClient.getPageNames(spellBook);
            Widget[] widgets = maxPage > 8 ? WheelKeybinds.buildChapters(realPages, names, maxPage) : WheelKeybinds.buildPages(realPages, names, 0, maxPage);
            class_310.method_1551().method_1507((class_437)new WheelScreen(WidgetSet.create(widgets)));
        });
    }

    private static Widget[] buildChapters(boolean[] realPages, class_5250[] names, int maxPages) {
        int chapters = Math.min((int)Math.ceil((double)maxPages / 8.0), 8);
        Widget[] widgets = new Widget[chapters];
        for (int i = 0; i < chapters; ++i) {
            int pageOffset = i * 8;
            int maxChapterPage = Math.min(pageOffset + 8, realPages.length);
            class_5250 prefix = class_2561.method_43470((String)(i + 1 + ". ")).method_27692(class_124.field_1080);
            class_5250 label = I18n.chapter(i);
            for (int j = pageOffset; j < maxChapterPage; ++j) {
                if (!realPages[j]) continue;
                label = label.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_10852((class_2561)(names[j] == null ? I18n.page(j) : names[j])).method_27692(class_124.field_1080));
            }
            label = class_2561.method_43473().method_10852((class_2561)prefix).method_10852((class_2561)label);
            widgets[i] = new Widget((class_2561)label, class_1802.field_8529, OpenAction.create(() -> WheelKeybinds.buildPages(realPages, names, pageOffset, maxPages)));
        }
        return widgets;
    }

    private static Widget[] buildPages(boolean[] realPages, class_5250[] names, int start, int maxPages) {
        Widget[] widgets = new Widget[maxPages - start];
        for (int i = start; i < maxPages; ++i) {
            if (!realPages[i]) continue;
            class_5250 prefix = class_2561.method_43470((String)(i - start + 1 + ". ")).method_27692(class_124.field_1080);
            class_5250 label = I18n.page(i);
            if (names[i] != null) {
                label = names[i].method_27693("\n").method_10852((class_2561)label.method_27692(class_124.field_1080));
            }
            label = class_2561.method_43473().method_10852((class_2561)prefix).method_10852((class_2561)label);
            widgets[i - start] = new Widget((class_2561)label, class_1802.field_8407, new SwitchPageAction(i + 1));
        }
        return widgets;
    }
}

