/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client.config;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.drtheo.spellwheel.SpellWheel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WheelClientConfig {
    private static final String FILENAME = "hex-spell-wheel.txt";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("hex-spell-wheel.txt");
    private static WheelClientConfig INSTANCE;
    private final Map<String, class_1792> icons;

    public static void init() {
        ClientLifecycleEvent.CLIENT_STOPPING.register(instance -> {
            if (INSTANCE != null) {
                INSTANCE.write();
            }
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(instance -> WheelClientConfig.get());
    }

    private WheelClientConfig() {
        this(new HashMap<String, class_1792>());
    }

    private WheelClientConfig(Map<String, class_1792> map) {
        this.icons = map;
    }

    public static WheelClientConfig get() {
        return INSTANCE == null ? (INSTANCE = WheelClientConfig.read()) : INSTANCE;
    }

    public static WheelClientConfig read() {
        try {
            HashMap<String, class_1792> icons = new HashMap<String, class_1792>();
            String prev = null;
            for (String s : (String[])Files.readString(CONFIG_PATH).lines().toArray(String[]::new)) {
                if (prev != null) {
                    icons.put(prev, (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)s)));
                    prev = null;
                    continue;
                }
                prev = s;
            }
            return new WheelClientConfig(icons);
        }
        catch (Exception e) {
            SpellWheel.LOGGER.error("Failed to read config", (Throwable)e);
            return new WheelClientConfig();
        }
    }

    private void write() {
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            StringBuilder result = new StringBuilder();
            this.icons.forEach((s, item) -> result.append((String)s).append('\n').append(item.arch$registryName()).append('\n'));
            Files.writeString(CONFIG_PATH, (CharSequence)result.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            SpellWheel.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public class_1792 getIconOr(@Nullable class_2561 name, class_1792 def) {
        return Optional.ofNullable(name).map(class_2561::getString).flatMap(s -> Optional.ofNullable(this.icons.get(s))).orElse(def);
    }

    public void setIcon(class_2561 name, class_1792 item) {
        this.icons.put(name.getString(), item);
    }
}

