/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.spellwheel.client.util;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import dev.drtheo.spellwheel.client.I18n;
import dev.drtheo.spellwheel.client.config.WheelClientConfig;
import dev.drtheo.spellwheel.client.ui.WheelScreen;
import dev.drtheo.spellwheel.client.ui.Widget;
import dev.drtheo.spellwheel.client.ui.WidgetSet;
import dev.drtheo.spellwheel.client.ui.action.IconChangeAction;
import dev.drtheo.spellwheel.client.ui.action.OpenAction;
import dev.drtheo.spellwheel.client.ui.action.SwitchPageAction;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SpellbookUtil {
    public static final class_1792 DEFAULT_ICON = class_1802.field_8407;

    public static Optional<WheelScreen> createWheel(class_310 client) {
        class_1799 spellBook = SpellbookUtil.getSpellbook((class_1657)client.field_1724);
        if (spellBook == null) {
            return Optional.empty();
        }
        int maxPage = ItemSpellbook.highestPage((class_1799)spellBook);
        if (maxPage == 0) {
            return Optional.empty();
        }
        class_2487 iotas = NBTHelper.getCompound((class_1799)spellBook, (String)ItemSpellbook.TAG_PAGES);
        class_5250[] names = SpellbookUtil.getPageNames(spellBook);
        Widget[] widgets = maxPage > 8 ? SpellbookUtil.buildChapters(iotas, names, maxPage) : SpellbookUtil.buildPages(iotas, names, 0, maxPage);
        return Optional.of(new WheelScreen(WidgetSet.create(widgets)));
    }

    private static Widget[] buildChapters(class_2487 iotas, class_5250[] names, int maxPages) {
        int chapters = Math.min((int)Math.ceil((double)maxPages / 8.0), 8);
        Widget[] widgets = new Widget[chapters];
        for (int i = 0; i < chapters; ++i) {
            int pageOffset = i * 8;
            int maxChapterPage = Math.min(pageOffset + 8, maxPages);
            class_5250 label = I18n.chapter(i);
            for (int j = pageOffset; j < maxChapterPage; ++j) {
                int page = j + 1;
                if (!iotas.method_10545(String.valueOf(page))) continue;
                label = label.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_10852((class_2561)I18n.page(names[j], page)).method_27692(class_124.field_1080));
            }
            label = I18n.numbered(i + 1, (class_2561)label);
            widgets[i] = new Widget((class_2561)label, class_1802.field_8529, OpenAction.create(() -> SpellbookUtil.buildPages(iotas, names, pageOffset, maxPages)));
        }
        return widgets;
    }

    private static Widget[] buildPages(class_2487 iotas, class_5250[] names, int start, int maxPages) {
        Widget[] widgets = new Widget[maxPages - start];
        for (int i = start; i < maxPages; ++i) {
            int page = i + 1;
            class_2487 tag = (class_2487)iotas.method_10580(String.valueOf(page));
            if (tag == null) continue;
            widgets[i - start] = SpellbookUtil.createPageWidget(names[i], tag, page, start);
        }
        return widgets;
    }

    private static Widget createPageWidget(@Nullable class_5250 name, @Nullable class_2487 iotas, int page, int offset) {
        class_5250 label = I18n.numbered(page - offset, (class_2561)I18n.page(name, page));
        class_1792 icon = WheelClientConfig.get().getIconOr((class_2561)name, DEFAULT_ICON);
        if (iotas != null) {
            class_2561 displayIota = IotaType.getDisplay((class_2487)iotas);
            label.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"hexcasting.spelldata.onitem", (Object[])new Object[]{displayIota}));
        }
        return new Widget((class_2561)label, icon, new SwitchPageAction(page), new IconChangeAction((class_2561)name, DEFAULT_ICON, 0x7F0000));
    }

    public static class_1799 getSpellbook(class_1657 player) {
        class_1799 offStack = player.method_6079();
        if (offStack.method_7909() instanceof ItemSpellbook) {
            return offStack;
        }
        class_1799 mainStack = player.method_6047();
        if (mainStack.method_7909() instanceof ItemSpellbook) {
            return mainStack;
        }
        return null;
    }

    public static class_5250[] getPageNames(class_1799 spellBook) {
        class_2487 names = NBTHelper.getCompound((class_1799)spellBook, (String)ItemSpellbook.TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, ItemSpellbook.highestPage((class_1799)spellBook));
        class_5250[] components = new class_5250[shiftedIdx];
        for (int i = 1; i < shiftedIdx + 1; ++i) {
            String nameKey = String.valueOf(i);
            String name = NBTHelper.getString((class_2487)names, (String)nameKey);
            components[i - 1] = name == null ? null : class_2561.class_2562.method_10877((String)name);
        }
        return components;
    }
}

