/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.base;

import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.block.base.IVsswSyncBe;
import net.shao.valkyrien_space_war.block.base.RedStoneBlockUtil;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.impl.config.VSCoreConfig;

public abstract class ModConnectorBE
extends BlockEntity
implements IVsswSyncBe {
    public static final CopyOnWriteArrayList<ModConnectorBE> ALL_CONNECTOR_BE = new CopyOnWriteArrayList();
    protected boolean needSyncToClient = false;
    protected final int physicsTicksPerGameTick;
    protected final Vec3 blockCenter;
    private boolean isFirstTick = true;

    public abstract ConnectorType getBeType();

    public ModConnectorBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        ModResourceManager.allConnectorBe.add(this);
        this.physicsTicksPerGameTick = VSCoreConfig.SERVER.getPt().getPhysicsTicksPerGameTick();
        this.blockCenter = pPos.m_252807_();
        ALL_CONNECTOR_BE.add(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTick() {
    }

    public ServerShip getServerShip() {
        return VsUtil.getShip((ServerLevel)this.f_58857_, this.m_58899_());
    }

    public Ship getShip() {
        return VsUtil.getShip(this.f_58857_, this.m_58899_());
    }

    public void tick(Level pLevel1, BlockPos pPos, BlockState pState1) {
        if (this.isFirstTick) {
            this.isFirstTick = false;
            RedStoneBlockUtil.onNeighborChanged(this.f_58857_, pPos);
        }
    }

    public void onActivationChanged(int power) {
    }

    public void tickEnd() {
        if (this.needSyncToClient) {
            this.sendUpdatePacket();
            this.needSyncToClient = false;
        }
    }

    @Override
    public void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.needSyncToClient = true;
        }
    }

    protected void sendUpdatePacket() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(player -> player.f_8906_.m_9829_((Packet)packet));
        }
    }

    public Vec3 getBlockCenter() {
        return this.blockCenter;
    }

    protected void putTag(CompoundTag tag) {
    }

    protected void loadTag(CompoundTag tag) {
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.putTag(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.putTag(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.loadTag(tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientShip getClientShip() {
        BlockPos blockPos = this.m_58899_();
        return VsUtil.getClientShip(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static enum ConnectorType {
        FLIGHT_CONTROL,
        SEAT,
        MONITOR,
        RADAR,
        TURRET,
        ENERGY_SHIELD,
        THRUSTER,
        BEARING;

    }
}

