/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.base;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModHostBE;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.function.rs_channel.RsChannelManager;
import net.shao.valkyrien_space_war.function.schematic.ICopyableBE;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ServerShip;

public abstract class ModGuestBE
extends ModConnectorBE
implements ICopyableBE {
    public static Set<ModGuestBE> activeBE = ConcurrentHashMap.newKeySet();
    protected BlockPos parent;
    protected ModHostBE parentBE;
    protected AbstractFlightControlBE parentFCBE;

    public ModGuestBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_7651_() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                activeBE.remove(this);
            } else {
                if (((ServerLevel)this.f_58857_).m_7654_().m_129918_()) {
                    return;
                }
                if (this.parentBE != null && !this.parentBE.m_58901_()) {
                    this.parentBE.removeChildren(this.m_58899_());
                }
            }
        }
        super.m_7651_();
    }

    public AbstractFlightControlBE getFlightControl() {
        if ((this.parentFCBE == null || this.parentFCBE.m_58901_()) && this.getParentBE() != null && this.parentBE.getBeType() == ModConnectorBE.ConnectorType.FLIGHT_CONTROL) {
            this.parentFCBE = (AbstractFlightControlBE)this.parentBE;
        }
        return this.parentFCBE;
    }

    public BlockPos getParent() {
        return this.parent == null ? null : new BlockPos(this.f_58858_.m_123341_() + this.parent.m_123341_(), this.f_58858_.m_123342_() + this.parent.m_123342_(), this.f_58858_.m_123343_() + this.parent.m_123343_());
    }

    public ModHostBE getParentBE() {
        if (this.m_58904_() == null) {
            return null;
        }
        if (this.getParent() == null) {
            this.parentBE = null;
            return null;
        }
        if (this.parentBE == null) {
            if (this.m_58904_().f_46443_) {
                BlockEntity blockEntity = this.m_58904_().m_7702_(this.getParent());
                if (blockEntity instanceof ModHostBE) {
                    ModHostBE host;
                    this.parentBE = host = (ModHostBE)blockEntity;
                }
            } else {
                this.m_58904_().m_7654_().execute(() -> {
                    BlockEntity patt2779$temp = this.m_58904_().m_7702_(this.getParent());
                    if (patt2779$temp instanceof ModHostBE) {
                        ModHostBE host;
                        this.parentBE = host = (ModHostBE)patt2779$temp;
                    }
                });
            }
        }
        return this.parentBE;
    }

    public void setParent(BlockPos parent) {
        this.parent = parent.m_121996_((Vec3i)this.f_58858_);
        this.syncToClient();
    }

    public void removeParent() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            activeBE.remove(this);
        }
        this.onParentChange();
        this.syncToClient();
    }

    protected void onParentChange() {
        this.parent = null;
        this.parentBE = null;
        this.parentFCBE = null;
    }

    @Override
    protected void putTag(CompoundTag tag) {
        if (this.parent != null) {
            tag.m_128379_("hasParent", true);
            tag.m_128405_("parentX", this.parent.m_123341_());
            tag.m_128405_("parentY", this.parent.m_123342_());
            tag.m_128405_("parentZ", this.parent.m_123343_());
        } else {
            tag.m_128379_("hasParent", false);
        }
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        if (tag.m_128471_("hasParent")) {
            this.parent = new BlockPos(tag.m_128451_("parentX"), tag.m_128451_("parentY"), tag.m_128451_("parentZ"));
            if (this.f_58857_ != null) {
                BlockPos bePos = new BlockPos(this.f_58858_.m_123341_() + this.parent.m_123341_(), this.f_58858_.m_123342_() + this.parent.m_123342_(), this.f_58858_.m_123343_() + this.parent.m_123343_());
                this.parentBE = (ModHostBE)this.f_58857_.m_7702_(bePos);
            }
            activeBE.add(this);
        } else {
            this.parent = null;
            activeBE.remove(this);
        }
    }

    @Override
    public void onCopy(ServerLevel level, BlockPos pos, BlockState state, CompoundTag tag) {
        this.putTag(tag);
        if (tag.m_128471_("hasParent")) {
            ModHostBE parent = this.getParentBE();
            if (parent == null) {
                return;
            }
            ServerShip ship = parent.getServerShip();
            if (ship == null) {
                return;
            }
            Vector3d aabbCenter = ship.getShipAABB().center(new Vector3d());
            BlockPos offset = new BlockPos((Vec3i)parent.m_58899_()).m_121996_((Vec3i)new BlockPos((int)aabbCenter.x, (int)aabbCenter.y, (int)aabbCenter.z));
            tag.m_128356_("shipId", ship.getId());
            tag.m_128405_("parentX", offset.m_123341_());
            tag.m_128405_("parentY", offset.m_123342_());
            tag.m_128405_("parentZ", offset.m_123343_());
        }
    }

    @Override
    public void onPaste(ServerLevel level, Map<Long, ServerShip> newShips, Map<Long, AABB> newShipAABBs, BlockPos pos, BlockState state, CompoundTag tag) {
        long oldId;
        RsChannelManager.onPaste(this, level, newShips, newShipAABBs, pos, state, tag);
        if (tag.m_128471_("hasParent") && tag.m_128441_("shipId") && newShipAABBs.containsKey(oldId = tag.m_128454_("shipId"))) {
            BlockPos oldOffset = new BlockPos(tag.m_128451_("parentX"), tag.m_128451_("parentY"), tag.m_128451_("parentZ"));
            Vec3 newCenter = newShipAABBs.get(oldId).m_82399_();
            BlockPos newBlockPos = new BlockPos((int)newCenter.f_82479_, (int)newCenter.f_82480_, (int)newCenter.f_82481_).m_121955_((Vec3i)oldOffset);
            BlockPos newOffset = newBlockPos.m_121996_((Vec3i)pos);
            tag.m_128405_("parentX", newOffset.m_123341_());
            tag.m_128405_("parentY", newOffset.m_123342_());
            tag.m_128405_("parentZ", newOffset.m_123343_());
        }
    }
}

