/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.base;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.function.rs_channel.RsChannelManager;
import net.shao.valkyrien_space_war.function.schematic.ICopyableBE;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ServerShip;

public abstract class ModHostBE
extends ModConnectorBE
implements ICopyableBE {
    private HashSet<BlockPos> children = new HashSet();

    public ModHostBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public boolean addChild(BlockPos pos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        boolean add = this.children.add(pos.m_121996_((Vec3i)this.f_58858_));
        this.syncToClient();
        return add;
    }

    public HashSet<BlockPos> getChildren() {
        return this.children;
    }

    public void removeChildren(BlockPos pos) {
        this.children.remove(pos.m_121996_((Vec3i)this.f_58858_));
        this.syncToClient();
    }

    public HashSet<ModGuestBE> getChildrenBE() {
        HashSet<ModGuestBE> childrenBE = new HashSet<ModGuestBE>();
        if (this.m_58904_() != null) {
            for (BlockPos child : this.children) {
                BlockEntity blockEntity;
                BlockPos bePos = new BlockPos(this.f_58858_.m_123341_() + child.m_123341_(), this.f_58858_.m_123342_() + child.m_123342_(), this.f_58858_.m_123343_() + child.m_123343_());
                if (!this.m_58904_().m_46749_(bePos) || !((blockEntity = this.m_58904_().m_7702_(bePos)) instanceof ModGuestBE)) continue;
                ModGuestBE be = (ModGuestBE)blockEntity;
                childrenBE.add(be);
            }
        }
        return childrenBE;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (((ServerLevel)this.m_58904_()).m_7654_().m_129918_()) {
            return;
        }
        this.getChildrenBE().forEach(ModGuestBE::removeParent);
        this.onBreak();
    }

    protected void onBreak() {
    }

    @Override
    protected void putTag(CompoundTag tag) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.children) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("children", (Tag)list);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        ListTag list = tag.m_128437_("children", 10);
        this.children.clear();
        for (Tag entry : list) {
            CompoundTag posTag = (CompoundTag)entry;
            BlockPos pos = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
            this.children.add(pos);
        }
    }

    @Override
    public void onCopy(ServerLevel level, BlockPos pos, BlockState state, CompoundTag tag) {
        this.putTag(tag);
        ListTag list = new ListTag();
        for (BlockPos child : this.children) {
            BlockPos bePos = new BlockPos(this.f_58858_.m_123341_() + child.m_123341_(), this.f_58858_.m_123342_() + child.m_123342_(), this.f_58858_.m_123343_() + child.m_123343_());
            BlockEntity blockEntity = level.m_7702_(bePos);
            if (!(blockEntity instanceof ModGuestBE)) continue;
            ModGuestBE be = (ModGuestBE)blockEntity;
            ServerShip ship = be.getServerShip();
            if (ship != null) {
                Vector3d aabbCenter = ship.getShipAABB().center(new Vector3d());
                BlockPos offset = new BlockPos((Vec3i)bePos).m_121996_((Vec3i)new BlockPos((int)aabbCenter.x, (int)aabbCenter.y, (int)aabbCenter.z));
                CompoundTag posTag = new CompoundTag();
                posTag.m_128356_("shipId", ship.getId());
                posTag.m_128405_("x", offset.m_123341_());
                posTag.m_128405_("y", offset.m_123342_());
                posTag.m_128405_("z", offset.m_123343_());
                list.add((Object)posTag);
                continue;
            }
            CompoundTag posTag = new CompoundTag();
            posTag.m_128356_("shipId", -1L);
            posTag.m_128405_("x", bePos.m_123341_());
            posTag.m_128405_("y", bePos.m_123342_());
            posTag.m_128405_("z", bePos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("children", (Tag)list);
    }

    @Override
    public void onPaste(ServerLevel level, Map<Long, ServerShip> newShips, Map<Long, AABB> newShipAABBs, BlockPos pos, BlockState state, CompoundTag tag) {
        RsChannelManager.onPaste(this, level, newShips, newShipAABBs, pos, state, tag);
        ListTag origList = tag.m_128437_("children", 10);
        ListTag newList = new ListTag();
        for (Tag entry : origList) {
            CompoundTag origPosTag = (CompoundTag)entry;
            if (origPosTag.m_128441_("shipId") && origPosTag.m_128454_("shipId") != -1L) {
                long oldId = origPosTag.m_128454_("shipId");
                if (!newShipAABBs.containsKey(oldId)) continue;
                Vec3 newCenter = newShipAABBs.get(oldId).m_82399_();
                BlockPos oldOffset = new BlockPos(origPosTag.m_128451_("x"), origPosTag.m_128451_("y"), origPosTag.m_128451_("z"));
                BlockPos newBlockPos = new BlockPos((int)newCenter.f_82479_, (int)newCenter.f_82480_, (int)newCenter.f_82481_).m_121955_((Vec3i)oldOffset);
                BlockPos newOffset = newBlockPos.m_121996_((Vec3i)pos);
                System.out.println("newOffset: " + newOffset);
                CompoundTag newPosTag = new CompoundTag();
                newPosTag.m_128405_("x", newOffset.m_123341_());
                newPosTag.m_128405_("y", newOffset.m_123342_());
                newPosTag.m_128405_("z", newOffset.m_123343_());
                newList.add((Object)newPosTag);
                continue;
            }
            CompoundTag newPosTag = new CompoundTag();
            newPosTag.m_128405_("x", origPosTag.m_128451_("x"));
            newPosTag.m_128405_("y", origPosTag.m_128451_("y"));
            newPosTag.m_128405_("z", origPosTag.m_128451_("z"));
            newList.add((Object)newPosTag);
        }
        tag.m_128365_("children", (Tag)newList);
    }
}

