/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.energy_shield;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShield;
import net.shao.valkyrien_space_war.block.energy_shield.EnergyShieldMenu;
import net.shao.valkyrien_space_war.compat.fe.FeStorageCapability;
import net.shao.valkyrien_space_war.compat.gregtech.GtEnergyCapability;
import net.shao.valkyrien_space_war.compat.gregtech.GtEnergyContainerProxy;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.item.handler.LimitedItemStackHandler;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.shield.PacketEnergyShieldData;
import net.shao.valkyrien_space_war.sound.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.Ship;

public class AbstractEnergyShieldBE
extends ModGuestBE
implements MenuProvider {
    public final LimitedItemStackHandler itemHandler = new LimitedItemStackHandler(1, 1);
    private LazyOptional<IItemHandler> itemOptional = LazyOptional.of(() -> this.itemHandler);
    public static final ModConnectorBE.ConnectorType type = ModConnectorBE.ConnectorType.ENERGY_SHIELD;
    private List<ClientShield> clientShields;
    private final List<Runnable> scheduledTasks = new LinkedList<Runnable>();
    private float range = 10.0f;
    private boolean autoRange = true;
    private float lastRange = 10.0f;
    private int color0;
    private int color1;
    private final long energyCapacity;
    private final int voltageLevel;
    public final ResourceLocation texture;
    protected GtEnergyCapability gtEnergyCapability;
    protected FeStorageCapability feStorageCapability;
    protected LazyOptional<IEnergyStorage> feEnergyHandler;

    public AbstractEnergyShieldBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MY_TEST_MACHINE_BE.get(), pPos, pBlockState);
        Block block = pBlockState.m_60734_();
        if (block instanceof AbstractEnergyShield) {
            AbstractEnergyShield shieldBlock = (AbstractEnergyShield)block;
            this.energyCapacity = shieldBlock.getEnergyCapacity();
            this.voltageLevel = shieldBlock.getVoltageLevel();
            this.texture = shieldBlock.getTexture();
        } else {
            this.energyCapacity = 0L;
            this.voltageLevel = 0;
            this.texture = new ResourceLocation("textures/block/my_test_machine.png");
        }
        this.clientShields = new LinkedList<ClientShield>();
        this.gtEnergyCapability = GtEnergyContainerProxy.create(this);
    }

    public void onLoad() {
        super.onLoad();
        this.itemOptional = LazyOptional.of(() -> this.itemHandler);
        this.feStorageCapability = new FeStorageCapability(this, (int)Math.min(this.getEnergyCapacity() * 4L, Integer.MAX_VALUE), this.getVoltageLevel(), Math.min(this.getInputAmperage(), Integer.MAX_VALUE));
        this.feEnergyHandler = LazyOptional.of(() -> this.feStorageCapability);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemOptional.cast();
        }
        if (this.gtEnergyCapability != null && this.gtEnergyCapability.isGtEnergyCap(cap)) {
            return this.gtEnergyCapability.getGtEnergyCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemOptional.invalidate();
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.invalidate();
        }
    }

    public long getEnergyStored() {
        return this.gtEnergyCapability == null ? (long)this.feStorageCapability.getGtEnergyStored() : this.gtEnergyCapability.getEnergyStored();
    }

    protected long changeEnergy(long l) {
        if (this.gtEnergyCapability != null) {
            return this.gtEnergyCapability.changeEnergy(l);
        }
        return this.feStorageCapability.changeEnergyFromGt(l);
    }

    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    public int getVoltageLevel() {
        return this.voltageLevel;
    }

    public long getInputAmperage() {
        return 2L;
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        super.tick(pLevel, pPos, pState);
        while (!this.scheduledTasks.isEmpty()) {
            this.scheduledTasks.remove(0).run();
        }
        this.shield_check(pLevel, pPos, pState);
    }

    public void shield_check(Level pLevel, BlockPos pPos, BlockState pState) {
        HashMap projectiles = ModResourceManager.allProjectiles.computeIfAbsent(pLevel, k -> new HashMap());
        boolean isOnShip = this.isOnShip();
        if (!projectiles.isEmpty()) {
            float finalRange;
            Vec3 coordinate = this.getShieldCenter();
            if (this.autoRange) {
                float f = finalRange = isOnShip ? this.getShipShieldRange() : this.range;
                if (this.lastRange != finalRange) {
                    this.setRange(finalRange);
                }
            } else {
                finalRange = this.range;
            }
            this.lastRange = finalRange;
            projectiles.forEach((id, projectile) -> {
                Vec3 velocity;
                Vec3 next;
                Vec3 v = new Vec3(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
                int lineIntersectingSphere = ModMathUtil.checkLineSphereRelation(v, next = v.m_82549_(velocity = projectile.m_20184_()), coordinate, finalRange);
                if (lineIntersectingSphere > 0) {
                    boolean isApproaching;
                    Vec3 intersection = ModMathUtil.intersectionCalculator(coordinate, finalRange, v, velocity);
                    float speed = (float)velocity.m_82553_();
                    boolean bl = isApproaching = lineIntersectingSphere == 1;
                    if (isApproaching) {
                        Vec3 normal = intersection.m_82546_(coordinate).m_82541_();
                        Vec3 reflectedVelocity = velocity.m_82546_(normal.m_82490_(2.0 * velocity.m_82526_(normal)));
                        double length = v.m_82546_(intersection).m_82553_();
                        projectile.m_20256_(velocity.m_82541_().m_82490_(length));
                        Vec3 tmp = intersection;
                        this.scheduledTasks.add(() -> {
                            projectile.m_146884_(tmp);
                            projectile.m_20256_(reflectedVelocity);
                        });
                    }
                    this.genShield(intersection, speed, isApproaching);
                }
            });
        }
    }

    public void genShield(Vec3 intersection, float speed, boolean isApproaching) {
        Vec3 dir;
        if (this.f_58857_ == null) {
            return;
        }
        Vec3 coordinate = this.getShieldCenter();
        if (this.isOnShip()) {
            Ship ship = this.getShip();
            Matrix4dc worldToShip = ship.getWorldToShip();
            Vector3d vector3d = worldToShip.transformProject(new Vector3d(intersection.f_82479_, intersection.f_82480_, intersection.f_82481_));
            intersection = new Vec3(vector3d.x, vector3d.y, vector3d.z);
            Vector3d shieldCenter = worldToShip.transformPosition(coordinate.m_7096_(), coordinate.m_7098_(), coordinate.m_7094_(), new Vector3d());
            dir = intersection.m_82492_(shieldCenter.x(), shieldCenter.y(), shieldCenter.z()).m_82541_();
        } else {
            dir = intersection.m_82492_(coordinate.m_7096_(), coordinate.m_7098_(), coordinate.m_7094_()).m_82541_();
        }
        float yaw = (float)Math.atan2(-dir.m_7096_(), dir.m_7094_());
        float pitch = (float)Math.asin(dir.m_7098_());
        int maxLifeTime = (int)(speed / (float)this.getVoltageLevel() * 3.0f);
        maxLifeTime = Math.max(Math.min(maxLifeTime, 38), 12);
        ModNetworkHandler.sendToNearbyPlayers(128, this.f_58857_, this.m_58899_(), new PacketEnergyShieldData(this.m_58899_(), yaw, pitch, maxLifeTime, isApproaching));
        float volume = speed / 3.0f;
        volume = Math.min(Math.max(volume, 0.5f), 3.0f);
        if (isApproaching) {
            this.f_58857_.m_6263_(null, intersection.f_82479_, intersection.f_82480_, intersection.f_82481_, (SoundEvent)ModSounds.ENERGY_SHIELD.get(), SoundSource.BLOCKS, volume, 1.0f);
        }
    }

    public void setRange(float range) {
        this.range = range;
        this.syncToClient();
    }

    public float getRange() {
        return this.range;
    }

    public void setAutoRange(boolean autoRange) {
        this.autoRange = autoRange;
        this.syncToClient();
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void addClientShield(ClientShield clientShield) {
        this.clientShields.add(clientShield);
    }

    public void addClientShield(float yaw, float pitch, int maxLifeTime, boolean isApproaching) {
        this.clientShields.add(new ClientShield(yaw, pitch, maxLifeTime, isApproaching));
    }

    public List<ClientShield> getClientShields() {
        return this.clientShields;
    }

    private boolean isOnShip() {
        return this.getShip() != null;
    }

    public Vec3 getShieldCenter() {
        if (this.isOnShip()) {
            return AbstractEnergyShieldBE.getAABBdcCenter(this.getShip().getWorldAABB());
        }
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
    }

    public Vec3 getShieldCenterOnShip() {
        if (this.isOnShip()) {
            Vec3 aabBdcCenter = AbstractEnergyShieldBE.getAABBdcCenter(this.getClientShip().getWorldAABB());
            Vector3d vector3d = this.getClientShip().getTransform().getWorldToShip().transformPosition(aabBdcCenter.f_82479_, aabBdcCenter.f_82480_, aabBdcCenter.f_82481_, new Vector3d());
            return new Vec3(vector3d.x, vector3d.y, vector3d.z);
        }
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
    }

    private static Vec3 getAABBdcCenter(AABBdc aabb) {
        double width = aabb.maxX() - aabb.minX();
        double len = aabb.maxZ() - aabb.minZ();
        double hight = aabb.maxY() - aabb.minY();
        double centerX = aabb.minX() + width / 2.0;
        double centerY = aabb.minY() + hight / 2.0;
        double centerZ = aabb.minZ() + len / 2.0;
        return new Vec3(centerX, centerY, centerZ);
    }

    private float getShipShieldRange() {
        if (this.isOnShip()) {
            AABBic shipAABB = this.getServerShip().getShipAABB();
            double maxSize = Math.max(Math.max(shipAABB.maxX() - shipAABB.minX(), shipAABB.maxZ() - shipAABB.minZ()), shipAABB.maxY() - shipAABB.minY());
            return (float)(maxSize / 2.0 + 2.0);
        }
        return this.range;
    }

    private static double sin2cos(double sin) {
        return Math.sqrt(1.0 - sin * sin);
    }

    public void drops() {
        int count = this.itemHandler.getSlots();
        SimpleContainer inventory = new SimpleContainer(count);
        for (int i = 0; i < count; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128350_("Range", this.range);
        tag.m_128379_("Auto", this.autoRange);
        tag.m_128405_("Color0", this.color0);
        tag.m_128405_("Color1", this.color1);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.putTag(tag);
        } else {
            this.feStorageCapability.putTag(tag);
        }
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.range = tag.m_128457_("Range");
        this.autoRange = tag.m_128471_("Auto");
        this.color0 = tag.m_128451_("Color0");
        this.color1 = tag.m_128451_("Color1");
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.loadTag(tag);
        } else {
            this.feStorageCapability.loadTag(tag);
        }
    }

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return type;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Energy Shield");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new EnergyShieldMenu(pContainerId, pPlayerInventory, this);
    }

    public static class ClientShield {
        private final long startTime;
        public final float yaw;
        public final float pitch;
        public final int maxLifeFrame;
        public final boolean isApproaching;

        public ClientShield(float yaw, float pitch, int maxLifeFrame, boolean isApproaching) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.maxLifeFrame = maxLifeFrame;
            this.isApproaching = isApproaching;
            this.startTime = System.currentTimeMillis();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean isAlive() {
            return (System.currentTimeMillis() - this.startTime) / 20L < (long)this.maxLifeFrame;
        }
    }
}

