/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.energy_shield;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShieldBE;
import net.shao.valkyrien_space_war.function.render.BakedModelRenderer;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import org.joml.Quaternionf;

public class AbstractEnergyShieldBERenderer
implements BlockEntityRenderer<AbstractEnergyShieldBE> {
    public static ResourceLocation ENERGY_SHIELD_MODEL_LOCATION = new ResourceLocation("valkyrien_space_war", "shield/energy_shield");
    public static BakedModel SHIELD_MODEL;
    public static final int MODEL_COUNT = 38;
    public static BakedModel[] animModels;
    public static ResourceLocation[] ENERGY_SHIELD__MODEL_LOCATIONS;
    private ModelBlockRenderer modelRenderer;
    private static final RenderType RENDER_TYPE;
    private long timeFlag;

    public AbstractEnergyShieldBERenderer(BlockEntityRendererProvider.Context context) {
        this.modelRenderer = context.m_173584_().m_110937_();
        this.timeFlag = System.currentTimeMillis();
    }

    public int m_142163_() {
        return 1024;
    }

    public void render(AbstractEnergyShieldBE be, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int packedLight, int packedOverlay) {
        Level level = be.m_58904_();
        if (level == null || SHIELD_MODEL == null) {
            return;
        }
        List<AbstractEnergyShieldBE.ClientShield> clientShields = be.getClientShields();
        clientShields.removeIf(reboundData -> !reboundData.isAlive());
        if (clientShields.isEmpty()) {
            return;
        }
        VertexConsumer buffer = pBufferSource.m_6299_(RENDER_TYPE);
        float scale = be.getRange() / 10.0f;
        BlockPos blockPos = be.m_58899_();
        Vec3 offset = be.getShieldCenterOnShip().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        poseStack.m_85836_();
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        poseStack.m_85841_(scale, scale, scale);
        for (AbstractEnergyShieldBE.ClientShield clientShield : clientShields) {
            if (!clientShield.isApproaching) continue;
            this.renderEnergyShield(poseStack, buffer, 0xF000F0, packedOverlay, clientShield);
        }
        poseStack.m_85849_();
    }

    private void renderEnergyShield(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, AbstractEnergyShieldBE.ClientShield clientShield) {
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotationY(-clientShield.yaw));
        poseStack.m_252781_(new Quaternionf().rotationX(-clientShield.pitch));
        long frame = (System.currentTimeMillis() - clientShield.getStartTime()) / 20L % 38L;
        if (frame > (long)clientShield.maxLifeFrame) {
            return;
        }
        float opa = 1.0f - (float)frame / (float)clientShield.maxLifeFrame;
        opa = opa > 1.0f ? 1.0f : (opa < 0.0f ? 0.0f : opa);
        BakedModelRenderer.renderWithAlpha(poseStack.m_85850_(), buffer, null, animModels[(int)frame], 0.1f, 0.8f, 0.7f, 0.25f * opa, packedLight, packedOverlay);
        poseStack.m_85841_(0.95f, 0.95f, 0.95f);
        long frame2 = (System.currentTimeMillis() - clientShield.getStartTime() + 40L) / 20L % 38L;
        BakedModelRenderer.renderWithAlpha(poseStack.m_85850_(), buffer, null, animModels[(int)frame2], 0.1f, 0.6f, 0.9f, 0.5f * opa, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    static {
        animModels = new BakedModel[38];
        ENERGY_SHIELD__MODEL_LOCATIONS = new ResourceLocation[38];
        for (int i = 0; i < 38; ++i) {
            AbstractEnergyShieldBERenderer.ENERGY_SHIELD__MODEL_LOCATIONS[i] = new ResourceLocation("valkyrien_space_war", "shield/energy_shield_" + (i + 1));
        }
        RENDER_TYPE = CustomRenderTypes.createObjModelRenderType();
    }
}

