/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.energy_shield;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.shao.valkyrien_space_war.block.energy_shield.AbstractEnergyShieldBE;
import net.shao.valkyrien_space_war.block.energy_shield.EnergyShieldMenu;
import net.shao.valkyrien_space_war.compat.gregtech.GTValuesDup;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.shield.SetEnergyShieldAutoRangePacket;
import net.shao.valkyrien_space_war.network.shield.SetEnergyShieldRangePacket;

public class EnergyShieldScreen
extends AbstractContainerScreen<EnergyShieldMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/energy_shield_gui.png");
    private static final ResourceLocation ENERGY_GRADIENT = new ResourceLocation("valkyrien_space_war", "textures/gui/turret/energy_gradient.png");
    private static final String RANGE_LABEL = ChatFormatting.DARK_GRAY + ChatFormatting.BOLD + Component.m_237115_((String)"gui.valkyrien_space_war.shield_range").getString();
    private Button autoRange;
    private EditBox range;
    private AbstractEnergyShieldBE be;
    private ImageWidget energyGradient;
    private int x;
    private int y;

    public EnergyShieldScreen(EnergyShieldMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.be = (AbstractEnergyShieldBE)((EnergyShieldMenu)this.f_97732_).be;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.energyGradient = new ImageWidget(this.x + 76, this.y + 11, 92, 7, ENERGY_GRADIENT);
        this.autoRange = Button.m_253074_((Component)Component.m_237113_((String)"A"), btn -> ModNetworkHandler.sendToServer(new SetEnergyShieldAutoRangePacket(this.be.m_58899_(), !this.be.isAutoRange()))).m_252794_(this.x + 118, this.y + 39).m_253046_(10, 10).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.auto_shield_range").m_130940_(ChatFormatting.GREEN))).m_253136_();
        this.range = new EditBox(this.f_96547_, this.x + 133, this.y + 39, 36, 10, (Component)Component.m_237113_((String)"range"));
        this.range.m_94144_(String.format("%.1f", Float.valueOf(this.be.getRange())));
        this.range.m_94151_(s -> {
            float f = ModGuiUtil.parseFloat(s);
            if (f > 1.0f && f != this.be.getRange()) {
                ModNetworkHandler.sendToServer(new SetEnergyShieldRangePacket(this.be.m_58899_(), f));
            }
        });
        this.m_142416_((GuiEventListener)this.energyGradient);
        this.m_142416_((GuiEventListener)this.autoRange);
        this.m_142416_((GuiEventListener)this.range);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        long energyStored = this.be.getEnergyStored();
        long energyCapacity = this.be.getEnergyCapacity();
        float p = (float)energyStored / (float)energyCapacity;
        this.energyGradient.m_93674_((int)(p * 92.0f));
        this.autoRange.m_93666_((Component)Component.m_237113_((String)(this.be.isAutoRange() ? "A" : "N")));
        this.range.m_94186_(!this.be.isAutoRange());
        String s = GTValuesDup.VNF[this.be.getVoltageLevel()] + ChatFormatting.DARK_GRAY + String.format(" %s / %s EU", ModGuiUtil.formatEnergyValue(energyStored), ModGuiUtil.formatEnergyValue(energyCapacity));
        pGuiGraphics.m_280056_(this.f_96547_, s, 76, 24, 0xFFFFFF, false);
        pGuiGraphics.m_280056_(this.f_96547_, RANGE_LABEL, 76, 39, 0xFFFFFF, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        pGuiGraphics.m_280218_(TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }
}

