/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.energy_shield;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class SphereRenderer {
    private static Vector4f[] PRECOMPUTED_VERTICES;
    private static Vector2f[] PRECOMPUTED_UVS;
    private static Vector3f[] PRECOMPUTED_NORMALS;
    private static int[] PRECOMPUTED_INDICES;

    public static void renderSphere(VertexConsumer buffer, Matrix4f pose, Matrix3f normalMatrix, int color, int light) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (int idx : PRECOMPUTED_INDICES) {
            SphereRenderer.addVertex(buffer, pose, normalMatrix, PRECOMPUTED_VERTICES[idx], PRECOMPUTED_UVS[idx], PRECOMPUTED_NORMALS[idx], r, g, b, a, light);
        }
    }

    private static void addVertex(VertexConsumer buffer, Matrix4f pose, Matrix3f normalMatrix, Vector4f pos, Vector2f uv, Vector3f normal, float r, float g, float b, float a, int light) {
        buffer.m_252986_(pose, pos.x(), pos.y(), pos.z()).m_85950_(r, g, b, a).m_7421_(uv.x(), uv.y()).m_85969_(light).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
    }

    static {
        int segments;
        int verticalSegments = segments = 32;
        int horizontalSegments = segments * 2;
        int vertexCount = (verticalSegments + 1) * (horizontalSegments + 1);
        PRECOMPUTED_VERTICES = new Vector4f[vertexCount];
        PRECOMPUTED_UVS = new Vector2f[vertexCount];
        PRECOMPUTED_NORMALS = new Vector3f[vertexCount];
        for (int i = 0; i <= verticalSegments; ++i) {
            float vAngle = (float)Math.PI * (-0.5f + (float)i / (float)verticalSegments);
            float sinV = (float)Math.sin(vAngle);
            float cosV = (float)Math.cos(vAngle);
            for (int j = 0; j <= horizontalSegments; ++j) {
                float hAngle = (float)Math.PI * 2 * (float)j / (float)horizontalSegments;
                float cosH = (float)Math.cos(hAngle);
                float sinH = (float)Math.sin(hAngle);
                float x = cosH * cosV;
                float y = sinV;
                float z = sinH * cosV;
                float u = (float)j / (float)horizontalSegments;
                if (j == horizontalSegments) {
                    u = 1.0f;
                }
                float v = 1.0f - (float)i / (float)verticalSegments;
                int idx = i * (horizontalSegments + 1) + j;
                SphereRenderer.PRECOMPUTED_VERTICES[idx] = new Vector4f(x, y, z, 1.0f);
                SphereRenderer.PRECOMPUTED_UVS[idx] = new Vector2f(u, v);
                SphereRenderer.PRECOMPUTED_NORMALS[idx] = new Vector3f(x, y, z).normalize();
            }
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < verticalSegments; ++i) {
            for (int j = 0; j < horizontalSegments; ++j) {
                int currentRow = i * (horizontalSegments + 1);
                int nextRow = (i + 1) * (horizontalSegments + 1);
                int[] quadIndices = new int[]{currentRow + j, currentRow + j + 1, nextRow + j + 1, nextRow + j};
                indices.add(quadIndices[0]);
                indices.add(quadIndices[1]);
                indices.add(quadIndices[2]);
                indices.add(quadIndices[0]);
                indices.add(quadIndices[2]);
                indices.add(quadIndices[3]);
            }
        }
        PRECOMPUTED_INDICES = indices.stream().mapToInt(Integer::intValue).toArray();
    }
}

