/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.flight_control;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.flight_control.BasicFlightControlComputer;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.monitors.base.BaseMonitorRendererMethod;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.PhysShip;

public class BasicFlightControlComputerBE
extends AbstractFlightControlBE
implements IVsswMonitorProvider {
    private static final Component NAME = Component.m_237115_((String)"block.valkyrien_space_war.basic_flight_control_computer");
    public static final float WIDTH_SIZE = 10.75f;
    public static final float HEIGHT_SIZE = 9.6f;
    public static final float WIDTH_BORDER = 0.0f;
    public static final float HEIGHT_BORDER = 0.0f;
    public static final float DEF_WIDTH_OFFSET = 3.55f;
    public static final float DEF_HEIGHT_OFFSET = 3.0f;
    public static final float SURFACE_DISTANCE = 0.025f;
    private final VsswMonitorComponent monitorComponent;
    public Vector3f faceVec;
    protected float pitch;
    protected float yaw;

    public BasicFlightControlComputerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.BASIC_FLIGHT_CONTROL_COMPUTER.get(), pPos, pBlockState);
        this.setHovComp(1.6f);
        Direction value = (Direction)pBlockState.m_61143_((Property)BasicFlightControlComputer.FACING);
        this.faceVec = new Vector3f((float)value.m_122429_(), (float)value.m_122430_(), (float)value.m_122431_());
        this.pitch = 0.0f;
        this.yaw = (float)Math.toDegrees(Math.atan2(-this.faceVec.x, this.faceVec.z));
        this.monitorComponent = new VsswMonitorComponent(this, 10.75f, 9.6f, 0.0f, 0.0f, 3.55f, 3.0f, 0.025f);
        this.monitorComponent.setOnClickOuter((be, player, x, y) -> {
            if (be instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)be;
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)menuProvider, (BlockPos)be.m_58899_());
            }
        });
        this.monitorComponent.setOnNbtChanged(component -> this.syncToClient());
        this.monitorComponent.setAngles(this.pitch, this.yaw);
        this.monitorComponent.setIsDynamicMonitor(false);
    }

    @Override
    public VsswMonitorComponent getMonitorComponent() {
        return this.monitorComponent;
    }

    @Override
    public AbstractFlightControlBE getFlightControl() {
        return this;
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        this.getMonitorComponent().putTag(tag);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.getMonitorComponent().loadTag(tag);
    }

    @Override
    protected void startControl(PhysShip physShip, VsUtil.PhysImplSnapshot snapshot) {
        if (!this.engine_on) {
            if (this.thrusterControlSystem != null) {
                this.thrusterControlSystem.setEngineOff();
            }
            return;
        }
        Vector3d[] forceAndTorque = this.calculateForceAndTorque(snapshot);
        Vector3d force = forceAndTorque[0].mul(snapshot.shipMass());
        Vector3d torque = forceAndTorque[1].mul(snapshot.momentOfInertiaTensor());
        if (this.thrusterControlSystem != null) {
            this.thrusterControlSystem.updateControl(force, torque);
        }
    }

    public Component m_5446_() {
        return NAME;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements BlockEntityRenderer<BasicFlightControlComputerBE> {
        public Renderer(BlockEntityRendererProvider.Context context) {
        }

        public int m_142163_() {
            return 256;
        }

        public void render(BasicFlightControlComputerBE blockEntity, float pPartialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            BaseMonitorRendererMethod.render(blockEntity, false, pPartialTick, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

