/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.flight_control.base;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;
import net.shao.valkyrien_space_war.function.util.VsswMonitorUtil;
import net.shao.valkyrien_space_war.item.tool.VsswTools;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.monitor.VsswMonitorClickPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public abstract class AbstractFlightControl
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    protected AbstractFlightControl(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof VsswTools) {
            return InteractionResult.PASS;
        }
        if (pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof IVsswMonitorProvider) {
            IVsswMonitorProvider be = (IVsswMonitorProvider)blockEntity;
            Vector2f clickPos = VsswMonitorUtil.getClickPos(be.getMonitorComponent(), pPos, pHit.m_82450_());
            float x = clickPos.x();
            float y = clickPos.y();
            boolean isInner = false;
            if (x > 0.0f && x < 1.0f && y > 0.0f && y < 1.0f) {
                isInner = true;
                Minecraft.m_91087_().f_91066_.f_92095_.m_7249_(false);
            }
            ModNetworkHandler.sendToServer(new VsswMonitorClickPacket(pPos, x, y, !isInner));
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : (lvl, pos, st, be) -> ((AbstractFlightControlBE)be).tick(lvl, pos, st);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof AbstractFlightControlBE) {
            AbstractFlightControlBE be = (AbstractFlightControlBE)blockEntity;
            be.drops();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            facing = facing.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

