/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.flight_control.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shao.valkyrien_space_war.ValkyrienSpaceWar;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.base.ModHostBE;
import net.shao.valkyrien_space_war.block.flight_control.base.FlightControlMenu;
import net.shao.valkyrien_space_war.block.radar.base.BaseRadarBE;
import net.shao.valkyrien_space_war.block.radar.base.RadarTarget;
import net.shao.valkyrien_space_war.block.radar.base.TmpTarget;
import net.shao.valkyrien_space_war.block.record.FcRecord;
import net.shao.valkyrien_space_war.block.record.RecordDiscAccessor;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.block.turret.energy.BasicEnergyTurretBE;
import net.shao.valkyrien_space_war.function.terrain.ChunkLoadManager;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.function.vs.inducer.BlockEntityShipForcesInducer;
import net.shao.valkyrien_space_war.function.vs.inducer.IBEShipForceInducer;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.control.ResetClientInputPacket;
import net.shao.valkyrien_space_war.projectile.base.ProjectileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;

public abstract class AbstractFlightControlBE
extends ModHostBE
implements IBEShipForceInducer,
MenuProvider,
RecordDiscAccessor {
    private static final ModConnectorBE.ConnectorType type = ModConnectorBE.ConnectorType.FLIGHT_CONTROL;
    protected ArrayList<BaseShipControlSeatBE> activeSeats;
    private RadarTarget target;
    public static final RadarTarget EMPTY_RADAR_TARGET = new RadarTarget();
    protected ThrusterControlSystem thrusterControlSystem;
    protected FcRecord fcRecord;
    private int replay_ct = 60;
    public final ItemStackHandler itemHandler = new ItemStackHandler(1);
    private LazyOptional<IItemHandler> itemOptional = LazyOptional.of(() -> this.itemHandler);
    private VsUtil.PhysImplSnapshot lastSnapshot;
    private ArrayList<TmpTarget> lastTargets = new ArrayList();
    private boolean autoLevel = false;
    private boolean burnerOn = false;
    private byte lastThrusterLevel = 0;
    private static final Vector3f zPoint = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f xPoint = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final double V_INTERVAL = 0.016666666666666666;
    public static final byte SPACESHIP_MODE = 0;
    public static final byte AIRSHIP_MODE = 1;
    public static final byte FPV_MODE = 2;
    public static final byte RADAR_MODE_NULL = 0;
    public static final byte RADAR_MODE_SHIP = 1;
    public static final byte RADAR_MODE_MONSTER = 2;
    public static final byte RADAR_MODE_PLAYER = 3;
    public static final byte RADAR_MODE_ANIMAL = 4;
    public static final byte RADAR_MODE_AUTO = 5;
    public static final byte NO_LOOP = 0;
    public static final byte SINGLE_LOOP = 1;
    public static final byte LIST_LOOP = 2;
    protected String TAG_MODE = "mode";
    protected String TAG_SP_ROT_P = "rot_p";
    protected String TAG_SP_ROT_D = "rot_d";
    protected String TAG_SP_FORWARD = "fw";
    protected String TAG_SP_SIDEWAYS = "sw";
    protected String TAG_SP_UPWARD = "sp_up";
    protected String TAG_SP_MOVE_D = "move_d";
    protected String TAG_SP_COUPLED = "cpld";
    protected String TAG_ENGINE_ON = "eg_on";
    protected String TAG_SP_THRUSTER_LEVEL = "sp_thrst";
    protected String TAG_RADAR_MODE = "radar";
    protected String TAG_DISTRIBUTED_LOCKING = "d_lock";
    protected String TAG_ROLL_RATE_RC = "roll_rc";
    protected String TAG_ROLL_RATE_S = "roll_s";
    protected String TAG_ROLL_RATE_EXP = "roll_exp";
    protected String TAG_YAW_RATE_RC = "yaw_rc";
    protected String TAG_YAW_RATE_S = "yaw_s";
    protected String TAG_YAW_RATE_EXP = "yaw_exp";
    protected String TAG_PITCH_RATE_RC = "pitch_rc";
    protected String TAG_PITCH_RATE_S = "pitch_s";
    protected String TAG_PITCH_RATE_EXP = "pitch_exp";
    protected String TAG_THROTTLE_MID = "thrust_mid";
    protected String TAG_THROTTLE_EXP = "thrust_exp";
    protected String TAG_STEP_SIZE_THRUSTER = "step_thr";
    protected String TAG_STEP_SIZE_Direction = "step_dir";
    protected String TAG_MAX_ITERATION = "max_iter";
    protected String TAG_TOLERANCE = "tolc";
    protected String TAG_FORCE_WEIGHT = "force_w";
    protected String TAG_TORQUE_WEIGHT = "torque_w";
    protected String TAG_SCALE_FACTOR = "s_fact";
    protected String TAG_THRUST_REG = "thr_reg";
    protected String TAG_SELECT_REC = "slt_rec";
    protected String TAG_IS_RECORDING = "is_rec";
    protected String TAG_REPLAY = "replay";
    protected String TAG_LOOP_MODE = "loop";
    protected String TAG_REPLAY_INDEX = "index";
    protected String TAG_RECORD_FILE_INDEX = "rf_index";
    protected String TAG_LAST_FRAME = "lst_f";
    protected String TAG_HOVER_COMP = "hov_comp";
    protected String TAG_AIRSHIP_MOVE_P = "air_m_p";
    protected String TAG_AIRSHIP_MOVE_D = "air_m_d";
    protected String TAG_AIRSHIP_ROT_P = "air_r_p";
    protected String TAG_AIRSHIP_ROT_D = "air_r_d";
    public byte mode = 0;
    public float spRotP = 1.5f;
    public float spRotD = 0.75f;
    public float spForward = 1.0f;
    public float spSideways = 1.0f;
    public float spUpward = 1.0f;
    public float spMoveD = 0.75f;
    public boolean spCoupled = true;
    protected boolean engine_on = true;
    public byte spThrusterLevel = (byte)3;
    public byte radarMode = 0;
    public boolean distributed_locking = false;
    public float fpv_roll_rate_rc = 1.0f;
    public float fpv_roll_rate_s = 0.7f;
    public float fpv_roll_rate_exp = 0.3f;
    public float fpv_yaw_rate_rc = 1.0f;
    public float fpv_yaw_rate_s = 0.7f;
    public float fpv_yaw_rate_exp = 0.3f;
    public float fpv_pitch_rate_rc = 1.0f;
    public float fpv_pitch_rate_s = 0.7f;
    public float fpv_pitch_rate_exp = 0.3f;
    public float fpv_throttle_mid = 0.25f;
    public float fpv_throttle_exp = 1.0f;
    public float air_move_p = 1.0f;
    public float air_move_d = 0.5f;
    public float air_rot_p = 1.0f;
    public float air_rot_d = 0.5f;
    public float step_thruster = 0.25f;
    public float step_direction = 0.01f;
    public int max_iteration = 35;
    public float tolerance = 1.0f;
    public float force_weight = 1.0f;
    public float torque_weight = 1.0f;
    public double scale_factor = 1.0E-4;
    public double thr_reg = 1.0;
    public float hov_comp = 1.0f;
    public String select_rec = "";
    public boolean isRecording = false;
    public boolean isReplay = false;
    public byte loop_mode = 0;
    public byte replay_index = 0;
    public byte record_file_index = 0;
    public int last_frame = 0;

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return type;
    }

    public AbstractFlightControlBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.thrusterControlSystem = new ThrusterControlSystem();
        this.resetAlgorithmParameters();
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState1) {
        super.tick(pLevel, pPos, pState1);
        if (pLevel.m_5776_()) {
            return;
        }
        this.thrusterControlSystem.updateThrusters();
        ServerShip ship = this.getServerShip();
        if (ship == null) {
            return;
        }
        if (this.replay_ct > 0) {
            --this.replay_ct;
        }
        BlockEntityShipForcesInducer inducer = BlockEntityShipForcesInducer.getOrCreate(ship);
        inducer.update(this);
        this.activeSeats = this.getSeats();
        this.updateTarget();
        ArrayList<AbstractThrusterBE> thrusters = this.getThrusters();
        thrusters.forEach(thruster -> this.thrusterControlSystem.addThruster((AbstractThrusterBE)thruster));
        this.forceChunks((ServerLevel)this.f_58857_, (Ship)ship);
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.m_58904_();
    }

    private void forceChunks(ServerLevel serverLevel, Ship ship) {
        int maxSize = (VsUtil.getShipMaxSize(ship) >> 4) + 2;
        Vector3dc positionInWorld = ship.getTransform().getPositionInWorld();
        int chunkX = (int)positionInWorld.x() >> 4;
        int chunkZ = (int)positionInWorld.z() >> 4;
        for (int i = -maxSize; i <= maxSize; ++i) {
            for (int j = -maxSize; j <= maxSize; ++j) {
                int cx = chunkX + i;
                int cz = chunkZ + j;
                ChunkLoadManager.getManagerForLevel(serverLevel).addOrUpdateChunkPos(cx, cz, 3);
            }
        }
    }

    public void drops() {
        int count = this.itemHandler.getSlots();
        SimpleContainer inventory = new SimpleContainer(count);
        for (int i = 0; i < count; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemOptional.invalidate();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FlightControlMenu(pContainerId, pPlayerInventory, this);
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        if (this.thrusterControlSystem == null) {
            return;
        }
        this.thrusterControlSystem.setEngineOff();
        this.thrusterControlSystem = null;
    }

    @Override
    public void removeChildren(BlockPos pos) {
        BlockEntity blockEntity;
        super.removeChildren(pos);
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(pos)) instanceof AbstractThrusterBE) {
            AbstractThrusterBE be = (AbstractThrusterBE)blockEntity;
            this.thrusterControlSystem.removeThruster(be);
        }
    }

    protected abstract void startControl(PhysShip var1, VsUtil.PhysImplSnapshot var2);

    private ArrayList<BaseShipControlSeatBE> getSeats() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return null;
        }
        ArrayList<BaseShipControlSeatBE> result = new ArrayList<BaseShipControlSeatBE>();
        HashSet<ModGuestBE> childrenBE = this.getChildrenBE();
        for (ModGuestBE modGuestBE : childrenBE) {
            if (modGuestBE.getBeType() != ModConnectorBE.ConnectorType.SEAT) continue;
            result.add((BaseShipControlSeatBE)modGuestBE);
        }
        return result;
    }

    public HashSet<BaseRadarBE> getRadars() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return null;
        }
        HashSet<ModGuestBE> childrenBE = this.getChildrenBE();
        HashSet<BaseRadarBE> result = new HashSet<BaseRadarBE>();
        for (ModGuestBE modGuestBE : childrenBE) {
            if (modGuestBE.getBeType() != ModConnectorBE.ConnectorType.RADAR) continue;
            result.add((BaseRadarBE)modGuestBE);
        }
        return result;
    }

    public RadarTarget getRadarTargetsByMode(byte radarMode) {
        RadarTarget radarTargets = new RadarTarget();
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || radarMode == 0) {
            return EMPTY_RADAR_TARGET;
        }
        HashSet<BaseRadarBE> radars = this.getRadars();
        for (BaseRadarBE radar : radars) {
            if (radarMode == 1) {
                radar.getShips().forEach(radarTargets::addShip);
                continue;
            }
            if (radarMode == 5) {
                radar.getLivingEntities().forEach(radarTargets::addEntity);
                radar.getShips().forEach(radarTargets::addShip);
                continue;
            }
            HashSet entities = switch (radarMode) {
                case 2 -> radar.getMonsters();
                case 3 -> radar.getPlayers();
                case 4 -> radar.getAnimals();
                default -> new HashSet();
            };
            entities.forEach(radarTargets::addEntity);
        }
        return radarTargets;
    }

    public int getTargetCount() {
        int count = 0;
        for (ModGuestBE modGuestBE : this.getChildrenBE()) {
            if (modGuestBE.getBeType() != ModConnectorBE.ConnectorType.TURRET) continue;
            ++count;
        }
        return count;
    }

    public RadarTarget getTarget() {
        return this.target;
    }

    public void setTarget(RadarTarget target) {
        this.target = target;
    }

    public void updateTarget() {
        block10: {
            ArrayList<TmpTarget> tmpTargets;
            ArrayList turrets;
            block9: {
                turrets = new ArrayList();
                this.getChildrenBE().forEach(childrenBe -> {
                    if (childrenBe.getBeType() == ModConnectorBE.ConnectorType.TURRET) {
                        turrets.add((AbstractTurretBE)childrenBe);
                    }
                });
                if (this.target == null || this.target.isEmpty()) {
                    for (AbstractTurretBE turret : turrets) {
                        turret.setEmptyTarget();
                    }
                    return;
                }
                tmpTargets = new ArrayList<TmpTarget>();
                for (Ship ship : this.target.getShips()) {
                    tmpTargets.add(new TmpTarget(ship));
                }
                for (LivingEntity entity : this.target.getEntities()) {
                    TmpTarget tmpTarget = new TmpTarget((Entity)entity);
                    tmpTargets.add(tmpTarget);
                    TmpTarget lastEntityTarget = this.getLastEntityTarget((Entity)entity);
                    if (lastEntityTarget == null) continue;
                    tmpTarget.setVelocity(tmpTarget.position.m_82546_(lastEntityTarget.position));
                }
                if (!this.target.getEntities().isEmpty()) {
                    this.lastTargets.clear();
                    for (TmpTarget tmpTarget : tmpTargets) {
                        if (tmpTarget.id == -1) continue;
                        this.lastTargets.add(tmpTarget);
                    }
                } else {
                    this.lastTargets.clear();
                }
                if (!this.distributed_locking) break block9;
                int tSize = tmpTargets.size();
                for (int i = 0; i < turrets.size(); ++i) {
                    ((AbstractTurretBE)turrets.get(i)).setTarget((TmpTarget)tmpTargets.get(i % tSize));
                }
                break block10;
            }
            if (tmpTargets.get(0) == null) break block10;
            for (AbstractTurretBE turret : turrets) {
                turret.setTarget((TmpTarget)tmpTargets.get(0));
            }
        }
    }

    private TmpTarget getLastEntityTarget(Entity entity) {
        if (this.lastTargets != null) {
            for (TmpTarget lastTarget : this.lastTargets) {
                if (lastTarget.id != entity.m_19879_()) continue;
                return lastTarget;
            }
        }
        return null;
    }

    public void setEmptyRadarTarget() {
        this.target = null;
    }

    public void startOrStopRecording() {
        if (this.getServerShip() == null || this.m_58904_() == null) {
            return;
        }
        if (this.fcRecord == null || !this.fcRecord.canRecord) {
            this.fcRecord = new FcRecord(true);
            this.fcRecord.startRecording();
            this.isRecording = true;
        } else if (this.fcRecord.isRecording()) {
            String s = this.newRecordName();
            this.setSelect_rec(s);
            try {
                this.fcRecord.stopAndSave((ServerLevel)this.f_58857_, s);
            }
            catch (IOException e) {
                ValkyrienSpaceWar.LOGGER.error("Failed to save recording: " + e.getMessage());
            }
            this.addItemRecord(s);
            this.fcRecord = null;
            this.isRecording = false;
        }
        this.syncToClient();
    }

    public void playOrPauseReplay(int index) {
        if (this.getServerShip() == null || this.m_58904_() == null) {
            return;
        }
        if (index == 0 || this.replay_index == index) {
            this.setIsReplay(!this.isReplay);
            if (!this.isReplay) {
                this.setReplayIndex(0);
            }
        } else {
            this.setReplayIndex((byte)index);
            if (!(this.fcRecord != null && this.fcRecord.name.equals(this.select_rec) || this.setRec(-1))) {
                this.setReplayIndex(0);
            }
        }
    }

    private FcRecord getRecordByName(String selectRec) throws IOException {
        return FcRecord.loadRecording((ServerLevel)this.f_58857_, selectRec);
    }

    public void deleteCurrentRecord() {
        if (!this.select_rec.equals("")) {
            this.removeItemRecord(this.select_rec);
            this.setSelect_rec("");
            this.fcRecord = null;
            this.setIsReplay(false);
        }
    }

    private void nextRecord() {
        this.record_file_index = (byte)(this.record_file_index + 1);
        boolean b = this.setRec(-1);
        if (!b) {
            this.record_file_index = 0;
            this.replay_index = 0;
        } else {
            this.setReplayIndex(1);
        }
    }

    private boolean setRec(int index) {
        List itemRecords = this.getItemRecords();
        if (!itemRecords.isEmpty()) {
            this.record_file_index = this.record_file_index >= itemRecords.size() ? (byte)0 : (this.record_file_index < 0 ? (byte)(itemRecords.size() - 1) : this.record_file_index);
            this.setSelect_rec((String)itemRecords.get(this.record_file_index));
            try {
                this.fcRecord = this.getRecordByName(this.select_rec);
                if (index != -1) {
                    this.fcRecord.setCurrentFrameIndex(this.last_frame);
                }
                this.setIsReplay(true);
            }
            catch (IOException e) {
                this.removeItemRecord(this.select_rec);
                this.setSelect_rec("");
                this.setIsReplay(false);
                return false;
            }
            return true;
        }
        return false;
    }

    private String newRecordName() {
        return this.getServerShip().getSlug() + "-" + System.currentTimeMillis();
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public ArrayList<AbstractThrusterBE> getThrusters() {
        ArrayList<AbstractThrusterBE> thrusters = new ArrayList<AbstractThrusterBE>();
        this.getChildrenBE().forEach(be -> {
            if (be.getBeType() == ModConnectorBE.ConnectorType.THRUSTER) {
                thrusters.add((AbstractThrusterBE)be);
            }
        });
        return thrusters;
    }

    protected Vector3d[] goToPosAndRot(VsUtil.PhysImplSnapshot snapshot, Vector3f position, Quaternionf rotation) {
        Vector3d pos = new Vector3d((Vector3fc)position).sub((Vector3dc)snapshot.pos());
        pos = pos.length() > 30.0 ? pos.normalize().mul(30.0) : pos;
        Quaterniond selfRot = new Quaterniond(snapshot.rot());
        Quaterniond conjugate = selfRot.conjugate(new Quaterniond());
        Vector3d omega = conjugate.transform(new Vector3d(snapshot.omega()));
        Vector3d force = conjugate.transform(pos.mul(8.0).sub(snapshot.velocity()).mul(32.0));
        Quaternionf targetRot = rotation.conjugate(new Quaternionf());
        Vector3f xp = targetRot.transform(selfRot.transform(new Vector3f(1.0f, 0.0f, 0.0f)));
        Vector3f zp = targetRot.transform(selfRot.transform(new Vector3f(0.0f, 0.0f, 1.0f)));
        double xRot = Math.toDegrees(Math.asin(zp.y()));
        double yRot = Math.toDegrees(Math.atan2(xp.z(), xp.x()));
        double zRot = -Math.toDegrees(Math.asin(xp.y()));
        Vector3d torque = new Vector3d(xRot, yRot, zRot).mul(8.0);
        torque = torque.add((Vector3dc)omega.negate(new Vector3d()).mul(32.0));
        return new Vector3d[]{force, torque};
    }

    protected Vector3d gotoRotWithPD(Quaterniond selfRot, Vector3d omega, Quaternionf targetRot, double p, double d) {
        Quaternionf tgRot = targetRot.conjugate(new Quaternionf());
        Vector3f xp = tgRot.transform(selfRot.transform(new Vector3f(1.0f, 0.0f, 0.0f)));
        Vector3f zp = tgRot.transform(selfRot.transform(new Vector3f(0.0f, 0.0f, 1.0f)));
        double xRot = Math.toDegrees(Math.asin(zp.y()));
        double yRot = Math.toDegrees(Math.atan2(xp.z(), xp.x()));
        double zRot = -Math.toDegrees(Math.asin(xp.y()));
        Vector3d torque = new Vector3d(xRot, yRot, zRot).mul(p);
        torque = torque.add((Vector3dc)omega.negate(new Vector3d()).mul(d));
        return torque;
    }

    protected Vector3d[] calculateForceAndTorque(VsUtil.PhysImplSnapshot snapshot) {
        if (this.isReplay && this.fcRecord != null && this.fcRecord.frameCount() != 0 && !this.fcRecord.isRecording() && this.replay_ct < 1) {
            FcRecord.Frame frame = this.loop_mode == 1 ? this.fcRecord.getFrameLoop(this.replay_index) : this.fcRecord.getFrame(this.replay_index);
            if (frame == null) {
                this.setReplayIndex(0);
                this.fcRecord = null;
                if (this.loop_mode == 2) {
                    this.nextRecord();
                } else {
                    this.setIsReplay(false);
                }
            } else {
                this.last_frame = this.fcRecord.getCurrentFrameIndex();
                Quaterniond seatRot = this.getSeatRot(this.getFirstSeat());
                return this.goToPosAndRot(snapshot, frame.pos(), new Quaternionf((Quaternionfc)frame.rot()).mul((Quaternionfc)new Quaternionf((Quaterniondc)seatRot).conjugate()));
            }
            return new Vector3d[]{new Vector3d(), new Vector3d()};
        }
        BaseShipControlSeatBE seat = this.getFirstActiveSeat();
        UnpackedStick unpackedStick = seat != null ? new UnpackedStick(seat.faceVec, seat.input[8] - seat.input[9], seat.input[4] - seat.input[5], seat.input[6] - seat.input[7], seat.input[11] - seat.input[10], seat.input[2] - seat.input[3], seat.input[1] - seat.input[0]) : new UnpackedStick();
        Quaterniond rot = new Quaterniond(snapshot.rot());
        Quaterniond conjugate = rot.conjugate(new Quaterniond());
        Vector3d velocity = conjugate.transform(new Vector3d(snapshot.velocity()));
        Vector3d omega = conjugate.transform(new Vector3d(snapshot.omega()));
        Vector3d[] forceAndTorque = switch (this.mode) {
            case 0 -> this.spaceShipMode(seat, unpackedStick, rot, conjugate, (Vector3dc)velocity, (Vector3dc)omega);
            case 1 -> this.airShipMode(seat, unpackedStick, rot, conjugate, velocity, omega);
            case 2 -> this.fpvMode(seat, unpackedStick, rot, conjugate, (Vector3dc)velocity, (Vector3dc)omega);
            default -> this.hoverMode(rot, conjugate, (Vector3dc)velocity, (Vector3dc)omega);
        };
        return forceAndTorque;
    }

    private BaseShipControlSeatBE getFirstActiveSeat() {
        ArrayList<BaseShipControlSeatBE> seats = new ArrayList<BaseShipControlSeatBE>();
        for (BaseShipControlSeatBE s : this.activeSeats) {
            if (!s.isControlling()) continue;
            seats.add(s);
        }
        return seats.isEmpty() ? null : (BaseShipControlSeatBE)seats.get(0);
    }

    private BaseShipControlSeatBE getFirstSeat() {
        for (ModGuestBE modGuestBE : this.getChildrenBE()) {
            if (modGuestBE.getBeType() != ModConnectorBE.ConnectorType.SEAT) continue;
            return (BaseShipControlSeatBE)modGuestBE;
        }
        return null;
    }

    private Quaterniond getSeatRot(BaseShipControlSeatBE seat) {
        if (seat == null) {
            return new Quaterniond();
        }
        double v = Math.atan2(seat.faceVec.z, -seat.faceVec.x) / 2.0;
        return new Quaterniond(0.0, Math.sin(v), 0.0, Math.cos(v));
    }

    @Override
    public void updatePhysics(PhysShip physShip, VsUtil.PhysImplSnapshot snapshot) {
        this.lastSnapshot = snapshot;
        if (this.f_58857_ != null) {
            if (this.fcRecord != null && this.fcRecord.isRecording()) {
                BaseShipControlSeatBE seat = this.getFirstSeat();
                if (seat != null) {
                    Quaterniond mul = new Quaterniond(snapshot.rot()).mul((Quaterniondc)this.getSeatRot(seat));
                    this.fcRecord.update(new Vector3d((Vector3dc)snapshot.pos()), mul);
                } else {
                    this.fcRecord.update(new Vector3d((Vector3dc)snapshot.pos()), new Quaterniond(snapshot.rot()));
                }
            }
            Quaterniond rot = new Quaterniond(snapshot.rot());
            Quaterniond conjugate = rot.conjugate(new Quaterniond());
            Vector3d velocity = conjugate.transform(new Vector3d(snapshot.velocity()));
            Vector3d damping = this.getAirDamping((Vector3dc)velocity);
            float drag = ProjectileUtil.getGravDragByDimension((ResourceKey<Level>)this.f_58857_.m_46472_())[1];
            damping.mul((double)drag);
            physShip.applyRotDependentForce((Vector3dc)ModMathUtil.checkAndReplaceNaN(damping.mul(snapshot.shipMass())));
        }
        this.startControl(physShip, snapshot);
    }

    public VsUtil.PhysImplSnapshot getLastSnapshot() {
        return this.lastSnapshot;
    }

    protected Vector3d[] hoverMode(Quaterniond rot, Quaterniond conjugate, Vector3dc velocity, Vector3dc omega) {
        Vector3d force = conjugate.transform(new Vector3d(0.0, 10.0, 0.0).mul((double)this.hov_comp));
        force.add((Vector3dc)velocity.negate(new Vector3d()).mul(10.0));
        Vector3d torque = omega.negate(new Vector3d()).mul(10.0);
        return new Vector3d[]{force, torque};
    }

    public void startAutoLevel(ServerPlayer player) {
        this.autoLevel = true;
        if (player != null) {
            ModNetworkHandler.sendToPlayer(player, new ResetClientInputPacket(this.m_58899_()));
        }
    }

    public void switchBurner() {
        boolean bl = this.burnerOn = !this.burnerOn;
        if (this.burnerOn) {
            this.lastThrusterLevel = this.spThrusterLevel;
            this.setThrusterLevel(9);
        } else {
            this.setThrusterLevel(this.lastThrusterLevel);
        }
    }

    private byte getThrusterLevelWithBurner() {
        if (this.burnerOn) {
            return 9;
        }
        return this.spThrusterLevel;
    }

    protected Vector3d[] spaceShipMode(BaseShipControlSeatBE seat, UnpackedStick unpackedStick, Quaterniond rot, Quaterniond conjugate, Vector3dc velocity, Vector3dc omega) {
        Vector3d torque;
        Vector2d transformDt = unpackedStick.getM2d().transform(new Vector2d((double)this.spSideways, (double)this.spForward));
        double forward = unpackedStick.btJoyRot.y * Math.abs(transformDt.y);
        double sideways = unpackedStick.btJoyRot.x * Math.abs(transformDt.x);
        double upward = unpackedStick.leftJoy.y * (double)this.spUpward;
        Vector3d force = new Vector3d(forward, upward, sideways).mul(60.0).mul((double)this.spThrusterLevel * 0.33 + 0.01);
        if (this.spCoupled) {
            force.add((Vector3dc)conjugate.transform(new Vector3d(0.0, 10.0, 0.0).mul((double)this.hov_comp)));
            force.add((Vector3dc)velocity.negate(new Vector3d()).mul((double)(this.spMoveD * 2.0f)));
        }
        if (this.autoLevel) {
            Vector3f facePoint = rot.transform(new Vector3f((Vector3fc)xPoint));
            float currentYaw = (float)Math.atan2(-facePoint.z, facePoint.x);
            Quaternionf tgRot = new Quaternionf().rotateY(currentYaw);
            torque = this.gotoRotWithPD(rot, new Vector3d(omega), tgRot, 1.0, 20.0);
            if (torque.length() < 0.1) {
                this.autoLevel = false;
            }
        } else {
            double roll = unpackedStick.rightJoyRot.x;
            double yaw = unpackedStick.leftJoy.x;
            double pitch = unpackedStick.rightJoyRot.y;
            torque = new Vector3d(roll, yaw, pitch).mul(10.0).mul((double)this.spRotP);
            torque.add((Vector3dc)omega.negate(new Vector3d()).mul(10.0).mul((double)this.spRotD));
        }
        return new Vector3d[]{force, torque};
    }

    private Vector3d[] airShipMode(BaseShipControlSeatBE seat, UnpackedStick unpackedStick, Quaterniond rot, Quaterniond conjugate, Vector3d velocity, Vector3d omega) {
        double forward = unpackedStick.btJoyRot.y;
        double sideways = unpackedStick.btJoyRot.x;
        double upward = unpackedStick.leftJoy.y / 2.0;
        Vector3d force = new Vector3d(forward, upward, sideways).mul((double)(10.0f * this.air_move_p)).mul((double)this.spThrusterLevel * 0.33 + 0.01);
        force.add((Vector3dc)conjugate.transform(new Vector3d(0.0, 10.0, 0.0).mul((double)this.hov_comp)));
        force.add((Vector3dc)velocity.negate(new Vector3d()).mul((double)this.air_move_d));
        Vector3f facePoint = rot.transform(new Vector3f((Vector3fc)xPoint));
        float currentYaw = (float)Math.atan2(-facePoint.z, facePoint.x);
        float yaw = (float)Mth.m_14175_((double)Math.toDegrees((double)currentYaw + Math.asin(unpackedStick.leftJoy.x) / 8.0));
        Quaternionf tgRot = new Quaternionf().rotateY((float)Math.toRadians(yaw));
        Vector3d torque = this.gotoRotWithPD(rot, omega, tgRot, this.air_rot_p, this.air_rot_d * 10.0f);
        return new Vector3d[]{force, torque};
    }

    protected Vector3d[] fpvMode(BaseShipControlSeatBE seat, UnpackedStick unpackedStick, Quaterniond rot, Quaterniond conjugate, Vector3dc velocity, Vector3dc omega) {
        double roll = unpackedStick.rightJoyRot.x;
        double yaw = unpackedStick.leftJoy.x;
        double pitch = unpackedStick.rightJoyRot.y;
        double upward = unpackedStick.leftJoy.y;
        double throttle = AbstractFlightControlBE.getFpvThrottle(this.fpv_throttle_mid, this.fpv_throttle_exp, upward);
        Vector3d force = new Vector3d(0.0, throttle, 0.0).mul(150.0);
        force.add((Vector3dc)conjugate.transform(new Vector3d(0.0, -20.0, 0.0)));
        double rollRate = AbstractFlightControlBE.getRate(this.fpv_roll_rate_rc, this.fpv_roll_rate_s, this.fpv_roll_rate_exp, roll);
        double yawRate = AbstractFlightControlBE.getRate(this.fpv_yaw_rate_rc, this.fpv_yaw_rate_s, this.fpv_yaw_rate_exp, yaw);
        double pitchRate = AbstractFlightControlBE.getRate(this.fpv_pitch_rate_rc, this.fpv_pitch_rate_s, this.fpv_pitch_rate_exp, pitch);
        Vector3d torque = new Vector3d(rollRate, yawRate, pitchRate).mul(2.0);
        torque.add((Vector3dc)omega.negate(new Vector3d()).mul(100.0));
        return new Vector3d[]{force, torque};
    }

    private Vector3d getAirDamping(Vector3dc velocity) {
        Vector3d dampingVel = new Vector3d(velocity.x() * 0.016666666666666666, velocity.y() * 0.016666666666666666, velocity.z() * 0.016666666666666666);
        Vector3d damping = new Vector3d((Vector3dc)dampingVel).mul((Vector3dc)dampingVel).mul(60.0);
        damping.x = Math.copySign(damping.x, -velocity.x());
        damping.y = Math.copySign(damping.y, -velocity.y());
        damping.z = Math.copySign(damping.z, -velocity.z());
        return damping;
    }

    public static double getRate(double rc, double s, double exp, double x) {
        if (s >= 1.0) {
            s = 0.99;
        }
        boolean flag = x < 0.0;
        x = Math.abs(x);
        double p = 1.0 / (1.0 - x * s);
        double q = Math.pow(x, 4.0) * exp + x * (1.0 - exp);
        double r = 200.0 * q * rc;
        double t = r * p;
        return flag ? -t : t;
    }

    public static double getFpvThrottle(double mid, double t_exp, double x) {
        x = x > 1.0 ? 1.0 : x;
        boolean flag = x < 0.0;
        x = Math.abs(x);
        double result = 0.0;
        if (x < mid) {
            x = 1.0 - x / mid;
            result = Math.pow(x, 2.0) * t_exp + x * (1.0 - t_exp);
            result = mid - result * mid;
        } else {
            x = (x - mid) / (1.0 - mid);
            result = Math.pow(x, 2.0) * t_exp + x * (1.0 - t_exp);
            result = mid + result * (1.0 - mid);
        }
        return flag ? -result : result;
    }

    private static double asin(float x) {
        return Math.asin(x);
    }

    public void setFire(Player player, boolean onFire, float rate) {
        this.getChildrenBE().forEach(c -> {
            if (c.getBeType() == ModConnectorBE.ConnectorType.TURRET) {
                ((AbstractTurretBE)c).setOnFire(player, onFire, rate);
            }
        });
    }

    public void missile() {
    }

    public void prevGunLevel() {
        for (ModGuestBE modGuestBE : this.getChildrenBE()) {
            if (!(modGuestBE instanceof BasicEnergyTurretBE)) continue;
            BasicEnergyTurretBE be = (BasicEnergyTurretBE)modGuestBE;
            be.prevGunLevel();
        }
    }

    public void nextGunLevel() {
        for (ModGuestBE modGuestBE : this.getChildrenBE()) {
            if (!(modGuestBE instanceof BasicEnergyTurretBE)) continue;
            BasicEnergyTurretBE be = (BasicEnergyTurretBE)modGuestBE;
            be.nextGunLevel();
        }
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128344_(this.TAG_MODE, this.mode);
        tag.m_128350_(this.TAG_SP_ROT_P, this.spRotP);
        tag.m_128350_(this.TAG_SP_ROT_D, this.spRotD);
        tag.m_128350_(this.TAG_SP_FORWARD, this.spForward);
        tag.m_128350_(this.TAG_SP_SIDEWAYS, this.spSideways);
        tag.m_128350_(this.TAG_SP_UPWARD, this.spUpward);
        tag.m_128350_(this.TAG_SP_MOVE_D, this.spMoveD);
        tag.m_128379_(this.TAG_SP_COUPLED, this.spCoupled);
        tag.m_128379_(this.TAG_ENGINE_ON, this.engine_on);
        tag.m_128344_(this.TAG_SP_THRUSTER_LEVEL, this.spThrusterLevel);
        tag.m_128344_(this.TAG_RADAR_MODE, this.radarMode);
        tag.m_128379_(this.TAG_DISTRIBUTED_LOCKING, this.distributed_locking);
        tag.m_128350_(this.TAG_ROLL_RATE_RC, this.fpv_roll_rate_rc);
        tag.m_128350_(this.TAG_ROLL_RATE_S, this.fpv_roll_rate_s);
        tag.m_128350_(this.TAG_ROLL_RATE_EXP, this.fpv_roll_rate_exp);
        tag.m_128350_(this.TAG_YAW_RATE_RC, this.fpv_yaw_rate_rc);
        tag.m_128350_(this.TAG_YAW_RATE_S, this.fpv_yaw_rate_s);
        tag.m_128350_(this.TAG_YAW_RATE_EXP, this.fpv_yaw_rate_exp);
        tag.m_128350_(this.TAG_PITCH_RATE_RC, this.fpv_pitch_rate_rc);
        tag.m_128350_(this.TAG_PITCH_RATE_S, this.fpv_pitch_rate_s);
        tag.m_128350_(this.TAG_PITCH_RATE_EXP, this.fpv_pitch_rate_exp);
        tag.m_128350_(this.TAG_THROTTLE_MID, this.fpv_throttle_mid);
        tag.m_128350_(this.TAG_THROTTLE_EXP, this.fpv_throttle_exp);
        tag.m_128350_(this.TAG_STEP_SIZE_THRUSTER, this.step_thruster);
        tag.m_128350_(this.TAG_STEP_SIZE_Direction, this.step_direction);
        tag.m_128405_(this.TAG_MAX_ITERATION, this.max_iteration);
        tag.m_128350_(this.TAG_TOLERANCE, this.tolerance);
        tag.m_128350_(this.TAG_FORCE_WEIGHT, this.force_weight);
        tag.m_128350_(this.TAG_TORQUE_WEIGHT, this.torque_weight);
        tag.m_128347_(this.TAG_SCALE_FACTOR, this.scale_factor);
        tag.m_128347_(this.TAG_THRUST_REG, this.thr_reg);
        tag.m_128350_(this.TAG_HOVER_COMP, this.hov_comp);
        tag.m_128359_(this.TAG_SELECT_REC, this.select_rec);
        tag.m_128379_(this.TAG_IS_RECORDING, this.isRecording);
        tag.m_128379_(this.TAG_REPLAY, this.isReplay);
        tag.m_128344_(this.TAG_LOOP_MODE, this.loop_mode);
        tag.m_128344_(this.TAG_REPLAY_INDEX, this.replay_index);
        tag.m_128344_(this.TAG_RECORD_FILE_INDEX, this.record_file_index);
        tag.m_128405_(this.TAG_LAST_FRAME, this.last_frame);
        tag.m_128350_(this.TAG_AIRSHIP_MOVE_P, this.air_move_p);
        tag.m_128350_(this.TAG_AIRSHIP_MOVE_D, this.air_move_d);
        tag.m_128350_(this.TAG_AIRSHIP_ROT_P, this.air_rot_p);
        tag.m_128350_(this.TAG_AIRSHIP_ROT_D, this.air_rot_d);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        this.mode = tag.m_128445_(this.TAG_MODE);
        this.spRotP = tag.m_128457_(this.TAG_SP_ROT_P);
        this.spRotD = tag.m_128457_(this.TAG_SP_ROT_D);
        this.spForward = tag.m_128457_(this.TAG_SP_FORWARD);
        this.spSideways = tag.m_128457_(this.TAG_SP_SIDEWAYS);
        this.spUpward = tag.m_128457_(this.TAG_SP_UPWARD);
        this.spMoveD = tag.m_128457_(this.TAG_SP_MOVE_D);
        this.spCoupled = tag.m_128471_(this.TAG_SP_COUPLED);
        this.engine_on = tag.m_128471_(this.TAG_ENGINE_ON);
        this.spThrusterLevel = tag.m_128445_(this.TAG_SP_THRUSTER_LEVEL);
        this.radarMode = tag.m_128445_(this.TAG_RADAR_MODE);
        this.distributed_locking = tag.m_128471_(this.TAG_DISTRIBUTED_LOCKING);
        this.fpv_roll_rate_rc = tag.m_128457_(this.TAG_ROLL_RATE_RC);
        this.fpv_roll_rate_s = tag.m_128457_(this.TAG_ROLL_RATE_S);
        this.fpv_roll_rate_exp = tag.m_128457_(this.TAG_ROLL_RATE_EXP);
        this.fpv_yaw_rate_rc = tag.m_128457_(this.TAG_YAW_RATE_RC);
        this.fpv_yaw_rate_s = tag.m_128457_(this.TAG_YAW_RATE_S);
        this.fpv_yaw_rate_exp = tag.m_128457_(this.TAG_YAW_RATE_EXP);
        this.fpv_pitch_rate_rc = tag.m_128457_(this.TAG_PITCH_RATE_RC);
        this.fpv_pitch_rate_s = tag.m_128457_(this.TAG_PITCH_RATE_S);
        this.fpv_pitch_rate_exp = tag.m_128457_(this.TAG_PITCH_RATE_EXP);
        this.fpv_throttle_mid = tag.m_128457_(this.TAG_THROTTLE_MID);
        this.fpv_throttle_exp = tag.m_128457_(this.TAG_THROTTLE_EXP);
        this.step_thruster = tag.m_128457_(this.TAG_STEP_SIZE_THRUSTER);
        this.step_direction = tag.m_128457_(this.TAG_STEP_SIZE_Direction);
        this.max_iteration = tag.m_128451_(this.TAG_MAX_ITERATION);
        this.tolerance = tag.m_128457_(this.TAG_TOLERANCE);
        this.force_weight = tag.m_128457_(this.TAG_FORCE_WEIGHT);
        this.torque_weight = tag.m_128457_(this.TAG_TORQUE_WEIGHT);
        this.scale_factor = tag.m_128459_(this.TAG_SCALE_FACTOR);
        this.thr_reg = tag.m_128459_(this.TAG_THRUST_REG);
        this.hov_comp = tag.m_128457_(this.TAG_HOVER_COMP);
        this.select_rec = tag.m_128461_(this.TAG_SELECT_REC);
        this.isRecording = tag.m_128471_(this.TAG_IS_RECORDING);
        this.isReplay = tag.m_128471_(this.TAG_REPLAY);
        this.loop_mode = tag.m_128445_(this.TAG_LOOP_MODE);
        this.replay_index = tag.m_128445_(this.TAG_REPLAY_INDEX);
        this.record_file_index = tag.m_128445_(this.TAG_RECORD_FILE_INDEX);
        this.last_frame = tag.m_128451_(this.TAG_LAST_FRAME);
        this.air_move_p = tag.m_128457_(this.TAG_AIRSHIP_MOVE_P);
        this.air_move_d = tag.m_128457_(this.TAG_AIRSHIP_MOVE_D);
        this.air_rot_p = tag.m_128457_(this.TAG_AIRSHIP_ROT_P);
        this.air_rot_d = tag.m_128457_(this.TAG_AIRSHIP_ROT_D);
        this.setAlgorithmParameters();
    }

    public void onLoad() {
        super.onLoad();
        this.itemOptional = LazyOptional.of(() -> this.itemHandler);
        if (this.isReplay && this.replay_index != 0) {
            this.setRec(this.last_frame);
        }
    }

    public void resetSpaceShipParameters() {
        this.spRotP = 1.5f;
        this.spRotD = 0.75f;
        this.spForward = 1.0f;
        this.spSideways = 1.0f;
        this.spUpward = 1.0f;
        this.spMoveD = 0.75f;
        this.syncToClient();
    }

    public void resetAirshipParameters() {
        this.air_move_p = 1.0f;
        this.air_move_d = 0.5f;
        this.air_rot_p = 1.0f;
        this.air_rot_d = 0.5f;
        this.syncToClient();
    }

    public void resetFPVParameters() {
        this.fpv_roll_rate_rc = 1.0f;
        this.fpv_roll_rate_s = 0.7f;
        this.fpv_roll_rate_exp = 0.3f;
        this.fpv_yaw_rate_rc = 1.0f;
        this.fpv_yaw_rate_s = 0.7f;
        this.fpv_yaw_rate_exp = 0.3f;
        this.fpv_pitch_rate_rc = 1.0f;
        this.fpv_pitch_rate_s = 0.7f;
        this.fpv_pitch_rate_exp = 0.3f;
        this.fpv_throttle_mid = 0.25f;
        this.fpv_throttle_exp = 1.0f;
        this.syncToClient();
    }

    public void setSpRotP(float spRotP) {
        this.spRotP = spRotP > 0.0f ? spRotP : 0.0f;
        this.syncToClient();
    }

    public void setSpRotD(float spRotD) {
        this.spRotD = spRotD > 0.0f ? spRotD : 0.0f;
        this.syncToClient();
    }

    public void setSpForward(float spForward) {
        this.spForward = spForward > 0.0f ? spForward : 0.0f;
        this.syncToClient();
    }

    public void setSpSideways(float spSideways) {
        this.spSideways = spSideways > 0.0f ? spSideways : 0.0f;
        this.syncToClient();
    }

    public void setSpUpward(float spUpward) {
        this.spUpward = spUpward > 0.0f ? spUpward : 0.0f;
        this.syncToClient();
    }

    public void setSpMoveD(float spMoveD) {
        this.spMoveD = spMoveD > 0.0f ? spMoveD : 0.0f;
        this.syncToClient();
    }

    public void setAir_move_p(float air_move_p) {
        this.air_move_p = air_move_p > 0.0f ? air_move_p : 0.0f;
        this.syncToClient();
    }

    public void setAir_move_d(float air_move_d) {
        this.air_move_d = air_move_d > 0.0f ? air_move_d : 0.0f;
        this.syncToClient();
    }

    public void setAir_rot_p(float air_rot_p) {
        this.air_rot_p = air_rot_p > 0.0f ? air_rot_p : 0.0f;
        this.syncToClient();
    }

    public void setAir_rot_d(float air_rot_d) {
        this.air_rot_d = air_rot_d > 0.0f ? air_rot_d : 0.0f;
        this.syncToClient();
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
        this.syncToClient();
    }

    public void setSpCoupled(boolean spCoupled) {
        this.spCoupled = spCoupled;
        this.syncToClient();
    }

    public void setEngineOn(boolean engine_on) {
        this.engine_on = engine_on;
        this.syncToClient();
    }

    public boolean isSpCoupled() {
        return this.spCoupled;
    }

    public boolean isEngineOn() {
        return this.engine_on;
    }

    public void thrusterUp() {
        if (this.spThrusterLevel >= 9) {
            return;
        }
        this.spThrusterLevel = (byte)(this.spThrusterLevel + 1);
        this.syncToClient();
    }

    public void thrusterDown() {
        if (this.spThrusterLevel <= 1) {
            return;
        }
        this.spThrusterLevel = (byte)(this.spThrusterLevel - 1);
        this.syncToClient();
    }

    public void setThrusterLevel(int thrusterLevel) {
        thrusterLevel = Math.min(9, Math.max(1, thrusterLevel));
        this.spThrusterLevel = (byte)thrusterLevel;
        this.syncToClient();
    }

    public void nextRadarMode() {
        this.radarMode = (byte)(this.radarMode + 1);
        this.radarMode = this.radarMode > 5 ? (byte)0 : this.radarMode;
        this.syncToClient();
    }

    public void prevRadarMode() {
        this.radarMode = (byte)(this.radarMode - 1);
        this.radarMode = (byte)(this.radarMode < 0 ? 5 : (int)this.radarMode);
        this.syncToClient();
    }

    public void setFpv_roll_rate_rc(float fpv_roll_rate_rc) {
        this.fpv_roll_rate_rc = Mth.m_14036_((float)fpv_roll_rate_rc, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_roll_rate_s(float fpv_roll_rate_s) {
        this.fpv_roll_rate_s = Mth.m_14036_((float)fpv_roll_rate_s, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_roll_rate_exp(float fpv_roll_rate_exp) {
        this.fpv_roll_rate_exp = Mth.m_14036_((float)fpv_roll_rate_exp, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_yaw_rate_rc(float fpv_yaw_rate_rc) {
        this.fpv_yaw_rate_rc = Mth.m_14036_((float)fpv_yaw_rate_rc, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_yaw_rate_s(float fpv_yaw_rate_s) {
        this.fpv_yaw_rate_s = Mth.m_14036_((float)fpv_yaw_rate_s, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_yaw_rate_exp(float fpv_yaw_rate_exp) {
        this.fpv_yaw_rate_exp = Mth.m_14036_((float)fpv_yaw_rate_exp, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_pitch_rate_rc(float fpv_pitch_rate_rc) {
        this.fpv_pitch_rate_rc = Mth.m_14036_((float)fpv_pitch_rate_rc, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_pitch_rate_s(float fpv_pitch_rate_s) {
        this.fpv_pitch_rate_s = Mth.m_14036_((float)fpv_pitch_rate_s, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_pitch_rate_exp(float fpv_pitch_rate_exp) {
        this.fpv_pitch_rate_exp = Mth.m_14036_((float)fpv_pitch_rate_exp, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_throttle_mid(float fpv_throttle_mid) {
        this.fpv_throttle_mid = Mth.m_14036_((float)fpv_throttle_mid, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setFpv_throttle_exp(float fpv_throttle_exp) {
        this.fpv_throttle_exp = Mth.m_14036_((float)fpv_throttle_exp, (float)0.0f, (float)1.0f);
        this.syncToClient();
    }

    public void setStepSizeThruster(double stepSizeThruster) {
        this.step_thruster = (float)stepSizeThruster;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setStepSizeDirection(double stepSizeDirection) {
        this.step_direction = (float)stepSizeDirection;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setMaxIteration(int maxIteration) {
        this.max_iteration = maxIteration = Math.min(60, Math.max(1, maxIteration));
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setTolerance(double tolerance) {
        this.tolerance = (float)tolerance;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setForceWeight(double forceWeight) {
        this.force_weight = (float)forceWeight;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setTorqueWeight(double torqueWeight) {
        this.torque_weight = (float)torqueWeight;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public double getScaleFactor() {
        return this.scale_factor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scale_factor = scaleFactor;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setThrustReg(double thrustReg) {
        this.thr_reg = thrustReg;
        this.setAlgorithmParameters();
        this.syncToClient();
    }

    public void setHovComp(float hovComp) {
        this.hov_comp = hovComp;
        this.syncToClient();
    }

    public double getThrustReg() {
        return this.thr_reg;
    }

    public float getHovComp() {
        return this.hov_comp;
    }

    public double getStepSizeThruster() {
        return this.thrusterControlSystem.stepSizeThruster;
    }

    public double getStepSizeDirection() {
        return this.thrusterControlSystem.stepSizeDirection;
    }

    public int getMaxIteration() {
        return this.thrusterControlSystem.maxIteration;
    }

    public double getTolerance() {
        return this.thrusterControlSystem.tolerance;
    }

    public double getForceWeight() {
        return this.thrusterControlSystem.forceWeight;
    }

    public double getTorqueWeight() {
        return this.thrusterControlSystem.torqueWeight;
    }

    public int getReplayIndex() {
        return this.replay_index;
    }

    public void setReplayIndex(int replayIndex) {
        this.replay_index = (byte)replayIndex;
        this.syncToClient();
    }

    public void setIsReplay(boolean isReplay) {
        this.isReplay = isReplay;
        this.syncToClient();
    }

    public void setSelect_rec(String select_rec) {
        List itemRecords = this.getItemRecords();
        for (int i = 0; i < itemRecords.size(); ++i) {
            if (!((String)itemRecords.get(i)).equals(select_rec)) continue;
            this.record_file_index = (byte)i;
            this.select_rec = select_rec;
            this.syncToClient();
            return;
        }
    }

    public void nextLoopMode() {
        this.loop_mode = (byte)(this.loop_mode + 1);
        if (this.loop_mode > 2) {
            this.loop_mode = 0;
        }
        this.syncToClient();
    }

    public void ecoMode() {
        this.step_thruster = 0.25f;
        this.step_direction = 0.01f;
        this.max_iteration = 35;
        this.tolerance = 1.0f;
        this.force_weight = 1.0f;
        this.torque_weight = 1.0f;
        this.scale_factor = 1.0E-5;
        this.thr_reg = 1.0;
        this.setAlgorithmParameters();
    }

    public void normalMode() {
        this.step_thruster = 0.25f;
        this.step_direction = 0.01f;
        this.max_iteration = 35;
        this.tolerance = 1.0f;
        this.force_weight = 1.0f;
        this.torque_weight = 1.0f;
        this.scale_factor = 1.0E-5;
        this.thr_reg = 1.0;
        this.setAlgorithmParameters();
    }

    public void resetAlgorithmParameters() {
        this.step_thruster = 0.25f;
        this.step_direction = 0.01f;
        this.max_iteration = 35;
        this.tolerance = 1.0f;
        this.force_weight = 1.0f;
        this.torque_weight = 1.0f;
        this.scale_factor = 1.0E-4;
        this.thr_reg = 1.0;
        this.setAlgorithmParameters();
    }

    public void setAlgorithmParameters() {
        this.thrusterControlSystem.setParameters(this.step_thruster, this.step_direction, this.max_iteration, this.tolerance, this.force_weight, this.torque_weight, this.scale_factor, this.thr_reg);
        this.syncToClient();
    }

    public static class ThrusterControlSystem {
        private double[] lastThrusts;
        private Vector3f[] lastDirections;
        private double[] forceWeights;
        private double[] torqueWeights;
        private static final double FIXED_FORCE_WEIGHT = 100.0;
        private static final double FIXED_TORQUE_WEIGHT = 0.1;
        private static final double VECTOR_FORCE_WEIGHT = 1.0;
        private static final double VECTOR_TORQUE_WEIGHT = 5.0;
        private static final double DEFAULT_WEIGHT = 1.0;
        private double stepSizeThruster;
        private double stepSizeDirection;
        private int maxIteration;
        private double tolerance;
        private double forceWeight;
        private double torqueWeight;
        private double scaleFactor;
        private double thrust_reg = 0.005;
        private static final double MIN_THRUSTER = 1.0;
        private boolean needReset = false;
        private final CopyOnWriteArrayList<AbstractThrusterBE> thrusters = new CopyOnWriteArrayList();

        public void addThruster(AbstractThrusterBE thruster) {
            if (this.thrusters.contains(thruster)) {
                return;
            }
            this.thrusters.add(thruster);
            this.needReset = true;
        }

        public void removeThruster(AbstractThrusterBE thruster) {
            this.thrusters.remove(thruster);
        }

        public void updateThrusters() {
            this.thrusters.removeIf(be -> {
                boolean flag = be.m_58901_();
                if (flag) {
                    this.needReset = true;
                }
                return flag;
            });
        }

        private ArrayList<AbstractThrusterBE> getThrusters() {
            return new ArrayList<AbstractThrusterBE>(this.thrusters);
        }

        private void resetCache() {
            this.lastThrusts = null;
            this.lastDirections = null;
            this.forceWeights = null;
            this.torqueWeights = null;
            this.needReset = false;
        }

        public void updateControl(Vector3d targetForce, Vector3d targetTorque) {
            if (this.needReset) {
                this.resetCache();
                return;
            }
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            int n = tInstances.size();
            if (n == 0) {
                return;
            }
            double scale = 1.0;
            int maxScaleTries = 3;
            int scaleTry = 0;
            boolean converged = false;
            Vector3d scaledForce = new Vector3d();
            Vector3d scaledTorque = new Vector3d();
            if (this.lastThrusts == null || this.lastThrusts.length != n || this.forceWeights == null || this.torqueWeights == null) {
                this.lastThrusts = new double[n];
                this.lastDirections = new Vector3f[n];
                this.forceWeights = new double[n];
                this.torqueWeights = new double[n];
                for (int i = 0; i < n; ++i) {
                    AbstractThrusterBE t = tInstances.get(i);
                    this.lastThrusts[i] = Math.max(t.getCurrentThrust() * this.scaleFactor, 1.0);
                    this.lastDirections[i] = new Vector3f((Vector3fc)t.getCurrentDirectionProxy());
                    this.forceWeights[i] = 1.0;
                    this.torqueWeights[i] = 1.0;
                }
            }
            this.updateWeightsBasedOnTarget(targetForce);
            double[] currentThrusts = Arrays.copyOf(this.lastThrusts, n);
            Vector3f[] currentDirections = Arrays.copyOf(this.lastDirections, n);
            while (scaleTry < 3) {
                scaledForce.set((Vector3dc)targetForce).mul(scale);
                scaledTorque.set((Vector3dc)targetTorque).mul(scale);
                Vector3d internalScaledForce = new Vector3d((Vector3dc)scaledForce).mul(this.scaleFactor);
                Vector3d internalScaledTorque = new Vector3d((Vector3dc)scaledTorque).mul(this.scaleFactor);
                for (int iter = 0; iter < this.maxIteration; ++iter) {
                    this.optimizeThrusts(internalScaledForce, internalScaledTorque, currentThrusts, currentDirections);
                    this.optimizeDirections(internalScaledForce, internalScaledTorque, currentThrusts, currentDirections);
                    if (!this.checkConvergence(internalScaledForce, internalScaledTorque, currentThrusts, currentDirections)) continue;
                    converged = true;
                    break;
                }
                if (converged) {
                    this.applyResults(currentThrusts, currentDirections);
                    this.lastThrusts = currentThrusts;
                    this.lastDirections = currentDirections;
                    break;
                }
                scale *= 0.8;
                ++scaleTry;
            }
            if (!converged) {
                this.applyResults(currentThrusts, currentDirections);
                this.lastThrusts = currentThrusts;
                this.lastDirections = currentDirections;
            }
        }

        private void optimizeThrusts(Vector3d targetForce, Vector3d targetTorque, double[] thrusts, Vector3f[] directions) {
            int n = thrusts.length;
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            if (n != tInstances.size()) {
                return;
            }
            double[][] A = new double[6][n];
            double[] b = new double[]{targetForce.x, targetForce.y, targetForce.z, targetTorque.x, targetTorque.y, targetTorque.z};
            for (int j = 0; j < n; ++j) {
                AbstractThrusterBE thruster = tInstances.get(j);
                Vector3d r = new Vector3d((Vector3fc)thruster.getPositionOffset());
                Vector3d forceDir = new Vector3d((double)directions[j].x(), (double)directions[j].y(), (double)directions[j].z());
                Vector3d torqueDir = new Vector3d();
                r.cross((Vector3dc)forceDir, torqueDir);
                A[0][j] = -forceDir.x;
                A[1][j] = -forceDir.y;
                A[2][j] = -forceDir.z;
                A[3][j] = -torqueDir.x;
                A[4][j] = -torqueDir.y;
                A[5][j] = -torqueDir.z;
            }
            for (int innerIter = 0; innerIter < 1; ++innerIter) {
                double[] residual = this.computeResidual(A, b, thrusts);
                double[] gradient = this.computeWeightedGradient(A, residual, thrusts);
                for (int j = 0; j < n; ++j) {
                    gradient[j] = gradient[j] + this.thrust_reg * thrusts[j];
                }
                double maxGradient = 0.0;
                for (int j = 0; j < n; ++j) {
                    maxGradient = Math.max(maxGradient, Math.abs(gradient[j]));
                }
                double gradientScale = maxGradient > 1.0E-5 ? 1.0 / maxGradient : 1.0;
                for (int j = 0; j < n; ++j) {
                    double newThrust = thrusts[j] - this.stepSizeThruster * gradient[j] * gradientScale;
                    double maxThrust = tInstances.get(j).getMaxThrust() * this.scaleFactor;
                    thrusts[j] = newThrust = Math.max(1.0, Math.min(newThrust, maxThrust));
                }
            }
        }

        private void updateWeightsBasedOnTarget(Vector3d targetForce) {
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            Vector3d mainThrustDir = targetForce.lengthSquared() > 1.0E-6 ? new Vector3d((Vector3dc)targetForce).normalize() : new Vector3d(0.0, 0.0, 0.0);
            for (int i = 0; i < tInstances.size(); ++i) {
                AbstractThrusterBE t = tInstances.get(i);
                Vector3d thrusterDir = new Vector3d((double)this.lastDirections[i].x(), (double)this.lastDirections[i].y(), (double)this.lastDirections[i].z());
                double alignment = thrusterDir.dot((Vector3dc)mainThrustDir);
                if ((double)t.getMaxAngle() < 1.0E-5) {
                    if (alignment > 0.7) {
                        this.forceWeights[i] = 100.0 * (1.0 + alignment);
                        this.torqueWeights[i] = 0.1;
                        continue;
                    }
                    this.forceWeights[i] = 100.0;
                    this.torqueWeights[i] = 0.1;
                    continue;
                }
                if (alignment < 0.3) {
                    this.forceWeights[i] = 1.0;
                    this.torqueWeights[i] = 5.0 * (2.0 - alignment);
                    continue;
                }
                this.forceWeights[i] = 1.0;
                this.torqueWeights[i] = 5.0;
            }
        }

        private double[] computeWeightedGradient(double[][] A, double[] residual, double[] thrusts) {
            double[] gradient = new double[A[0].length];
            boolean weightsReady = this.forceWeights != null && this.torqueWeights != null && this.forceWeights.length == gradient.length && this.torqueWeights.length == gradient.length;
            for (int j = 0; j < gradient.length; ++j) {
                int i;
                double fWeight = weightsReady ? this.forceWeights[j] : 1.0;
                double tWeight = weightsReady ? this.torqueWeights[j] : 1.0;
                for (i = 0; i < 3; ++i) {
                    int n = j;
                    gradient[n] = gradient[n] + 2.0 * A[i][j] * residual[i] * fWeight;
                }
                for (i = 3; i < 6; ++i) {
                    int n = j;
                    gradient[n] = gradient[n] + 2.0 * A[i][j] * residual[i] * tWeight;
                }
                int n = j;
                gradient[n] = gradient[n] + this.thrust_reg * thrusts[j];
            }
            return gradient;
        }

        private void optimizeDirections(Vector3d targetForce, Vector3d targetTorque, double[] thrusts, Vector3f[] directions) {
            int n = thrusts.length;
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            if (n != tInstances.size()) {
                return;
            }
            Vector3d currentForce = new Vector3d();
            Vector3d currentTorque = new Vector3d();
            this.computeTotalForceAndTorque(thrusts, directions, currentForce, currentTorque);
            Vector3d forceError = new Vector3d((Vector3dc)targetForce).sub((Vector3dc)currentForce);
            Vector3d torqueError = new Vector3d((Vector3dc)targetTorque).sub((Vector3dc)currentTorque);
            for (int j = 0; j < n; ++j) {
                AbstractThrusterBE thruster = tInstances.get(j);
                if ((double)thruster.getMaxAngle() < 1.0E-5) continue;
                if (thrusts[j] < 1.0) {
                    thrusts[j] = 1.0;
                }
                Vector3d r = new Vector3d((Vector3fc)thruster.getPositionOffset());
                double fWeight = this.forceWeights != null && j < this.forceWeights.length ? this.forceWeights[j] : 1.0;
                double tWeight = this.torqueWeights != null && j < this.torqueWeights.length ? this.torqueWeights[j] : 1.0;
                Vector3d gradient = new Vector3d();
                gradient.add((Vector3dc)forceError.mul(thrusts[j] * fWeight, new Vector3d()));
                Vector3d torqueGrad = new Vector3d();
                torqueError.cross((Vector3dc)r, torqueGrad);
                torqueGrad.mul(thrusts[j] * tWeight);
                gradient.add((Vector3dc)torqueGrad);
                double gradientLength = gradient.length();
                if (gradientLength > 1.0E-5) {
                    gradient.mul(1.0 / gradientLength);
                }
                Vector3d currentDir = new Vector3d((double)directions[j].x(), (double)directions[j].y(), (double)directions[j].z());
                Vector3d newDir = new Vector3d((Vector3dc)currentDir).sub((Vector3dc)gradient.mul(this.stepSizeDirection));
                newDir.normalize();
                Vector3d clampedDir = thruster.clampDirection(newDir);
                directions[j].set(clampedDir.x(), clampedDir.y(), clampedDir.z());
            }
        }

        private void minimizeTotalThrust(Vector3d targetForce, Vector3d targetTorque, double[] thrusts, Vector3f[] directions) {
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            if (thrusts.length != tInstances.size()) {
                return;
            }
            double totalThrust = 0.0;
            Vector3d effectiveForce = new Vector3d();
            for (int i = 0; i < thrusts.length; ++i) {
                totalThrust += thrusts[i];
                effectiveForce.add((Vector3dc)new Vector3d((double)directions[i].x(), (double)directions[i].y(), (double)directions[i].z()).mul(thrusts[i]));
            }
            double efficiency = effectiveForce.length() / totalThrust;
            for (int i = 0; i < thrusts.length; ++i) {
                AbstractThrusterBE thruster = tInstances.get(i);
                if ((double)thruster.getMaxAngle() < 1.0E-5 || thrusts[i] < 5.0) continue;
                Vector3d dir = new Vector3d((double)directions[i].x(), (double)directions[i].y(), (double)directions[i].z());
                double conflictFactor = 0.0;
                for (int j = 0; j < thrusts.length; ++j) {
                    Vector3d otherDir;
                    double dot;
                    if (i == j || !((dot = dir.dot((Vector3dc)(otherDir = new Vector3d((double)directions[j].x(), (double)directions[j].y(), (double)directions[j].z())))) < -0.7) || !(Math.abs(thrusts[i] - thrusts[j]) < thrusts[i] * 0.3)) continue;
                    conflictFactor += thrusts[j] * (1.0 + dot);
                }
                if (!(conflictFactor > thrusts[i] * 0.5)) continue;
                Vector3d newDir = this.findBetterDirection(i, thrusts, directions, targetForce);
                directions[i].set((float)newDir.x, (float)newDir.y, (float)newDir.z);
            }
        }

        private Vector3d findBetterDirection(int idx, double[] thrusts, Vector3f[] directions, Vector3d target) {
            Vector3d currentDir = new Vector3d((double)directions[idx].x(), (double)directions[idx].y(), (double)directions[idx].z());
            Vector3d solution1 = new Vector3d((Vector3dc)target).normalize();
            Vector3d solution2 = new Vector3d();
            for (int i = 0; i < directions.length; ++i) {
                Vector3d otherDir;
                if (i == idx || !(currentDir.dot((Vector3dc)(otherDir = new Vector3d((double)directions[i].x(), (double)directions[i].y(), (double)directions[i].z()))) < -0.6)) continue;
                solution2.cross((Vector3dc)currentDir, otherDir);
                if (solution2.lengthSquared() < 0.01) {
                    solution2 = new Vector3d(-currentDir.y, currentDir.z, currentDir.x);
                }
                solution2.normalize();
                break;
            }
            return solution1.dot((Vector3dc)currentDir) > solution2.dot((Vector3dc)currentDir) ? solution1 : solution2;
        }

        private boolean checkConvergence(Vector3d targetForce, Vector3d targetTorque, double[] thrusts, Vector3f[] directions) {
            Vector3d currentForce = new Vector3d();
            Vector3d currentTorque = new Vector3d();
            this.computeTotalForceAndTorque(thrusts, directions, currentForce, currentTorque);
            double forceError = currentForce.distance((Vector3dc)targetForce);
            double torqueError = currentTorque.distance((Vector3dc)targetTorque);
            double totalError = this.forceWeight * forceError + this.torqueWeight * torqueError;
            return totalError < this.tolerance;
        }

        private void computeTotalForceAndTorque(double[] thrusts, Vector3f[] directions, Vector3d outForce, Vector3d outTorque) {
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            if (thrusts.length != tInstances.size()) {
                return;
            }
            outForce.zero();
            outTorque.zero();
            for (int j = 0; j < thrusts.length; ++j) {
                AbstractThrusterBE thruster = tInstances.get(j);
                Vector3d r = new Vector3d((Vector3fc)thruster.getPositionOffset());
                Vector3d force = new Vector3d((double)directions[j].x(), (double)directions[j].y(), (double)directions[j].z()).mul(thrusts[j]).negate();
                Vector3d torque = r.cross((Vector3dc)force, new Vector3d());
                outForce.add((Vector3dc)force);
                outTorque.add((Vector3dc)torque);
            }
        }

        private void applyResults(double[] thrusts, Vector3f[] directions) {
            ArrayList<AbstractThrusterBE> tInstances = this.getThrusters();
            if (thrusts.length != tInstances.size()) {
                return;
            }
            for (int i = 0; i < thrusts.length; ++i) {
                AbstractThrusterBE thruster = tInstances.get(i);
                double unscaledThrust = thrusts[i] / this.scaleFactor;
                double targetThrust = Math.max(unscaledThrust, 1.0);
                thruster.setCurrentThrust(targetThrust);
                thruster.setCurrentDirection(directions[i]);
            }
        }

        private double[] computeResidual(double[][] A, double[] b, double[] u) {
            double[] residual = new double[6];
            Arrays.fill(residual, 0.0);
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < u.length; ++j) {
                    int n = i;
                    residual[n] = residual[n] + A[i][j] * u[j];
                }
                int n = i;
                residual[n] = residual[n] - b[i];
            }
            return residual;
        }

        private double[] computeGradient(double[][] A, double[] residual) {
            double[] gradient = new double[A[0].length];
            for (int j = 0; j < gradient.length; ++j) {
                for (int i = 0; i < 6; ++i) {
                    int n = j;
                    gradient[n] = gradient[n] + 2.0 * A[i][j] * residual[i];
                }
            }
            return gradient;
        }

        public void setParameters(double stepSizeThruster, double stepSizeDirection, int maxIteration, double tolerance, double forceWeight, double torqueWeight, double scaleFactor, double thrust_reg) {
            this.stepSizeThruster = stepSizeThruster;
            this.stepSizeDirection = stepSizeDirection;
            this.maxIteration = maxIteration;
            this.tolerance = tolerance;
            this.forceWeight = forceWeight;
            this.torqueWeight = torqueWeight;
            this.scaleFactor = scaleFactor;
            this.thrust_reg = thrust_reg;
            this.needReset = true;
        }

        public void setEngineOff() {
            this.getThrusters().forEach(t -> {
                t.setCurrentThrust(0.0);
                t.setCurrentDirection(t.getBaseDirection());
            });
        }
    }

    public static class UnpackedStick {
        public Vector2d leftJoy;
        public Vector2d rightJoy;
        public Vector2d rightJoyRot;
        public Vector2d btJoy;
        public Vector2d btJoyRot;
        private Matrix2d m2d;
        private Matrix2d m2dL;

        public UnpackedStick(Vector3f faceVec, double lJoyX, double lJoyY, double rJoyX, double rJoyY, double btJoyX, double btJoyY) {
            this.m2d = new Matrix2d((double)(-faceVec.x), (double)faceVec.z, (double)(-faceVec.z), (double)(-faceVec.x));
            this.m2dL = new Matrix2d((double)(-faceVec.x), (double)(-faceVec.z), (double)faceVec.z, (double)(-faceVec.x));
            this.leftJoy = new Vector2d(lJoyX, lJoyY);
            this.rightJoy = new Vector2d(rJoyX, rJoyY);
            this.rightJoyRot = new Vector2d((Vector2dc)this.m2dL.transform(new Vector2d((Vector2dc)this.rightJoy)));
            this.btJoy = new Vector2d(btJoyX, btJoyY);
            this.btJoyRot = new Vector2d((Vector2dc)this.m2d.transform(new Vector2d((Vector2dc)this.btJoy)));
        }

        public UnpackedStick() {
            this.m2d = new Matrix2d();
            this.m2dL = new Matrix2d();
            this.leftJoy = new Vector2d();
            this.rightJoy = new Vector2d();
            this.rightJoyRot = new Vector2d();
            this.btJoy = new Vector2d();
            this.btJoyRot = new Vector2d();
        }

        public Matrix2d getM2d() {
            return this.m2d;
        }

        public Matrix2d getM2dL() {
            return this.m2dL;
        }
    }
}

