/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base;

import java.util.Map;
import kotlin.jvm.functions.Function1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotor;
import net.shao.valkyrien_space_war.block.joint.base.CommandConstraintComponent;
import net.shao.valkyrien_space_war.block.joint.base.IJointCommandBE;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorMenu;
import net.shao.valkyrien_space_war.function.rs_channel.IRsChannelReceiver;
import net.shao.valkyrien_space_war.function.rs_channel.RsChannelManager;
import net.shao.valkyrien_space_war.function.schematic.ICopyableBE;
import net.shao.valkyrien_space_war.function.util.BeRendererUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.function.vs.inducer.ILookupShipsForceInducer;
import net.shao.valkyrien_space_war.function.vs.inducer.LookupShipsForceInducer;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.joint.UpdateSeparatePacket;
import net.shao.valkyrien_space_war.network.joint.UpdateSeqCommandsPacket;
import net.shao.valkyrien_space_war.network.rs_channel.UpdateRsReceiverChannelPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;

public abstract class AbstractServoMotorBE
extends ModConnectorBE
implements IJointCommandBE,
ILookupShipsForceInducer,
ICopyableBE,
MenuProvider,
IRsChannelReceiver {
    public final Vector3f baseDirection;
    private int lastRedStone = 0;
    private String rsChannel = "";
    private final CommandConstraintComponent commandConstraintComponent;
    public final Quaternionf rotationFromState;
    public final float rotationYFromState;
    public float[] lastValues = new float[4];
    public float[] currentValues = new float[4];

    public AbstractServoMotorBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.registerRsChannelReceiver();
        Direction value = (Direction)pBlockState.m_61143_((Property)AbstractServoMotor.FACING);
        this.baseDirection = new Vector3f((float)value.m_122429_(), (float)value.m_122430_(), (float)value.m_122431_());
        Direction value2 = (Direction)pBlockState.m_61143_((Property)AbstractServoMotor.HORIZONTAL_FACING);
        Vector3f baseDir2 = new Vector3f((float)value2.m_122429_(), (float)value2.m_122430_(), (float)value2.m_122431_());
        Direction value3 = (Direction)pBlockState.m_61143_((Property)AbstractServoMotor.CLICK_FACE);
        Vector3f clickFace = new Vector3f((float)value3.m_122429_(), (float)value3.m_122430_(), (float)value3.m_122431_());
        this.rotationFromState = BeRendererUtil.getRotationFromFace(new Vector3f((Vector3fc)this.baseDirection), baseDir2, clickFace);
        this.rotationYFromState = BeRendererUtil.getRotationYFromFace(new Vector3f((Vector3fc)this.baseDirection), baseDir2, clickFace);
        this.commandConstraintComponent = this.newCommandConstraintComponent();
    }

    public void syncToClientWithCommand() {
        this.syncToClient();
        ModNetworkHandler.sendToNearbyPlayers(10, this.f_58857_, this.m_58899_(), new UpdateSeqCommandsPacket(this.m_58899_(), this.getCommandSequence()));
        ModNetworkHandler.sendToNearbyPlayers(10, this.f_58857_, this.m_58899_(), new UpdateSeparatePacket(this.m_58899_(), this.getSeparateControl()));
    }

    protected abstract CommandConstraintComponent newCommandConstraintComponent();

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.m_58904_();
    }

    @Override
    public void tick(Level level, BlockPos pPos, BlockState pState1) {
        super.tick(level, pPos, pState1);
        if (level.m_5776_()) {
            return;
        }
        boolean isValueChanged = false;
        this.currentValues = this.commandConstraintComponent.getCurrentValue();
        for (int i = 0; i < 4; ++i) {
            if (this.currentValues[i] == this.lastValues[i]) continue;
            isValueChanged = true;
            break;
        }
        if (isValueChanged) {
            this.syncToClient();
        }
        this.lastValues = (float[])this.currentValues.clone();
        this.commandConstraintComponent.update();
        if (this.commandConstraintComponent.isPDMode()) {
            if (this.commandConstraintComponent.getAttachment() == null) {
                return;
            }
            LoadedServerShip otherShip = VsUtil.getLoadedShipById((ServerLevel)level, this.commandConstraintComponent.getAttachment().shipId1());
            if (otherShip == null) {
                return;
            }
            LookupShipsForceInducer inducer = LookupShipsForceInducer.getOrCreate((ServerShip)otherShip);
            inducer.update(this);
        }
    }

    @Override
    public CommandConstraintComponent getCommandConstraintComponent() {
        return this.commandConstraintComponent;
    }

    @Override
    public void onActivationChanged(int power) {
        if (this.lastRedStone != power) {
            this.lastRedStone = power;
            this.getCommandConstraintComponent().onActivationChanged(power);
        }
    }

    @Override
    public void receiveRsChannel(String channelName, int power) {
        if (this.f_58857_ == null || this.f_58857_.m_7654_() == null) {
            return;
        }
        this.f_58857_.m_7654_().execute(() -> {
            if (channelName.equals(this.rsChannel)) {
                this.onActivationChanged(power);
            }
            this.commandConstraintComponent.receiveSprtRsChannel(channelName, power);
        });
    }

    @Override
    public void setRsChannel(String rsChannel) {
        if (rsChannel != null) {
            this.rsChannel = rsChannel;
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.m_6596_();
            }
        }
    }

    @Override
    public String getRsChannel() {
        return this.rsChannel;
    }

    public void updateRsChannelToServer() {
        ModNetworkHandler.sendToServer(new UpdateRsReceiverChannelPacket(this.m_58899_(), this.rsChannel));
    }

    public void m_7651_() {
        super.m_7651_();
        this.getCommandConstraintComponent().removeConstraintAndCollision();
        this.removeRsChannelReceiver();
    }

    public void touch(BlockState state, ServerLevel level, BlockPos pos) {
        if (!this.hasConstraints()) {
            this.activation(level);
        }
    }

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return ModConnectorBE.ConnectorType.BEARING;
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.getCommandConstraintComponent().loadTag(tag);
        this.loadRsChannelFromTag(tag);
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        this.getCommandConstraintComponent().putTag(tag);
        this.putRsChannelToTag(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.getCommandConstraintComponent().load(tag);
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getCommandConstraintComponent().saveAdditional(tag);
    }

    @Override
    public void updatePhysics(PhysShip physShip, VsUtil.PhysImplSnapshot snapshot, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        if (this.commandConstraintComponent != null) {
            this.commandConstraintComponent.onPhyTick(physShip, snapshot, lookupPhysShip);
        }
    }

    @Override
    public void onCopy(ServerLevel level, BlockPos pos, BlockState state, CompoundTag tag) {
        this.putTag(tag);
        this.getCommandConstraintComponent().onCopy(level, pos, state, tag);
    }

    @Override
    public void onPaste(ServerLevel level, Map<Long, ServerShip> newShips, Map<Long, AABB> newShipAABBs, BlockPos pos, BlockState state, CompoundTag tag) {
        RsChannelManager.onPaste(this, level, newShips, newShipAABBs, pos, state, tag);
        this.getCommandConstraintComponent().onPaste(level, newShips, newShipAABBs, pos, state, tag);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Servo Motor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ServoMotorMenu(pContainerId, pPlayerInventory, this);
    }
}

