/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.jvm.functions.Function1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotor;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.SeqCommandHelper;
import net.shao.valkyrien_space_war.block.joint.command.CmdEffectiveRange;
import net.shao.valkyrien_space_war.block.joint.command.ICommandTypeProvider;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;
import net.shao.valkyrien_space_war.block.joint.command.SeparateMotorCommand;
import net.shao.valkyrien_space_war.event.ServerEvent;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.function.vs.DirectionRotationCalculator;
import net.shao.valkyrien_space_war.function.vs.VsConstraintUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.joint.UpdateAttachmentPacket;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServer;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;

public class CommandConstraintComponent
implements ICommandTypeProvider {
    protected final AbstractServoMotorBE be;
    protected CopyOnWriteArrayList<MotorCommand[]> commandSequence = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<SeparateMotorCommand> separateControl = new CopyOnWriteArrayList();
    protected ArrayList<Integer> constraintIds = new ArrayList();
    protected int noShipFlicker = 0;
    protected static final int FLICKER_DURATION = 60;
    protected float[] currentValue = new float[4];
    protected float[] commandValue = new float[4];
    protected float otherAngle = 0.0f;
    protected float rot_p = 100.0f;
    protected float rot_d = 100.0f;
    protected static final double BASE_OFFSET = 0.5;
    protected static final double ACCURACY = 0.1;
    protected VsConstraintUtil.AttachmentConstraintRecord attachment;
    protected Direction selfDir;
    protected int d3DDataValue = 0;
    protected int currentCommandIndex = 0;
    protected int executionTimer = 0;
    protected final Vec3 blockCenter;
    protected final CmdEffectiveRange effectiveRange;
    protected int physicsTicksPerSec;
    protected boolean isPDMode = false;
    protected HashMap<Integer, Runnable> sprtTasks = new HashMap();
    private boolean noAttach = true;
    protected long beat;
    protected float[] oldValue;
    protected Quaterniond rotationYFromState = null;
    private Vector3dc faceVector;
    protected Quaterniond rotFromD3DDataValue;

    public CommandConstraintComponent(AbstractServoMotorBE be, CmdEffectiveRange effectiveRange) {
        this.be = be;
        this.blockCenter = be.m_58899_().m_252807_();
        this.effectiveRange = effectiveRange;
        this.selfDir = (Direction)be.m_58900_().m_61143_((Property)AbstractServoMotor.FACING);
        this.physicsTicksPerSec = VSCoreConfig.SERVER.getPt().getPhysicsTicksPerGameTick() * 20;
    }

    public float[] getCurrentValue() {
        return this.currentValue;
    }

    public VsConstraintUtil.AttachmentConstraintRecord getAttachment() {
        return this.attachment;
    }

    public boolean isPDMode() {
        return this.isPDMode;
    }

    public void setPDMode(boolean isPDMode) {
        this.isPDMode = isPDMode;
        if (this.attachment != null) {
            this.updateConstraint(this.attachment);
        }
        this.be.syncToClientWithCommand();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPdModeClient(boolean isPDMode) {
        this.isPDMode = isPDMode;
    }

    public void update() {
        LoadedServerShip otherShip;
        Level level = this.be.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        if (this.attachment == null) {
            if (!this.noAttach) {
                this.sendAttachmentToClient();
            }
            this.noAttach = true;
            return;
        }
        if (this.noAttach) {
            this.noAttach = false;
            this.sendAttachmentToClient();
        }
        if (this.noShipFlicker < 60 && this.attachment != null) {
            this.updateConstraint(this.attachment);
        }
        if ((otherShip = VsUtil.getLoadedShipById((ServerLevel)level, this.attachment != null ? this.attachment.shipId1() : -1L)) == null) {
            return;
        }
        if (this.getCommandSequence().isEmpty()) {
            this.addCommand(this.effectiveRange.newStopCmds());
            return;
        }
        this.sprtTasks.forEach((id, task) -> task.run());
        this.checkCommandTick();
    }

    public void setAttachment(VsConstraintUtil.AttachmentConstraintRecord attachment) {
        this.attachment = attachment;
    }

    private void sendAttachmentToClient() {
        ModNetworkHandler.sendToNearbyPlayers(10, this.be.m_58904_(), this.be.m_58899_(), new UpdateAttachmentPacket(this.be.m_58899_(), this.attachment));
    }

    public void onPhyTick(PhysShip ship1, VsUtil.PhysImplSnapshot ship1Snapshot, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        Vector3d currentRelativeOmega;
        Quaterniond targetRot;
        if (this.attachment == null) {
            return;
        }
        VsUtil.PhysImplSnapshot ship0Snapshot = null;
        PhysShip ship0 = (PhysShip)lookupPhysShip.invoke((Object)this.attachment.shipId0());
        if (ship0 != null) {
            targetRot = new Quaterniond(ship0.getTransform().getShipToWorldRotation());
            ship0Snapshot = VsUtil.createPhysImplSnapshot(ship0);
        } else {
            targetRot = new Quaterniond();
        }
        Quaterniond originalRot = new Quaterniond().rotateZ(Math.toRadians(this.currentValue[2])).rotateX(Math.toRadians(this.currentValue[0])).rotateY(Math.toRadians(this.currentValue[1]));
        Quaterniond temp = new Quaterniond((Quaterniondc)this.getRotationYFromState());
        Quaterniond temp2 = new Quaterniond((Quaterniondc)temp).mul((Quaterniondc)originalRot).mul((Quaterniondc)temp.conjugate());
        Quaterniond transformedRot = targetRot.mul((Quaterniondc)temp2);
        if (this.rotFromD3DDataValue != null) {
            transformedRot = transformedRot.mul((Quaterniondc)this.rotFromD3DDataValue);
        }
        Quaterniond errorRot = new Quaterniond((Quaterniondc)transformedRot).conjugate().mul((Quaterniondc)new Quaterniond(ship1Snapshot.rot()));
        Vector3f xPoint = errorRot.transform(new Vector3f(1.0f, 0.0f, 0.0f));
        Vector3f zPoint = errorRot.transform(new Vector3f(0.0f, 0.0f, 1.0f));
        float y_rot = (float)Math.toDegrees(-Math.atan2(zPoint.x(), zPoint.z()));
        float x_rot = (float)Math.toDegrees(Math.atan2(zPoint.y(), zPoint.z()));
        float z_rot = (float)Math.toDegrees(-Math.atan2(xPoint.y(), xPoint.x()));
        if (ship0Snapshot != null) {
            Vector3d omega0 = new Vector3d(ship0Snapshot.omega());
            Vector3d omega1 = new Vector3d(ship1Snapshot.omega());
            currentRelativeOmega = omega1.sub((Vector3dc)omega0);
        } else {
            currentRelativeOmega = new Vector3d(ship1Snapshot.omega());
        }
        Quaterniond conjugate = new Quaterniond(ship1Snapshot.rot()).conjugate();
        currentRelativeOmega = conjugate.transform(currentRelativeOmega);
        Vector3d torque = new Vector3d((double)(x_rot * this.rot_p) + -currentRelativeOmega.x() * (double)this.rot_d, (double)(y_rot * this.rot_p) + -currentRelativeOmega.y() * (double)this.rot_d, (double)(z_rot * this.rot_p) + -currentRelativeOmega.z() * (double)this.rot_d);
        ship1.applyRotDependentTorque((Vector3dc)torque.mul(ship1Snapshot.momentOfInertiaTensor()));
    }

    public static float clampWithinB(float a, float b) {
        float absB = Math.abs(b);
        return Math.max(-absB, Math.min(a, absB));
    }

    public void onActivationChanged(int power) {
        if (this.currentCommandIndex == -1) {
            if (power > 0) {
                this.nextCommand();
            }
            return;
        }
        if (!this.commandSequence.isEmpty() && this.commandSequence.get(this.currentCommandIndex) != null && power > 0) {
            switch (SeqCommandHelper.getCmdHead(this.commandSequence.get(this.currentCommandIndex)).getType()) {
                case WAIT_FOR_PULSE: 
                case EXEC_UNTIL_PULSE: {
                    this.nextCommand();
                }
            }
        }
    }

    public void receiveSprtRsChannel(String channelName, int power) {
        List<SeparateMotorCommand> separateControl = this.getSeparateControl();
        for (int i = 0; i < separateControl.size(); ++i) {
            MotorCommand[] commands;
            MotorCommand cmdHead;
            if (!separateControl.get(i).getRsChannelName().equals(channelName) || (cmdHead = SeqCommandHelper.getCmdHead(commands = separateControl.get(i).getCommands())) == null) continue;
            float[] result = new float[]{this.currentValue[0], this.currentValue[1], this.currentValue[2], this.currentValue[3]};
            if (cmdHead.getType() == MotorCommandType.EXEC) {
                for (int j = 0; j < commands.length; ++j) {
                    if (commands[j] == null) continue;
                    result[j] = commands[j].getParam1();
                }
                this.setCurrentValue(result);
                continue;
            }
            if (cmdHead.getType() != MotorCommandType.EXEC_UNTIL_PULSE) continue;
            if (power > 0) {
                this.sprtTasks.put(i, () -> {
                    float[] currentValue = this.getCurrentValue();
                    for (int j = 0; j < commands.length; ++j) {
                        if (commands[j] == null) continue;
                        result[j] = currentValue[j] + commands[j].getParam1() / 20.0f;
                        if (j != 3) continue;
                        result[j] = Math.max(0.0f, Math.min(15.0f, result[j]));
                    }
                    this.setCurrentValue(result);
                });
                continue;
            }
            this.sprtTasks.remove(i);
        }
    }

    public void removeConstraintAndCollision(boolean initValues) {
        Level level = this.be.m_58904_();
        if (level != null && level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.attachment != null) {
            if (serverLevel.m_7654_().m_129918_()) {
                return;
            }
            this.removeConstraints(serverLevel);
            VsUtil.getShipObjectWorldCore(serverLevel).enableCollisionBetweenBodies(this.attachment.shipId0(), this.attachment.shipId1());
            this.attachment = null;
            if (initValues) {
                this.currentValue = new float[4];
            }
        }
    }

    public void removeConstraints(ServerLevel serverLevel) {
        ServerShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(serverLevel);
        this.constraintIds.forEach(id -> VsUtil.removeConstraint(shipObjectWorldCore, (int)id));
        this.constraintIds.clear();
    }

    public void removeConstraintAndCollision() {
        this.removeConstraintAndCollision(false);
    }

    public float[] getRenderValue() {
        if (this.oldValue == null) {
            return this.currentValue;
        }
        float[] deltaValue = new float[4];
        float frameTime = this.getFrameTime();
        for (int i = 0; i < 4; ++i) {
            deltaValue[i] = i == 3 ? Mth.m_14179_((float)frameTime, (float)this.oldValue[i], (float)this.currentValue[i]) : Mth.m_14179_((float)frameTime, (float)this.oldValue[i], (float)this.currentValue[i]);
        }
        return deltaValue;
    }

    public float getFrameTime() {
        float v = (float)(System.currentTimeMillis() - this.beat) / 1000.0f;
        return Mth.m_14036_((float)(v * 20.0f), (float)0.0f, (float)1.0f);
    }

    public void loadTag(CompoundTag tag) {
        if (this.be.m_58904_() != null && this.be.m_58904_().f_46443_) {
            this.beat = System.currentTimeMillis();
            this.oldValue = this.currentValue;
        }
        this.currentValue = this.effectiveRange.loadTag(tag);
        this.otherAngle = tag.m_128457_("otherAngle");
        this.d3DDataValue = tag.m_128451_("d3DData");
        this.currentCommandIndex = tag.m_128451_("currentIndex");
        this.executionTimer = tag.m_128451_("execTimer");
        this.isPDMode = tag.m_128471_("isPDMode");
        if (this.be.m_58904_() != null && !this.be.m_58904_().m_5776_() && this.attachment != null) {
            this.updateConstraint(this.attachment);
        }
    }

    public void putTag(CompoundTag tag) {
        this.effectiveRange.putTag(tag, this.currentValue);
        tag.m_128350_("otherAngle", this.otherAngle);
        tag.m_128405_("d3DData", this.d3DDataValue);
        tag.m_128405_("currentIndex", this.currentCommandIndex);
        tag.m_128405_("execTimer", this.executionTimer);
        tag.m_128379_("isPDMode", this.isPDMode);
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("attach_cst")) {
            this.attachment = VsConstraintUtil.deserializeAttachmentConstraint(tag.m_128469_("attach_cst"));
        }
        this.rot_p = tag.m_128457_("rot_p");
        this.rot_d = tag.m_128457_("rot_d");
        this.commandSequence.clear();
        ListTag commandList = tag.m_128437_("CommandSequence", 9);
        for (Object subTag : commandList) {
            ListTag subList = (ListTag)subTag;
            MotorCommand[] cmds = this.cmdsFromTag(subList);
            this.commandSequence.add(cmds);
        }
        this.validateSequence();
        this.separateControl.clear();
        ListTag separateControlList = tag.m_128437_("SeparateControl", 9);
        for (Tag subTag : separateControlList) {
            ListTag subList = (ListTag)subTag;
            MotorCommand[] cmds = this.cmdsFromTag(subList);
            this.separateControl.add(new SeparateMotorCommand("", cmds));
        }
        ListTag separateChannelNames = tag.m_128437_("separateChannelNames", 8);
        for (int i = 0; i < separateChannelNames.size(); ++i) {
            String channelName = separateChannelNames.m_128778_(i);
            SeparateMotorCommand cmd = this.separateControl.get(i);
            cmd.setRsChannelName(channelName);
        }
    }

    public void saveAdditional(CompoundTag tag) {
        if (this.attachment != null) {
            tag.m_128365_("attach_cst", (Tag)VsConstraintUtil.serializeAttachmentConstraint(this.attachment));
        }
        tag.m_128350_("rot_p", this.rot_p);
        tag.m_128350_("rot_d", this.rot_d);
        ListTag commandList = new ListTag();
        for (MotorCommand[] motorCommandArray : this.commandSequence) {
            ListTag subList = this.cmdToTag(motorCommandArray);
            commandList.add((Object)subList);
        }
        tag.m_128365_("CommandSequence", (Tag)commandList);
        ListTag separateControlList = new ListTag();
        for (SeparateMotorCommand cmd : this.separateControl) {
            MotorCommand[] cmds = cmd.getCommands();
            ListTag subList = this.cmdToTag(cmds);
            separateControlList.add((Object)subList);
        }
        tag.m_128365_("SeparateControl", (Tag)separateControlList);
        ListTag listTag = new ListTag();
        for (SeparateMotorCommand cmd : this.separateControl) {
            listTag.add((Object)StringTag.m_129297_((String)cmd.getRsChannelName()));
        }
        tag.m_128365_("separateChannelNames", (Tag)listTag);
    }

    protected MotorCommand[] cmdsFromTag(ListTag subList) {
        MotorCommand[] cmds = new MotorCommand[subList.size()];
        for (int i = 0; i < subList.size(); ++i) {
            CompoundTag cmdTag = (CompoundTag)subList.get(i);
            String typeStr = cmdTag.m_128461_("Type");
            try {
                MotorCommandType type = MotorCommandType.valueOf(typeStr);
                MotorCommand cmd = new MotorCommand(type);
                cmd.setParam1(cmdTag.m_128451_("Param1"));
                cmd.setParam2(cmdTag.m_128451_("Param2"));
                cmds[i] = cmd;
                continue;
            }
            catch (IllegalArgumentException e) {
                cmds[i] = null;
            }
        }
        return cmds;
    }

    protected ListTag cmdToTag(MotorCommand[] cmds) {
        ListTag subList = new ListTag();
        for (int i = 0; i < cmds.length; ++i) {
            CompoundTag cmdTag = new CompoundTag();
            if (cmds[i] == null) {
                cmdTag.m_128359_("Type", "null");
            } else {
                cmdTag.m_128359_("Type", cmds[i].getType().name());
                cmdTag.m_128350_("Param1", cmds[i].getParam1());
                cmdTag.m_128350_("Param2", cmds[i].getParam2());
            }
            subList.add((Object)cmdTag);
        }
        return subList;
    }

    public void onCopy(ServerLevel level, BlockPos pos, BlockState state, CompoundTag tag) {
        if (tag.m_128441_("attach_cst")) {
            VsConstraintUtil.AttachmentConstraintRecord attachmentConstraintRecord = VsConstraintUtil.deserializeAttachmentConstraint(tag.m_128469_("attach_cst"));
            Vector3d localPos0 = new Vector3d(attachmentConstraintRecord.localPos0());
            Vector3d localPos1 = new Vector3d(attachmentConstraintRecord.localPos1());
            LoadedServerShip ship0 = VsUtil.getLoadedShipById(level, attachmentConstraintRecord.shipId0());
            LoadedServerShip ship1 = VsUtil.getLoadedShipById(level, attachmentConstraintRecord.shipId1());
            if (ship1 == null) {
                return;
            }
            CompoundTag compound = tag.m_128469_("attach_cst");
            Vector3d ship0AabbCenter = ship0.getShipAABB().center(new Vector3d());
            Vector3d lp0 = localPos0.sub((Vector3dc)ship0AabbCenter, new Vector3d());
            CompoundTag posTag0 = new CompoundTag();
            posTag0.m_128347_("x", lp0.x());
            posTag0.m_128347_("y", lp0.y());
            posTag0.m_128347_("z", lp0.z());
            compound.m_128365_("lp0", (Tag)posTag0);
            Vector3d ship1AabbCenter = ship1.getShipAABB().center(new Vector3d());
            Vector3d lp1 = localPos1.sub((Vector3dc)ship1AabbCenter, new Vector3d());
            CompoundTag posTag1 = new CompoundTag();
            posTag1.m_128347_("x", lp1.x());
            posTag1.m_128347_("y", lp1.y());
            posTag1.m_128347_("z", lp1.z());
            compound.m_128365_("lp1", (Tag)posTag1);
            compound.m_128356_("sid0", attachmentConstraintRecord.shipId0());
            compound.m_128356_("sid1", attachmentConstraintRecord.shipId1());
        }
    }

    public void onPaste(ServerLevel level, Map<Long, ServerShip> newShips, Map<Long, AABB> newShipAABBs, BlockPos pos, BlockState state, CompoundTag tag) {
        ListTag newNames = new ListTag();
        ListTag separateChannelNames = tag.m_128437_("separateChannelNames", 8);
        for (int i = 0; i < separateChannelNames.size(); ++i) {
            String channelName = separateChannelNames.m_128778_(i);
            String[] strings = ModGuiUtil.splitFirstOccurrence(channelName, "-");
            if (strings[0] == null || strings[0].isEmpty()) continue;
            long oldId = ModGuiUtil.filterToInt(strings[0]);
            long newId = newShips.get(oldId).getId();
            String newChannelName = newId + "-" + (strings[1] == null ? "" : strings[1]);
            newNames.add((Object)StringTag.m_129297_((String)newChannelName));
        }
        tag.m_128365_("separateChannelNames", (Tag)newNames);
        if (tag.m_128441_("attach_cst")) {
            VsConstraintUtil.AttachmentConstraintRecord attachmentConstraintRecord = VsConstraintUtil.deserializeAttachmentConstraint(tag.m_128469_("attach_cst"));
            ServerShip newSelfShip = newShips.get(attachmentConstraintRecord.shipId0());
            ServerShip newOtherShip = newShips.get(attachmentConstraintRecord.shipId1());
            CompoundTag compound = tag.m_128469_("attach_cst");
            Vec3 ship0AabbCenter = newShipAABBs.get(attachmentConstraintRecord.shipId0()).m_82399_();
            Vector3d lp0 = new Vector3d(ship0AabbCenter.m_7096_(), ship0AabbCenter.m_7098_(), ship0AabbCenter.m_7094_()).add(attachmentConstraintRecord.localPos0());
            CompoundTag posTag0 = new CompoundTag();
            posTag0.m_128347_("x", lp0.x());
            posTag0.m_128347_("y", lp0.y());
            posTag0.m_128347_("z", lp0.z());
            compound.m_128365_("lp0", (Tag)posTag0);
            Vec3 ship1AabbCenter = newShipAABBs.get(attachmentConstraintRecord.shipId1()).m_82399_();
            Vector3d lp1 = new Vector3d(ship1AabbCenter.m_7096_(), ship1AabbCenter.m_7098_(), ship1AabbCenter.m_7094_()).add(attachmentConstraintRecord.localPos1());
            CompoundTag posTag1 = new CompoundTag();
            posTag1.m_128347_("x", lp1.x());
            posTag1.m_128347_("y", lp1.y());
            posTag1.m_128347_("z", lp1.z());
            compound.m_128365_("lp1", (Tag)posTag1);
            compound.m_128356_("sid0", newSelfShip.getId());
            compound.m_128356_("sid1", newOtherShip.getId());
        }
    }

    public ServerShip getServerShip() {
        return VsUtil.getShip((ServerLevel)this.be.m_58904_(), this.be.m_58899_());
    }

    public LoadedServerShip getSelfShip() {
        if (this.attachment == null || this.be.m_58904_() == null) {
            return null;
        }
        return VsUtil.getLoadedShipById((ServerLevel)this.be.m_58904_(), this.attachment.shipId0());
    }

    public boolean hasConstraints() {
        return this.attachment != null;
    }

    public List<MotorCommand[]> getCommandSequence() {
        return this.commandSequence;
    }

    public List<SeparateMotorCommand> getSeparateControl() {
        return this.separateControl;
    }

    public List<MotorCommand[]> setAndFilterCommandSequence(List<MotorCommand[]> commandSequence) {
        this.commandSequence.clear();
        for (MotorCommand[] motorCommand : commandSequence) {
            if (!this.addCommand(motorCommand)) break;
        }
        if (this.getFirstStopAt() == -1) {
            this.addCommand(this.effectiveRange.newStopCmds());
        }
        this.resetCurrentSeqIndex();
        return this.commandSequence;
    }

    public void setSeparateControl(List<SeparateMotorCommand> separateControl) {
        this.separateControl = new CopyOnWriteArrayList<SeparateMotorCommand>(separateControl);
    }

    public void resetCurrentSeqIndex() {
        this.currentCommandIndex = -1;
    }

    public boolean addCommand(MotorCommand[] command) {
        MotorCommand lastCmdHead;
        MotorCommand cmdHead = SeqCommandHelper.getCmdHead(command);
        if (cmdHead.getType() == MotorCommandType.STOP || cmdHead.getType() == MotorCommandType.RESTART) {
            this.commandSequence.add(command);
            this.validateSequence();
            return false;
        }
        int lastIndex = this.commandSequence.size() - 1;
        if (lastIndex >= 0 && ((lastCmdHead = SeqCommandHelper.getCmdHead(this.commandSequence.get(lastIndex))).getType() == MotorCommandType.STOP || lastCmdHead.getType() == MotorCommandType.RESTART)) {
            this.commandSequence.add(lastIndex, command);
            return true;
        }
        this.commandSequence.add(command);
        this.validateSequence();
        return true;
    }

    protected void validateSequence() {
        int firstStopIndex = this.getFirstStopAt();
        if (firstStopIndex != this.commandSequence.size() - 1 && firstStopIndex >= 0) {
            this.commandSequence.subList(firstStopIndex + 1, this.commandSequence.size()).clear();
        }
    }

    protected int getFirstStopAt() {
        int firstStopIndex = -1;
        for (int i = 0; i < this.commandSequence.size(); ++i) {
            MotorCommand cmd = SeqCommandHelper.getCmdHead(this.commandSequence.get(i));
            if (cmd.getType() != MotorCommandType.STOP && cmd.getType() != MotorCommandType.RESTART) continue;
            firstStopIndex = i;
            break;
        }
        return firstStopIndex;
    }

    protected void checkCommandTick() {
        if (this.currentCommandIndex == -1) {
            return;
        }
        try {
            List<MotorCommand[]> sequence = this.getCommandSequence();
            MotorCommand[] currentCommand = sequence.get(this.currentCommandIndex);
            if (currentCommand == null) {
                this.resetCurrentSeqIndex();
                return;
            }
            MotorCommand cmdHead = SeqCommandHelper.getCmdHead(currentCommand);
            int maxTime = SeqCommandHelper.getMaxTime(currentCommand);
            switch (cmdHead.getType()) {
                case EXEC: {
                    this.exeCmd(currentCommand);
                    break;
                }
                case DELAY: {
                    if (this.executionTimer++ < maxTime) break;
                    this.nextCommand();
                    break;
                }
                case EXEC_UNTIL_PULSE: {
                    this.execUntilStop(this.getSpeedsFromParams(currentCommand, true));
                    break;
                }
                case EXEC_UNTIL_TIME: {
                    this.execUntilStop(this.getSpeedsFromParams(currentCommand, false));
                    if (this.executionTimer++ < SeqCommandHelper.getMaxTime(currentCommand)) break;
                    this.nextCommand();
                    break;
                }
                case STOP: {
                    this.stopBehavior();
                    break;
                }
                case RESTART: {
                    this.nextCommand();
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    protected void exeCmd(MotorCommand[] currentCommand) {
        float[] newCmdValue = new float[4];
        boolean shouldNext = true;
        for (int i = 0; i < this.commandValue.length; ++i) {
            if (currentCommand[i] == null) continue;
            float err = i == 3 ? this.commandValue[i] - this.currentValue[i] : ModMathUtil.wrapDegrees(this.commandValue[i] - this.currentValue[i]);
            float speed = Math.abs(currentCommand[i].getParam2()) / 20.0f;
            if (Math.abs(err) <= speed) {
                newCmdValue[i] = this.commandValue[i];
                continue;
            }
            newCmdValue[i] = this.currentValue[i] + Math.copySign(speed, err);
            shouldNext = false;
        }
        this.setCurrentValue(newCmdValue);
        if (shouldNext) {
            this.nextCommand();
        }
    }

    protected void execUntilStop(float[] speeds) {
        float[] newCmdValue = new float[4];
        for (int i = 0; i < this.currentValue.length; ++i) {
            if (speeds[i] == 0.0f) {
                newCmdValue[i] = this.currentValue[i];
                continue;
            }
            newCmdValue[i] = this.currentValue[i] + speeds[i] / 20.0f;
            if (i != 3) continue;
            newCmdValue[i] = Math.max(0.0f, Math.min(newCmdValue[i], this.getMaxSliderValue()));
        }
        this.setCurrentValue(newCmdValue);
    }

    public void setCurrentValue(float[] newValue) {
        if (this.attachment != null) {
            for (int i = 0; i < 3; ++i) {
                newValue[i] = Mth.m_14177_((float)newValue[i]);
            }
            this.currentValue = newValue;
            this.updateConstraint(this.attachment);
        }
        this.be.m_6596_();
    }

    protected float[] getSpeedsFromParams(MotorCommand[] cmds, boolean isFirstParam) {
        float[] speeds = new float[4];
        for (int i = 0; i < cmds.length; ++i) {
            if (cmds[i] == null) continue;
            speeds[i] = isFirstParam ? cmds[i].getParam1() : cmds[i].getParam2();
        }
        return speeds;
    }

    protected void nextCommand() {
        this.currentCommandIndex = (this.currentCommandIndex + 1) % this.commandSequence.size();
        MotorCommand[] motorCommand = this.commandSequence.get(this.currentCommandIndex);
        if (motorCommand == null) {
            this.resetCurrentSeqIndex();
            return;
        }
        this.resetExecutionTimer();
        MotorCommand cmdHead = SeqCommandHelper.getCmdHead(motorCommand);
        if (cmdHead != null && cmdHead.getType() == MotorCommandType.EXEC) {
            float[] newCmdValue = new float[4];
            for (int i = 0; i < this.commandValue.length; ++i) {
                if (motorCommand[i] == null) continue;
                newCmdValue[i] = i == 3 ? Math.max(0.0f, Math.min(motorCommand[i].getParam1(), this.getMaxSliderValue())) : ModMathUtil.wrapDegrees(motorCommand[i].getParam1() + this.currentValue[i]);
            }
            this.commandValue = newCmdValue;
        }
    }

    protected void resetExecutionTimer() {
        this.executionTimer = 0;
    }

    protected void stopBehavior() {
        this.resetCurrentSeqIndex();
    }

    public void activation(ServerLevel level) {
        if (this.attachment == null) {
            BlockEntity blockEntity1;
            Direction value;
            BlockState state = this.be.m_58900_();
            BlockPos pos = this.be.m_58899_();
            BlockPos relative = pos.m_121945_(value = (Direction)state.m_61143_((Property)AbstractServoMotor.FACING));
            BlockState newBlock = level.m_8055_(relative);
            if (newBlock.m_60795_() || newBlock.m_60734_() == Blocks.f_49990_) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(relative);
            CompoundTag compoundTag = null;
            if (blockEntity != null) {
                compoundTag = blockEntity.m_187480_();
            }
            level.m_46597_(relative, Blocks.f_50016_.m_49966_());
            ServerShip newShip = VsUtil.getShipObjectWorldCore(level).createNewShipAtBlock((Vector3ic)VsUtil.toJOMLPos(relative), false, 1.0, VsUtil.getDimensionId(level));
            Vector3dc positionInShip = newShip.getTransform().getPositionInShip();
            BlockPos newShipCenter = new BlockPos((int)Math.floor(positionInShip.x() - 0.5 + 0.5), (int)Math.floor(positionInShip.y() - 0.5 + 0.5), (int)Math.floor(positionInShip.z() - 0.5 + 0.5));
            level.m_46597_(newShipCenter, newBlock);
            if (compoundTag != null && (blockEntity1 = level.m_7702_(newShipCenter)) != null) {
                blockEntity1.m_142466_(compoundTag);
            }
            Vector3d otherPos = new Vector3d((double)newShipCenter.m_123341_(), (double)newShipCenter.m_123342_(), (double)newShipCenter.m_123343_()).add(0.5, 0.5, 0.5).add((double)value.m_122429_() * -0.5, (double)value.m_122430_() * -0.5, (double)value.m_122431_() * -0.5);
            this.buildNewConstraint(newShip, otherPos, value.m_122424_(), new float[4], 0.0f);
        }
    }

    protected long checkShipId(ServerLevel level, long shipId) {
        return shipId < 0L ? this.getSelfIdIfNotOnShip(level) : shipId;
    }

    protected long getSelfIdIfNotOnShip(ServerLevel level) {
        return (Long)VsUtil.getShipObjectWorldCore(level).getDimensionToGroundBodyIdImmutable().get(VsUtil.getDimensionId(level));
    }

    protected Quaterniond getRotationYFromState() {
        if (this.rotationYFromState == null) {
            this.rotationYFromState = new Quaterniond((Quaternionfc)this.be.rotationFromState);
        }
        return this.rotationYFromState;
    }

    protected Vector3dc getFaceVector() {
        if (this.faceVector == null) {
            Direction value = (Direction)this.be.m_58900_().m_61143_((Property)AbstractServoMotor.FACING);
            this.faceVector = new Vector3d((double)value.m_122429_(), (double)value.m_122430_(), (double)value.m_122431_());
        }
        return this.faceVector;
    }

    protected void buildNewConstraint(ServerShip otherShip, Vector3d otherPos, Direction otherDir, float[] targetValue, float otherAngle) {
        this.currentValue = targetValue;
        this.otherAngle = otherAngle;
        this.d3DDataValue = otherDir.m_122411_();
        Direction value = (Direction)this.be.m_58900_().m_61143_((Property)AbstractServoMotor.FACING);
        Direction connectValue = Direction.m_122376_((int)this.d3DDataValue).m_122424_();
        Quaterniond rotationBetweenDirectionsMath = DirectionRotationCalculator.getRotationBetweenDirections(value, connectValue);
        this.rotFromD3DDataValue = rotationBetweenDirectionsMath.conjugate().rotateY(Math.toRadians(otherAngle));
        Vector3d attachmentSelfPos0 = this.getAttachmentPos0(this.getRotationYFromState());
        ServerShip selfShip = this.getServerShip();
        long selfId = -1L;
        if (selfShip != null) {
            selfId = selfShip.getId();
        }
        long otherShipId = otherShip.getId();
        Vector3d attachmentOffset = this.getRotationYFromState().transform(new Vector3d(0.0, -0.5 - (double)this.currentValue[3], 0.0));
        if (selfShip != null) {
            newPos = selfShip.getTransform().getShipToWorld().transformPosition((Vector3dc)attachmentSelfPos0, new Vector3d());
            newPos.sub((Vector3dc)selfShip.getTransform().getShipToWorldRotation().transform((Vector3dc)attachmentOffset, new Vector3d()));
            ShipTransformImpl newShipTransForm = new ShipTransformImpl((Vector3dc)newPos, (Vector3dc)otherPos, selfShip.getTransform().getShipToWorldRotation(), otherShip.getTransform().getShipToWorldScaling());
            if (otherShip instanceof ShipObjectServer) {
                ShipObjectServer shipObjectServer = (ShipObjectServer)otherShip;
                shipObjectServer.asShipDataCommon().setTransform((ShipTransform)newShipTransForm);
            } else {
                ((ShipDataCommon)otherShip).setTransform((ShipTransform)newShipTransForm);
            }
        } else {
            newPos = new Vector3d((Vector3dc)attachmentSelfPos0);
            newPos.sub((Vector3dc)attachmentOffset);
            ShipTransformImpl newShipTransForm = new ShipTransformImpl((Vector3dc)newPos, (Vector3dc)otherPos, otherShip.getTransform().getShipToWorldRotation(), otherShip.getTransform().getShipToWorldScaling());
            if (otherShip instanceof ShipObjectServer) {
                ShipObjectServer shipObjectServer = (ShipObjectServer)otherShip;
                shipObjectServer.asShipDataCommon().setTransform((ShipTransform)newShipTransForm);
            } else {
                ((ShipDataCommon)otherShip).setTransform((ShipTransform)newShipTransForm);
            }
        }
        VsConstraintUtil.AttachmentConstraintRecord attachment0ConstraintRecord = new VsConstraintUtil.AttachmentConstraintRecord(selfId, otherShipId, (Vector3dc)attachmentSelfPos0, (Vector3dc)otherPos, 0.0);
        this.noShipFlicker = 0;
        this.updateConstraint(attachment0ConstraintRecord);
        if (selfShip != null) {
            selfShip.setStatic(true);
        }
        ServerEvent.addOnServerTickListener(10, () -> {
            if (selfShip != null) {
                selfShip.setStatic(false);
            }
        });
    }

    protected Vector3d getAttachmentPos0(Quaterniond rotationYFromState) {
        return new Vector3d(this.blockCenter.m_7096_(), this.blockCenter.m_7098_(), this.blockCenter.m_7094_()).add((Vector3dc)rotationYFromState.transform(new Vector3d(0.0, 0.5, 0.0)));
    }

    protected void updateConstraint(VsConstraintUtil.AttachmentConstraintRecord attachment0) {
        Level level = this.be.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedServerShip otherShip = VsUtil.getLoadedShipById(serverLevel, attachment0.shipId1());
        int shipMaxSize = 2;
        if (otherShip != null) {
            shipMaxSize = VsUtil.getShipMaxSize((Ship)otherShip);
        } else {
            ++this.noShipFlicker;
            if (this.noShipFlicker >= 60) {
                this.removeConstraintAndCollision(true);
                return;
            }
        }
        Quaterniond rot = new Quaterniond((Quaterniondc)this.getRotationYFromState()).rotateZ(Math.toRadians(this.currentValue[2])).rotateX(Math.toRadians(this.currentValue[0])).rotateY(Math.toRadians(this.currentValue[1])).rotateY((double)(-this.be.rotationYFromState));
        Vector3d attachmentSelfPos0 = new Vector3d(this.blockCenter.m_7096_(), this.blockCenter.m_7098_(), this.blockCenter.m_7094_()).add((Vector3dc)rot.transform(new Vector3d(0.0, 0.5 + (double)this.currentValue[3], 0.0)));
        attachment0 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos0, attachment0.localPos1(), 0.0);
        if (this.isPDMode) {
            this.addConstraint(serverLevel, attachment0);
            return;
        }
        Quaterniond targetRotationFromState = VsUtil.getRotationHingeFromState(Direction.m_122376_((int)this.d3DDataValue).m_122424_()).rotateY(Math.toRadians(this.otherAngle));
        Vector3d transform = rot.transform(new Vector3d(0.0, 0.0, (double)shipMaxSize));
        Vector3d attachmentSelfPos1 = new Vector3d(attachment0.localPos0()).add((Vector3dc)transform);
        Vector3d transform1 = targetRotationFromState.transform(new Vector3d(0.0, 0.0, (double)shipMaxSize));
        Vector3d attachmentOtherPos1 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform1);
        Vector3d t2 = rot.transform(new Vector3d(0.0, (double)shipMaxSize, 0.0));
        Vector3d attachmentSelfPos2 = new Vector3d(attachment0.localPos0()).add((Vector3dc)t2);
        Vector3d transform2 = targetRotationFromState.transform(new Vector3d(0.0, (double)shipMaxSize, 0.0));
        Vector3d attachmentOtherPos2 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform2);
        Vector3d t3 = rot.transform(new Vector3d((double)shipMaxSize, 0.0, 0.0));
        Vector3d attachmentSelfPos3 = new Vector3d(attachment0.localPos0()).add((Vector3dc)t3);
        Vector3d transform3 = targetRotationFromState.transform(new Vector3d((double)shipMaxSize, 0.0, 0.0));
        Vector3d attachmentOtherPos3 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform3);
        VsConstraintUtil.AttachmentConstraintRecord attachment1 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos1, (Vector3dc)attachmentOtherPos1, 0.0);
        VsConstraintUtil.AttachmentConstraintRecord attachment2 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos2, (Vector3dc)attachmentOtherPos2, 0.0);
        VsConstraintUtil.AttachmentConstraintRecord attachment3 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos3, (Vector3dc)attachmentOtherPos3, 0.0);
        this.addConstraint(serverLevel, attachment0, attachment1, attachment2, attachment3);
    }

    protected void addConstraint(ServerLevel level, VsConstraintUtil.AttachmentConstraintRecord attachment0) {
        double compliance = 1.0E-10;
        double maxForce = 1.0E10;
        VSAttachmentConstraint attachmentConstraint0 = this.createVSAttachmentConstraint(level, attachment0, compliance, maxForce);
        Integer newAttachment0 = VsUtil.createNewConstraint(level, (VSConstraint)attachmentConstraint0);
        if (newAttachment0 != null) {
            this.attachment = attachment0;
            if (this.attachment.shipId0() != -1L && this.attachment.shipId1() != -1L) {
                ServerShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(level);
                shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId0(), this.attachment.shipId0());
                HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, this.attachment.shipId1());
                allRelatedShips.forEach((shipId, constraints) -> shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId1(), shipId.longValue()));
            }
            this.removeConstraints(level);
            this.constraintIds.add(newAttachment0);
            this.be.m_6596_();
        }
    }

    protected void addConstraint(ServerLevel level, VsConstraintUtil.AttachmentConstraintRecord attachment0, VsConstraintUtil.AttachmentConstraintRecord attachment1, VsConstraintUtil.AttachmentConstraintRecord attachment2, VsConstraintUtil.AttachmentConstraintRecord attachment3) {
        this.removeConstraints(level);
        double compliance = 1.0E-30;
        double maxForce = 1.0E30;
        VSAttachmentConstraint attachmentConstraint1 = this.createVSAttachmentConstraint(level, attachment1, compliance, maxForce);
        Integer newAttachment1 = VsUtil.createNewConstraint(level, (VSConstraint)attachmentConstraint1);
        VSAttachmentConstraint attachmentConstraint2 = this.createVSAttachmentConstraint(level, attachment2, compliance, maxForce);
        Integer newAttachment2 = VsUtil.createNewConstraint(level, (VSConstraint)attachmentConstraint2);
        VSAttachmentConstraint attachmentConstraint3 = this.createVSAttachmentConstraint(level, attachment3, compliance, maxForce);
        Integer newAttachment3 = VsUtil.createNewConstraint(level, (VSConstraint)attachmentConstraint3);
        if (newAttachment1 != null && newAttachment2 != null && newAttachment3 != null) {
            this.attachment = attachment0;
            if (this.attachment.shipId0() != -1L && this.attachment.shipId1() != -1L) {
                ServerShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(level);
                shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId0(), this.attachment.shipId0());
                HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, this.attachment.shipId1());
                allRelatedShips.forEach((shipId, constraints) -> shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId1(), shipId.longValue()));
            }
            this.constraintIds.add(newAttachment1);
            this.constraintIds.add(newAttachment2);
            this.constraintIds.add(newAttachment3);
            this.be.m_6596_();
        }
    }

    protected VSAttachmentConstraint createVSAttachmentConstraint(ServerLevel level, VsConstraintUtil.AttachmentConstraintRecord attachment, double compliance, double maxForce) {
        return new VSAttachmentConstraint(this.checkShipId(level, attachment.shipId0()), this.checkShipId(level, attachment.shipId1()), compliance, attachment.localPos0(), attachment.localPos1(), maxForce, 0.0);
    }

    @Override
    public CmdEffectiveRange getEffectiveRange() {
        return this.effectiveRange;
    }

    @Override
    public float getMaxSliderValue() {
        return 15.0f;
    }
}

