/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base;

import java.util.HashMap;
import java.util.HashSet;
import kotlin.jvm.functions.Function1;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.CommandConstraintComponent;
import net.shao.valkyrien_space_war.block.joint.command.CmdEffectiveRange;
import net.shao.valkyrien_space_war.function.vs.VsConstraintUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSFixedOrientationConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSlideConstraint;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;

public class SliderConstraintComponent
extends CommandConstraintComponent {
    public static final int MAX_SLIDER_DIST = 15;
    private float move_p = 50.0f;
    private float move_d = 20.0f;
    private static final double MAX_FORCE = 1.0E8;
    private Vector3d attachSelfPos;
    private VSFixedOrientationConstraint fixedOrientationConstraint;
    private VSSlideConstraint vsSlideConstraint;

    public SliderConstraintComponent(AbstractServoMotorBE be, CmdEffectiveRange effectiveRange) {
        super(be, effectiveRange);
    }

    @Override
    public void onPhyTick(PhysShip ship1, VsUtil.PhysImplSnapshot ship1Snapshot, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        Vector3d currentRelativeVelocity;
        if (this.attachment == null) {
            return;
        }
        VsUtil.PhysImplSnapshot ship0Snapshot = null;
        PhysShip ship0 = (PhysShip)lookupPhysShip.invoke((Object)this.attachment.shipId0());
        if (ship0 != null) {
            ship0Snapshot = VsUtil.createPhysImplSnapshot(ship0);
        }
        Vector3d pos0 = new Vector3d((Vector3dc)(this.attachSelfPos == null ? this.attachment.localPos0() : this.attachSelfPos));
        if (ship0 != null) {
            pos0 = ship0.getTransform().getShipToWorld().transformPosition(pos0);
        }
        Vector3d constraintPos = ship1.getTransform().getShipToWorld().transformPosition(this.attachment.localPos1(), new Vector3d());
        Vector3d posErr = pos0.sub((Vector3dc)constraintPos, new Vector3d());
        Vector3d desiredVelocity = this.clampVector((Vector3dc)posErr, 15.0);
        if (ship0 != null) {
            Vector3d velocity0 = new Vector3d(ship0Snapshot.velocity());
            Vector3d velocity1 = new Vector3d(ship1Snapshot.velocity());
            currentRelativeVelocity = velocity1.sub((Vector3dc)velocity0);
        } else {
            currentRelativeVelocity = new Vector3d(ship1Snapshot.velocity());
        }
        currentRelativeVelocity = this.clampVector((Vector3dc)currentRelativeVelocity, 10.0);
        Vector3d force1 = new Vector3d(desiredVelocity.x() * (double)this.move_p + -currentRelativeVelocity.x() * (double)this.move_d, desiredVelocity.y() * (double)this.move_p + -currentRelativeVelocity.y() * (double)this.move_d, desiredVelocity.z() * (double)this.move_p + -currentRelativeVelocity.z() * (double)this.move_d);
        force1.mul(ship1Snapshot.shipMass());
        Direction ship1Dir = Direction.m_122376_((int)this.d3DDataValue);
        Vector3d forceOnShip1 = ship1.getTransform().getWorldToShip().transformDirection((Vector3dc)force1, new Vector3d());
        forceOnShip1 = this.getForceFromFace(forceOnShip1, ship1Dir);
        ship1.applyRotDependentForce((Vector3dc)forceOnShip1);
        if (ship0 != null) {
            Vector3d consOnShip0 = ship0.getTransform().getWorldToShip().transformPosition((Vector3dc)constraintPos, new Vector3d());
            Vector3d sub = new Vector3d((Vector3dc)consOnShip0).sub(ship0.getTransform().getPositionInShip());
            Vector3d forceOnShip0 = ship0.getTransform().getWorldToShip().transformDirection(new Vector3d((Vector3dc)force1).negate());
            forceOnShip0 = this.getForceFromFace(forceOnShip0, this.selfDir);
            ship0.applyRotDependentForceToPos((Vector3dc)forceOnShip0, (Vector3dc)sub);
        }
    }

    @Override
    protected void updateConstraint(VsConstraintUtil.AttachmentConstraintRecord attachment0) {
        Level level = this.be.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedServerShip otherShip = VsUtil.getLoadedShipById(serverLevel, attachment0.shipId1());
        int shipMaxSize = 2;
        if (otherShip != null) {
            shipMaxSize = VsUtil.getShipMaxSize((Ship)otherShip);
        } else {
            ++this.noShipFlicker;
            if (this.noShipFlicker >= 60) {
                this.removeConstraintAndCollision(true);
                return;
            }
        }
        Quaterniond rot = new Quaterniond((Quaterniondc)this.getRotationYFromState()).rotateZ(Math.toRadians(this.currentValue[2])).rotateX(Math.toRadians(this.currentValue[0])).rotateY(Math.toRadians(this.currentValue[1])).rotateY((double)(-this.be.rotationYFromState));
        Vector3d attachmentSelfPos0 = new Vector3d(this.blockCenter.m_7096_(), this.blockCenter.m_7098_(), this.blockCenter.m_7094_()).add((Vector3dc)rot.transform(new Vector3d(0.0, 0.5 + (double)this.currentValue[3], 0.0)));
        this.attachSelfPos = new Vector3d((Vector3dc)attachmentSelfPos0);
        if (this.isPDMode) {
            attachmentSelfPos0 = new Vector3d(this.blockCenter.m_7096_(), this.blockCenter.m_7098_(), this.blockCenter.m_7094_()).add((Vector3dc)rot.transform(new Vector3d(0.0, 0.5, 0.0)));
            attachment0 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos0, attachment0.localPos1(), 0.0);
            this.addConstraint(serverLevel, attachment0);
            return;
        }
        attachment0 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos0, attachment0.localPos1(), 0.0);
        Quaterniond targetRotationFromState = VsUtil.getRotationHingeFromState(Direction.m_122376_((int)this.d3DDataValue).m_122424_()).rotateY(Math.toRadians(this.otherAngle));
        Vector3d transform = rot.transform(new Vector3d(0.0, 0.0, (double)shipMaxSize));
        Vector3d attachmentSelfPos1 = new Vector3d(attachment0.localPos0()).add((Vector3dc)transform);
        Vector3d transform1 = targetRotationFromState.transform(new Vector3d(0.0, 0.0, (double)shipMaxSize));
        Vector3d attachmentOtherPos1 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform1);
        Vector3d t2 = rot.transform(new Vector3d(0.0, (double)shipMaxSize, 0.0));
        Vector3d attachmentSelfPos2 = new Vector3d(attachment0.localPos0()).add((Vector3dc)t2);
        Vector3d transform2 = targetRotationFromState.transform(new Vector3d(0.0, (double)shipMaxSize, 0.0));
        Vector3d attachmentOtherPos2 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform2);
        Vector3d t3 = rot.transform(new Vector3d((double)shipMaxSize, 0.0, 0.0));
        Vector3d attachmentSelfPos3 = new Vector3d(attachment0.localPos0()).add((Vector3dc)t3);
        Vector3d transform3 = targetRotationFromState.transform(new Vector3d((double)shipMaxSize, 0.0, 0.0));
        Vector3d attachmentOtherPos3 = new Vector3d(attachment0.localPos1()).add((Vector3dc)transform3);
        VsConstraintUtil.AttachmentConstraintRecord attachment1 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos1, (Vector3dc)attachmentOtherPos1, 0.0);
        VsConstraintUtil.AttachmentConstraintRecord attachment2 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos2, (Vector3dc)attachmentOtherPos2, 0.0);
        VsConstraintUtil.AttachmentConstraintRecord attachment3 = new VsConstraintUtil.AttachmentConstraintRecord(attachment0.shipId0(), attachment0.shipId1(), (Vector3dc)attachmentSelfPos3, (Vector3dc)attachmentOtherPos3, 0.0);
        this.addConstraint(serverLevel, attachment0, attachment1, attachment2, attachment3);
    }

    @NotNull
    private Vector3d getForceFromFace(Vector3d force, Direction dir) {
        force = switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vector3d(Mth.m_14008_((double)force.x(), (double)-1.0E8, (double)1.0E8), 0.0, 0.0);
            case Direction.Axis.Y -> new Vector3d(0.0, Mth.m_14008_((double)force.y(), (double)-1.0E8, (double)1.0E8), 0.0);
            case Direction.Axis.Z -> new Vector3d(0.0, 0.0, Mth.m_14008_((double)force.z(), (double)-1.0E8, (double)1.0E8));
        };
        return force;
    }

    private Vector3d clampVector(Vector3dc vec, double max) {
        return new Vector3d(Math.max(-max, Math.min(vec.x(), max)), Math.max(-max, Math.min(vec.y(), max)), Math.max(-max, Math.min(vec.z(), max)));
    }

    private Vector3d pdControl(Vector3d velocity, Vector3d targetVelocity, float p, float d) {
        return new Vector3d((targetVelocity.x() - velocity.x()) * (double)p + -velocity.x() * (double)d, (targetVelocity.y() - velocity.y()) * (double)p + -velocity.y() * (double)d, (targetVelocity.z() - velocity.z()) * (double)p + -velocity.z() * (double)d);
    }

    @Override
    protected void addConstraint(ServerLevel level, VsConstraintUtil.AttachmentConstraintRecord attachment0) {
        this.attachment = attachment0;
        if (this.fixedOrientationConstraint != null || this.vsSlideConstraint == null) {
            this.removeConstraints(level);
            Quaterniond hingeRot = this.getRotationYFromState().mul((Quaterniondc)new Quaterniond().rotateZ(1.5707963267948966), new Quaterniond()).normalize();
            this.fixedOrientationConstraint = new VSFixedOrientationConstraint(this.checkShipId(level, attachment0.shipId0()), this.checkShipId(level, attachment0.shipId1()), 1.0E-20, (Quaterniondc)hingeRot, (Quaterniondc)hingeRot, 1.0E20);
            Integer newFixedOrientation = VsUtil.createNewConstraint(level, (VSConstraint)this.fixedOrientationConstraint);
            this.vsSlideConstraint = new VSSlideConstraint(this.checkShipId(level, attachment0.shipId0()), this.checkShipId(level, attachment0.shipId1()), 1.0E-10, attachment0.localPos0(), attachment0.localPos1(), 1.0E10, this.getFaceVector(), 15.0);
            Integer newSlideConstraint = VsUtil.createNewConstraint(level, (VSConstraint)this.vsSlideConstraint);
            if (newFixedOrientation != null && newSlideConstraint != null) {
                this.attachment = attachment0;
                if (this.attachment.shipId0() != -1L && this.attachment.shipId1() != -1L) {
                    ServerShipWorldCore shipObjectWorldCore = VsUtil.getShipObjectWorldCore(level);
                    shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId0(), this.attachment.shipId0());
                    HashMap<Long, HashSet<VSConstraint>> allRelatedShips = VsUtil.getAllRelatedShips((Level)level, this.attachment.shipId1());
                    allRelatedShips.forEach((shipId, constraints) -> shipObjectWorldCore.disableCollisionBetweenBodies(this.attachment.shipId1(), shipId.longValue()));
                }
                this.constraintIds.add(newFixedOrientation);
                this.constraintIds.add(newSlideConstraint);
                this.be.m_6596_();
            }
        }
    }

    @Override
    public void removeConstraints(ServerLevel serverLevel) {
        super.removeConstraints(serverLevel);
        this.vsSlideConstraint = null;
        this.fixedOrientationConstraint = null;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.m_128441_("move_p")) {
            this.move_p = tag.m_128457_("move_p");
        }
        if (tag.m_128441_("move_d")) {
            this.move_d = tag.m_128457_("move_d");
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.m_128350_("move_p", this.move_p);
        tag.m_128350_("move_d", this.move_d);
    }
}

