/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base.client;

import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.SeqCommandHelper;
import net.shao.valkyrien_space_war.block.joint.base.client.MotorButton;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorMenu;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorScreen;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import org.lwjgl.glfw.GLFW;

public class CommandScrollPanel
extends AbstractWidget {
    private final ScrollPanel scrollPanel;
    private final ServoMotorScreen parentScreen;
    private final CopyOnWriteArrayList<CommandRow> children = new CopyOnWriteArrayList();
    private static int itemHeight;
    private static final int ITEM_HEIGHT = 20;
    private static final int PADDING = 5;
    private int tTop;
    private Minecraft mc;
    private int x;
    private int y;
    private int width;
    private int height;

    public CommandScrollPanel(Minecraft mc, int width, int height, int top, int left, ServoMotorScreen parentScreen) {
        super(left, top, width, height, (Component)Component.m_237119_());
        this.mc = mc;
        this.parentScreen = parentScreen;
        this.x = left;
        this.y = top;
        this.width = width;
        this.height = height;
        this.scrollPanel = new ScrollPanel(mc, width, height, top, left){

            public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (super.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
                int rightBorder = this.left + this.width;
                if (mouseX > (double)(this.left + 39) && mouseX < (double)(rightBorder - 32)) {
                    double panelY = (float)this.top - this.scrollDistance;
                    for (CommandRow row : CommandScrollPanel.this.children) {
                        if (!row.isMouseOver(this.left, (int)panelY, mouseX, mouseY)) continue;
                        return row.mouseClicked(mouseX, mouseY, button);
                    }
                }
                return false;
            }

            public boolean m_6050_(double mouseX, double mouseY, double scroll) {
                int rightBorder = this.left + this.width;
                if (mouseX > (double)(this.left + 39) && mouseX < (double)(rightBorder - 32)) {
                    double panelY = (float)this.top - this.scrollDistance;
                    for (CommandRow row : CommandScrollPanel.this.children) {
                        if (!row.isMouseOver(this.left, (int)panelY, mouseX, mouseY)) continue;
                        return row.mouseScrolled(mouseX, mouseY, scroll);
                    }
                }
                return super.m_6050_(mouseX, mouseY, scroll);
            }

            public NarratableEntry.NarrationPriority m_142684_() {
                return NarratableEntry.NarrationPriority.NONE;
            }

            protected int getContentHeight() {
                return CommandScrollPanel.this.getContentHeight();
            }

            protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
                CommandScrollPanel.this.drawPanel(guiGraphics, entryRight, relativeY, tess, mouseX, mouseY);
            }
        };
        AbstractServoMotorBE blockEntity = ((ServoMotorMenu)parentScreen.m_6262_()).getBlockEntity();
        int effectiveLength = blockEntity.getCommandConstraintComponent().getEffectiveRange().getEffectiveLength();
        itemHeight = 20 * effectiveLength;
        this.tTop = top - itemHeight;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.scrollPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        if (this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
            this.m_7435_(this.mc.m_91106_());
            this.m_5716_(mouseX, mouseY);
            return true;
        }
        return this.scrollPanel.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollPanel.m_6050_(mouseX, mouseY, delta);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_168797_(NarrationElementOutput output) {
    }

    public void setCommands(List<MotorCommand[]> commands) {
        this.children.clear();
        int yPos = 0;
        for (int i = 0; i < commands.size(); ++i) {
            CommandRow row = new CommandRow(this.parentScreen, commands.get(i), i, yPos);
            this.children.add(row);
            yPos += itemHeight + 5;
        }
    }

    protected int getContentHeight() {
        return this.children.size() * (itemHeight + 5) + 5;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        guiGraphics.m_280588_(this.x, this.y, this.x + this.width, this.y + this.height);
        for (CommandRow row : this.children) {
            int yPos = relativeY + row.y;
            if (yPos <= this.tTop || yPos >= this.y + this.height) continue;
            row.render(guiGraphics, this.x, yPos, mouseX, mouseY);
        }
        guiGraphics.m_280618_();
    }

    public List<MotorCommand[]> getCommands() {
        ArrayList<MotorCommand[]> commands = new ArrayList<MotorCommand[]>();
        for (CommandRow row : this.children) {
            commands.add(row.getCommands());
        }
        return commands;
    }

    public int getLeft() {
        return this.x;
    }

    public int getTop() {
        return this.y;
    }

    public void sendCommand() {
        List commandSequence = ((ServoMotorMenu)this.parentScreen.m_6262_()).getBlockEntity().setAndFilterCommandSequence(this.getCommands());
        this.setCommands(commandSequence);
        ((ServoMotorMenu)this.parentScreen.m_6262_()).getBlockEntity().resetCurrentSeqIndex();
        this.parentScreen.saveSeqCommands(commandSequence);
    }

    public class CommandRow {
        private final ServoMotorScreen screen;
        private final MotorCommand[] command;
        private final int commandIndex;
        public int y;
        private final MotorButton[] typeButton = new MotorButton[4];
        private MotorButton[] paramButton1 = new MotorButton[4];
        private MotorButton[] paramButton2 = new MotorButton[4];
        private static final Tooltip SCROLL_TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.scroll_the_mouse_wheel").m_130938_(style -> style.m_131140_(ChatFormatting.WHITE)).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.hold_shift_and_scroll_to_faster")).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.hold_ctrl_and_scroll_to_slower")));

        public CommandRow(ServoMotorScreen screen, MotorCommand[] command, int commandIndex, int y) {
            this.screen = screen;
            this.command = command;
            this.commandIndex = commandIndex;
            this.y = y;
            CommandScrollPanel commandScrollPanel = screen.getCommandScrollPanel();
            int count = 0;
            for (int i = 0; i < command.length; ++i) {
                boolean isSlider;
                if (command[i] == null) continue;
                MotorCommand motorCommand = command[i];
                boolean bl = isSlider = i == 3;
                String name = motorCommand.getType() == MotorCommandType.EXEC ? (isSlider ? "slide" : "rotate") : motorCommand.getType().name().toLowerCase();
                int height = this.y + 2 + count * 25;
                this.typeButton[i] = new MotorButton(commandScrollPanel.getLeft() + 42, height, 60, 16, (Component)Component.m_237115_((String)("key.valkyrien_space_war.motor_command." + name)), button -> {});
                this.typeButton[i].updateTypeTooltip(motorCommand.getType());
                int buttonX = commandScrollPanel.getLeft() + 106;
                switch (motorCommand.getType()) {
                    case EXEC: {
                        this.paramButton1[i] = this.createParam1Button(isSlider, buttonX, height, motorCommand.getParam1());
                        this.paramButton2[i] = this.createParam2Button(isSlider, buttonX + 50, height, motorCommand.getParam2(), false);
                        break;
                    }
                    case DELAY: {
                        this.paramButton1[i] = this.createTimeButton(buttonX, height, motorCommand.getParam1());
                        break;
                    }
                    case EXEC_UNTIL_PULSE: {
                        this.paramButton1[i] = this.createParam2Button(isSlider, buttonX, this.y + 2, motorCommand.getParam1(), true);
                        break;
                    }
                    case EXEC_UNTIL_TIME: {
                        this.paramButton1[i] = this.createTimeButton(buttonX, height, motorCommand.getParam1());
                        this.paramButton2[i] = this.createAngleSpeedButton(buttonX + 50, height, motorCommand.getParam2(), true);
                    }
                }
                ++count;
            }
        }

        public void render(GuiGraphics guiGraphics, int panelX, int panelY, int mouseX, int mouseY) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.command[i] == null) continue;
                int height = panelY + 2 + count * 20;
                guiGraphics.m_280488_(this.screen.getMinecraft().f_91062_, SeqCommandHelper.getTypeString(i), panelX + 6, height + 2, -13421773);
                guiGraphics.m_280509_(panelX, height - 2, panelX + 240, height + 20, SeqCommandHelper.getColorFromType(i));
                this.typeButton[i].m_253211_(height);
                this.typeButton[i].m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                if (this.paramButton1[i] != null) {
                    this.paramButton1[i].m_253211_(height);
                    this.paramButton1[i].m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                }
                if (this.paramButton2[i] != null) {
                    this.paramButton2[i].m_253211_(height);
                    this.paramButton2[i].m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                }
                ++count;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (int i = 0; i < 4; ++i) {
                if (this.command[i] == null) continue;
                if (this.typeButton[i].m_5953_(mouseX, mouseY)) {
                    return this.typeButton[i].m_6375_(mouseX, mouseY, button);
                }
                if (this.paramButton1[i] != null && this.paramButton1[i].m_5953_(mouseX, mouseY)) {
                    return this.paramButton1[i].m_6375_(mouseX, mouseY, button);
                }
                if (this.paramButton2[i] == null || !this.paramButton2[i].m_5953_(mouseX, mouseY)) continue;
                return this.paramButton2[i].m_6375_(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return false;
            }
            boolean shiftKeyDown = GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) == 1;
            boolean ctrlKeyDown = GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) == 1;
            for (int i = 0; i < 4; ++i) {
                if (this.command[i] == null) continue;
                if (this.typeButton[i].m_5953_(mouseX, mouseY)) {
                    MotorCommandType type = (MotorCommandType)((Object)this.typeButton[i].mouseScrolled(this.screen, mouseX, mouseY, delta, this.commandIndex, this.command, shiftKeyDown, ctrlKeyDown));
                    this.setCommandTypes(type);
                    CommandScrollPanel.this.sendCommand();
                }
                if (this.paramButton1[i] != null && this.paramButton1[i].m_5953_(mouseX, mouseY)) {
                    this.paramButton1[i].mouseScrolled(this.screen, mouseX, mouseY, delta, this.commandIndex, this.command, shiftKeyDown, ctrlKeyDown);
                    CommandScrollPanel.this.sendCommand();
                }
                if (this.paramButton2[i] == null || !this.paramButton2[i].m_5953_(mouseX, mouseY)) continue;
                this.paramButton2[i].mouseScrolled(this.screen, mouseX, mouseY, delta, this.commandIndex, this.command, shiftKeyDown, ctrlKeyDown);
                CommandScrollPanel.this.sendCommand();
            }
            return false;
        }

        private MotorButton createParam1Button(boolean isSlider, int x, int y, float value) {
            return isSlider ? this.createSliderButton(x, y, value) : this.createAngleButton(x, y, value);
        }

        private MotorButton createParam2Button(boolean isSlider, int x, int y, float value, boolean allowNegative) {
            return isSlider ? this.createSliderSpeedButton(x, y, value) : this.createAngleSpeedButton(x, y, value, allowNegative);
        }

        private MotorButton createAngleButton(int x, int y, float value) {
            value = ModMathUtil.roundToTenth(value);
            MotorButton button = new MotorButton(x, y, 46, 16, (Component)Component.m_237113_((String)(value + "\u00b0")), btn -> {});
            button.setValueMode(-360.0f, 360.0f, value);
            button.m_257544_(SCROLL_TOOLTIP);
            return button;
        }

        private MotorButton createAngleSpeedButton(int x, int y, float value, boolean allowNegative) {
            value = ModMathUtil.roundToTenth(value);
            MotorButton button = new MotorButton(x, y, 46, 16, (Component)Component.m_237113_((String)(value + "\u00b0/S")), btn -> {});
            if (allowNegative) {
                button.setValueMode(-360.0f, 360.0f, value);
            } else {
                button.setValueMode(0.0f, 360.0f, value);
            }
            button.m_257544_(SCROLL_TOOLTIP);
            return button;
        }

        private MotorButton createSliderButton(int x, int y, float value) {
            value = ModMathUtil.roundToTenth(value);
            MotorButton button = new MotorButton(x, y, 46, 16, (Component)Component.m_237113_((String)(value + " M")), btn -> {});
            button.setValueMode(0.0f, ((ServoMotorMenu)this.screen.m_6262_()).getBlockEntity().getCommandConstraintComponent().getMaxSliderValue(), value);
            button.m_257544_(SCROLL_TOOLTIP);
            return button;
        }

        private MotorButton createSliderSpeedButton(int x, int y, float value) {
            value = ModMathUtil.roundToTenth(value);
            MotorButton button = new MotorButton(x, y, 46, 16, (Component)Component.m_237113_((String)(value + "M/S")), btn -> {});
            button.setValueMode(0.0f, 360.0f, value);
            button.m_257544_(SCROLL_TOOLTIP);
            return button;
        }

        private MotorButton createTimeButton(int x, int y, float value) {
            value = ModMathUtil.roundToTenth(value);
            MotorButton button = new MotorButton(x, y, 46, 16, (Component)Component.m_237113_((String)(value + " ticks")), btn -> {});
            button.setValueMode(1.0f, 200.0f, value);
            return button;
        }

        private void setCommandTypes(MotorCommandType type) {
            MotorCommand[] cmds = this.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                if (cmds[i] == null) continue;
                cmds[i].setType(type, i == 3);
            }
        }

        public MotorCommand[] getCommands() {
            for (int i = 0; i < 4; ++i) {
                if (this.paramButton1[i] != null) {
                    this.command[i].setParam1(this.paramButton1[i].getCurrentValue());
                }
                if (this.paramButton2[i] == null) continue;
                this.command[i].setParam2(this.paramButton2[i].getCurrentValue());
            }
            return this.command;
        }

        public boolean isMouseOver(int panelX, int panelY, double mouseX, double mouseY) {
            int entryTop = panelY + this.y;
            int entryBottom = entryTop + itemHeight;
            return mouseY >= (double)entryTop && mouseY <= (double)entryBottom;
        }
    }
}

