/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base.client;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.shao.valkyrien_space_war.block.joint.base.SeqCommandHelper;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorScreen;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;
import net.shao.valkyrien_space_war.screen.ui.ClearButton;

public class MotorButton
extends ClearButton {
    private float minValue = 0.0f;
    private float maxValue = 100.0f;
    private float currentValue = 0.0f;
    private boolean isValueMode = false;
    private MotorCommandType[] types = MotorCommandType.values();
    private static final String[] TYPE_TOOLTIPS = new String[]{"tip.valkyrien_space_war.motor_command.stop", "tip.valkyrien_space_war.motor_command.exec", "tip.valkyrien_space_war.motor_command.wait_for_pulse", "tip.valkyrien_space_war.motor_command.delay", "tip.valkyrien_space_war.motor_command.exec_until_pulse", "tip.valkyrien_space_war.motor_command.exec_for_time", "tip.valkyrien_space_war.motor_command.restart"};

    public MotorButton(int x, int y, int width, int height, Component message, ClearButton.OnPress onPress) {
        super(x, y, width, height, message, onPress);
    }

    public void setValueMode(float min, float max, float current) {
        this.isValueMode = true;
        this.minValue = min;
        this.maxValue = max;
        this.currentValue = current;
    }

    public void setTypes(MotorCommandType[] types) {
        this.types = types;
    }

    private int getTypeIndex(MotorCommandType type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != type) continue;
            return i;
        }
        return -1;
    }

    public Object mouseScrolled(ServoMotorScreen screen, double mouseX, double mouseY, double delta, int commandIndex, MotorCommand[] currentCommand, boolean isShiftKeyDown, boolean isCtrlKeyDown) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.isValueMode) {
                float signum = (float)Math.signum(delta);
                if (isShiftKeyDown) {
                    signum *= 10.0f;
                } else if (isCtrlKeyDown) {
                    signum = (float)((double)signum * 0.1);
                }
                float newValue = this.currentValue + signum;
                this.currentValue = newValue = Math.max(this.minValue, Math.min(this.maxValue, newValue));
                return Float.valueOf(this.currentValue);
            }
            MotorCommand cmdHead = SeqCommandHelper.getCmdHead(currentCommand);
            int newValue = (int)Math.signum(delta);
            int i = Math.floorMod(this.getTypeIndex(cmdHead.getType()) - newValue, this.types.length);
            if (commandIndex == 0 && this.types[i] == MotorCommandType.RESTART) {
                i = Math.floorMod(cmdHead.getType().ordinal() - (newValue *= 2), this.types.length);
            }
            return this.types[i];
        }
        return null;
    }

    public void updateTypeTooltip(MotorCommandType type) {
        int ordinal = type.ordinal();
        MutableComponent tooltip = Component.m_237119_();
        for (int i = 0; i < TYPE_TOOLTIPS.length; ++i) {
            boolean isLast = i == TYPE_TOOLTIPS.length - 1;
            MutableComponent mutableComponent = i == ordinal ? Component.m_237115_((String)TYPE_TOOLTIPS[i]).m_130938_(style -> style.m_131140_(ChatFormatting.WHITE).m_131162_(Boolean.valueOf(true))) : Component.m_237115_((String)TYPE_TOOLTIPS[i]).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY));
            if (!isLast) {
                mutableComponent.m_130946_("\n");
            }
            tooltip.m_7220_((Component)mutableComponent);
        }
        this.m_257544_(Tooltip.m_257550_((Component)tooltip));
    }

    private void updateMessage() {
        if (this.isValueMode) {
            if (this.m_6035_().getString().contains("/s")) {
                this.m_93666_((Component)Component.m_237113_((String)(this.currentValue + "\u00b0/s")));
            } else if (this.m_6035_().getString().contains("\u00b0")) {
                this.m_93666_((Component)Component.m_237113_((String)(this.currentValue + "\u00b0")));
            } else {
                this.m_93666_((Component)Component.m_237113_((String)(this.currentValue + " ticks")));
            }
        }
    }

    public float getCurrentValue() {
        return this.currentValue;
    }
}

