/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.shao.valkyrien_space_war.block.joint.base.AbstractServoMotorBE;
import net.shao.valkyrien_space_war.block.joint.base.client.CommandScrollPanel;
import net.shao.valkyrien_space_war.block.joint.base.client.SeparateControlScrollPanel;
import net.shao.valkyrien_space_war.block.joint.base.client.SeparateTab;
import net.shao.valkyrien_space_war.block.joint.base.client.SequenceTab;
import net.shao.valkyrien_space_war.block.joint.base.client.ServoMotorMenu;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.SeparateMotorCommand;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.joint.ActivationMotorPacket;
import net.shao.valkyrien_space_war.network.joint.RemoveConstraintPacket;
import net.shao.valkyrien_space_war.network.joint.SwitchPdModePacket;
import net.shao.valkyrien_space_war.network.joint.UpdateSeparatePacket;
import net.shao.valkyrien_space_war.network.joint.UpdateSeqCommandsPacket;
import net.shao.valkyrien_space_war.screen.ModKeyTypeContainerScreen;
import net.shao.valkyrien_space_war.screen.ui.ClearButton;
import net.shao.valkyrien_space_war.screen.ui.TabManager;

public class ServoMotorScreen
extends ModKeyTypeContainerScreen<ServoMotorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/servo_motor_gui.png");
    private TabManager tabManager;
    private AbstractServoMotorBE be;
    private SequenceTab sequenceTab;
    private SeparateTab separateTab;

    public ServoMotorScreen(ServoMotorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.be = menu.getBlockEntity();
        this.f_97726_ = 248;
        this.f_97727_ = 148;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tabManager = new TabManager(this.f_97735_ + 5, this.f_97736_ - 15);
        this.sequenceTab = new SequenceTab(this, this.be);
        this.separateTab = new SeparateTab(this, this.be);
        this.tabManager.addTab(this.sequenceTab);
        this.tabManager.addTab(this.separateTab);
        this.updateCurrentTab();
    }

    private void setPdButtonColor(ClearButton btn, boolean isPdMode) {
        if (isPdMode) {
            btn.setColor(0.5f, 1.0f, 0.5f);
        } else {
            btn.setColor(0.25f, 0.25f, 0.25f);
        }
    }

    private void updateCurrentTab() {
        this.m_169413_();
        TabManager.Tab currentTab = this.tabManager.getCurrentTab();
        currentTab.clearWidgets();
        currentTab.init(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        for (AbstractWidget widget : currentTab.getWidgets()) {
            this.m_142416_((GuiEventListener)widget);
        }
        ClearButton newConstraintButton = new ClearButton(this.f_97735_ + 51, this.f_97736_ + 150, 70, 16, (Component)Component.m_237115_((String)"gui.valkyrien_space_war.new_constraint"), button -> ModNetworkHandler.sendToServer(new ActivationMotorPacket(this.be.m_58899_())));
        newConstraintButton.setOnRender(b -> {
            if (!this.be.hasConstraints()) {
                b.setColor(0.75f, 1.0f, 0.75f);
            } else {
                b.setColor(0.5f, 0.5f, 0.5f);
            }
        });
        newConstraintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.new_constraint_tooltip")));
        ClearButton deleteConstraintButton = new ClearButton(this.f_97735_ + 128, this.f_97736_ + 150, 70, 16, (Component)Component.m_237115_((String)"gui.valkyrien_space_war.delete_constraint"), button -> ModNetworkHandler.sendToServer(new RemoveConstraintPacket(this.be.m_58899_())));
        deleteConstraintButton.setOnRender(b -> {
            if (this.be.hasConstraints()) {
                b.setColor(1.0f, 0.75f, 0.75f);
            } else {
                b.setColor(0.5f, 0.5f, 0.5f);
            }
        });
        deleteConstraintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.delete_constraint_tooltip")));
        ClearButton switchPDModeButton = new ClearButton(this.f_97735_ + 197, this.f_97736_ - 15, 50, 16, (Component)Component.m_237113_((String)"PD MODE"), button -> {
            boolean b = !this.be.getCommandConstraintComponent().isPDMode();
            this.be.getCommandConstraintComponent().setPdModeClient(b);
            this.setPdButtonColor(button, b);
            ModNetworkHandler.sendToServer(new SwitchPdModePacket(this.be.m_58899_(), b));
        });
        this.setPdButtonColor(switchPDModeButton, this.be.getCommandConstraintComponent().isPDMode());
        this.m_142416_((GuiEventListener)newConstraintButton);
        this.m_142416_((GuiEventListener)deleteConstraintButton);
        this.m_142416_((GuiEventListener)switchPDModeButton);
    }

    public void updateCommandRows() {
        TabManager.Tab currentTab = this.tabManager.getCurrentTab();
        if (currentTab instanceof SequenceTab) {
            ((SequenceTab)currentTab).updateCommandRows();
        } else if (currentTab instanceof SeparateTab) {
            ((SeparateTab)currentTab).updateCommandRows();
        }
    }

    public void saveSeqCommands(List<MotorCommand[]> commandSequence) {
        this.be.m_6596_();
        ModNetworkHandler.sendToServer(new UpdateSeqCommandsPacket(((ServoMotorMenu)this.f_97732_).getBlockEntity().m_58899_(), commandSequence));
    }

    public void saveSeparates(List<SeparateMotorCommand> separateCommands) {
        this.be.m_6596_();
        ModNetworkHandler.sendToServer(new UpdateSeparatePacket(((ServoMotorMenu)this.f_97732_).getBlockEntity().m_58899_(), separateCommands));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.tabManager.renderTabs(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        this.tabManager.getCurrentTab().renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.tabManager.mouseClicked(mouseX, mouseY, button)) {
            this.updateCurrentTab();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public CommandScrollPanel getCommandScrollPanel() {
        return this.sequenceTab.getScrollPanel();
    }

    public SeparateControlScrollPanel getSeparateControlScrollPanel() {
        return this.separateTab.getScrollPanel();
    }
}

