/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.joint.command;

import net.minecraft.nbt.CompoundTag;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommand;
import net.shao.valkyrien_space_war.block.joint.command.MotorCommandType;

public enum CmdEffectiveRange {
    Y_ROT(false, true, false, false),
    X_Y_ROT(true, true, false, false),
    X_Y_Z_ROT(true, true, true, false),
    SLIDE(false, false, false, true),
    FULL(true, true, true, true),
    X_ROT(true, false, false, false),
    X_Z_ROT(true, false, true, false),
    Z_ROT(false, false, true, false),
    Y_Z_ROT(false, true, true, false);

    final boolean[] range = new boolean[4];
    final int effectiveLength;

    private CmdEffectiveRange(boolean x_rot, boolean y_rot, boolean z_rot, boolean slide) {
        this.range[0] = x_rot;
        this.range[1] = y_rot;
        this.range[2] = z_rot;
        this.range[3] = slide;
        int count = 0;
        for (boolean b : this.range) {
            if (!b) continue;
            ++count;
        }
        this.effectiveLength = count;
    }

    public int getEffectiveLength() {
        return this.effectiveLength;
    }

    public float[] getValues(float[] values) {
        float[] result = new float[4];
        for (int i = 0; i < result.length; ++i) {
            if (!this.range[i]) continue;
            result[i] = values[i];
        }
        return result;
    }

    public void putTag(CompoundTag tag, float[] values) {
        if (values.length != this.range.length) {
            return;
        }
        for (int i = 0; i < this.range.length; ++i) {
            if (!this.range[i]) continue;
            tag.m_128350_("tgVal" + i, values[i]);
        }
    }

    public float[] loadTag(CompoundTag tag) {
        float[] values = new float[this.range.length];
        for (int i = 0; i < this.range.length; ++i) {
            if (!this.range[i]) continue;
            values[i] = tag.m_128457_("tgVal" + i);
        }
        return values;
    }

    public MotorCommand[] newStopCmds() {
        MotorCommand[] cmds = new MotorCommand[4];
        for (int i = 0; i < this.range.length; ++i) {
            if (!this.range[i]) continue;
            cmds[i] = new MotorCommand(MotorCommandType.STOP);
        }
        return cmds;
    }

    public MotorCommand[] newEmptyExecCmds() {
        MotorCommand[] cmds = new MotorCommand[4];
        for (int i = 0; i < this.range.length; ++i) {
            if (!this.range[i]) continue;
            cmds[i] = new MotorCommand(MotorCommandType.EXEC, 0.0f, 0.0f);
        }
        return cmds;
    }
}

