/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.base;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.shao.valkyrien_space_war.block.monitors.base.BaseMonitorBE;
import net.shao.valkyrien_space_war.function.util.VsswMonitorUtil;
import net.shao.valkyrien_space_war.item.tool.VsswTools;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.monitor.VsswMonitorClickPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public abstract class BaseMonitor
extends BaseEntityBlock {
    public static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BaseMonitor(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof VsswTools) {
            return InteractionResult.PASS;
        }
        if (pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof BaseMonitorBE) {
            BaseMonitorBE be = (BaseMonitorBE)blockEntity;
            Vector2f clickPos = VsswMonitorUtil.getClickPos(be.getMonitorComponent(), pPos, pHit.m_82450_());
            float x = clickPos.x();
            float y = clickPos.y();
            if (x > 0.0f && x < 1.0f && y > 0.0f && y < 1.0f) {
                ModNetworkHandler.sendToServer(new VsswMonitorClickPacket(pPos, x, y, false));
                Minecraft.m_91087_().f_91066_.f_92095_.m_7249_(false);
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return null;
    }
}

