/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;
import net.shao.valkyrien_space_war.block.monitors.pages.AbstractPage;
import net.shao.valkyrien_space_war.block.monitors.pages.EmptyPage;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorScrollPanel;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorWidget;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.monitor.SyncScrollOffsetMessage;

public class VsswMonitorComponent {
    public final float WIDTH_SIZE;
    public final float HEIGHT_SIZE;
    public final float WIDTH_BORDER;
    public final float HEIGHT_BORDER;
    public final float DEF_WIDTH_OFFSET;
    public final float DEF_HEIGHT_OFFSET;
    public final float SURFACE_DISTANCE;
    private final float WIDTH;
    private final float HEIGHT;
    private OnClickOuter onClickOuter;
    private OnNbtChanged onNbtChanged;
    private boolean isDynamicMonitor = true;
    private final IVsswMonitorProvider selfBE;
    protected float pitch = 0.0f;
    protected float yaw = 0.0f;
    protected float width_offset = 0.0f;
    protected float height_offset = 0.0f;
    protected int page_index = 0;
    protected ArrayList<Integer> scroll_offset = new ArrayList();
    protected HashMap<Integer, AbstractPage> pages;

    public VsswMonitorComponent(IVsswMonitorProvider selfBE, float width_size, float height_size, float width_border, float height_border, float def_width_offset, float def_height_offset, float surface_distance) {
        this.WIDTH_SIZE = width_size;
        this.HEIGHT_SIZE = height_size;
        this.WIDTH_BORDER = width_border;
        this.HEIGHT_BORDER = height_border;
        this.DEF_WIDTH_OFFSET = def_width_offset;
        this.DEF_HEIGHT_OFFSET = def_height_offset;
        this.SURFACE_DISTANCE = surface_distance;
        this.WIDTH = (this.WIDTH_SIZE - 2.0f * this.WIDTH_BORDER) / 16.0f;
        this.HEIGHT = (this.HEIGHT_SIZE - 2.0f * this.HEIGHT_BORDER) / 16.0f;
        this.selfBE = selfBE;
    }

    public void setOnClickOuter(OnClickOuter onClickOuter) {
        this.onClickOuter = onClickOuter;
    }

    public void setOnNbtChanged(OnNbtChanged onNbtChanged) {
        this.onNbtChanged = onNbtChanged;
    }

    public void setIsDynamicMonitor(boolean isDynamicMonitor) {
        this.isDynamicMonitor = isDynamicMonitor;
    }

    private void onNbtChanged() {
        if (this.onNbtChanged != null) {
            this.onNbtChanged.onNbtChanged(this);
        }
    }

    public int getScrollIndex(MonitorScrollPanel panel) {
        CopyOnWriteArrayList<MonitorWidget> widgets = this.getPage().getWidgets();
        int index = 0;
        for (int i = 0; i < widgets.size(); ++i) {
            MonitorWidget monitorWidget = widgets.get(i);
            if (!(monitorWidget instanceof MonitorScrollPanel)) continue;
            MonitorScrollPanel scrollPanel = (MonitorScrollPanel)monitorWidget;
            if (scrollPanel == panel) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setAngles(float pitch, float yaw) {
        if (!this.isDynamicMonitor) {
            return;
        }
        this.pitch = pitch % 360.0f;
        this.yaw = yaw % 360.0f;
        this.onNbtChanged();
    }

    public void setOffset(float width_offset, float height_offset) {
        if (!this.isDynamicMonitor) {
            return;
        }
        this.width_offset = this.checkWidthOffset(width_offset);
        this.height_offset = this.checkHeightOffset(height_offset);
        this.onNbtChanged();
    }

    public void setScroll_offset(int index, int offset) {
        if (this.selfBE.m_58904_() != null) {
            this.scroll_offset.set(index, offset);
            this.selfBE.m_6596_();
            BlockPos blockPos = this.selfBE.m_58899_();
            ModNetworkHandler.sendToNearbyPlayers(10, this.selfBE.m_58904_(), blockPos, new SyncScrollOffsetMessage(blockPos, index, offset));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void syncScroll_offset(int index, int offset) {
        if (this.scroll_offset.size() <= index) {
            for (int i = this.scroll_offset.size(); i <= index; ++i) {
                this.scroll_offset.add(0);
            }
        }
        this.scroll_offset.set(index, offset);
        this.sendOffsetToScrollPanel();
    }

    public int getScroll_offset(int index) {
        if (this.scroll_offset.size() <= index) {
            for (int i = this.scroll_offset.size(); i <= index; ++i) {
                this.scroll_offset.add(0);
            }
        }
        return this.scroll_offset.get(index);
    }

    public void setPageIndex(int page_index) {
        this.page_index = page_index;
        this.onNbtChanged();
    }

    public AbstractPage getPage() {
        AbstractPage abstractPage;
        if (this.pages == null && this.selfBE.getFlightControl() != null) {
            this.pages = AbstractPage.newFCPageList(this.selfBE);
        }
        if (this.pages != null && this.selfBE.m_58904_() != null && (abstractPage = this.pages.get(this.page_index)) != null) {
            return abstractPage;
        }
        return EmptyPage.EMPTY_PAGE;
    }

    public void removePages() {
        this.pages = null;
    }

    public void onClick(ServerPlayer player, float x, float y, boolean isOuter) {
        if (!isOuter) {
            this.getPage().onClick(player, this, x, y);
        } else if (this.onClickOuter != null) {
            this.onClickOuter.onClickOuter(this.selfBE, player, x, y);
        }
    }

    public void onMouseScroll(double mouseX, double mouseY, double delta) {
        this.getPage().onMouseScroll(this, (float)mouseX, (float)mouseY, delta);
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getWidthOffset() {
        return this.width_offset;
    }

    public float getHeightOffset() {
        return this.height_offset;
    }

    public float getSurfaceDistance() {
        return this.SURFACE_DISTANCE;
    }

    public float getX_start() {
        return (this.width_offset + this.DEF_WIDTH_OFFSET + this.WIDTH_BORDER) / 16.0f;
    }

    public float getWidth() {
        return this.WIDTH;
    }

    public float getY_start() {
        return (this.height_offset + this.DEF_HEIGHT_OFFSET + this.HEIGHT_BORDER) / 16.0f;
    }

    public float getHeight() {
        return this.HEIGHT;
    }

    protected float checkWidthOffset(float width_offset) {
        if (width_offset + this.DEF_WIDTH_OFFSET < 0.0f) {
            return -this.DEF_WIDTH_OFFSET;
        }
        if (width_offset + this.WIDTH_SIZE + this.DEF_WIDTH_OFFSET > 16.0f) {
            return 16.0f - this.WIDTH_SIZE - this.DEF_WIDTH_OFFSET;
        }
        return width_offset;
    }

    protected float checkHeightOffset(float height_offset) {
        if (height_offset + this.DEF_HEIGHT_OFFSET < 0.0f) {
            return -this.DEF_HEIGHT_OFFSET;
        }
        if (height_offset + this.HEIGHT_SIZE + this.DEF_HEIGHT_OFFSET > 16.0f) {
            return 16.0f - this.HEIGHT_SIZE - this.DEF_HEIGHT_OFFSET;
        }
        return height_offset;
    }

    public void putTag(CompoundTag tag) {
        tag.m_128350_("Pitch", this.pitch);
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128350_("WidthOffset", this.width_offset);
        tag.m_128350_("HeightOffset", this.height_offset);
        tag.m_128405_("PageIndex", this.page_index);
        tag.m_128408_("scroll_offsets", this.scroll_offset);
    }

    public void loadTag(CompoundTag tag) {
        int[] scrollOffsets;
        this.pitch = tag.m_128457_("Pitch");
        this.yaw = tag.m_128457_("Yaw");
        float tmp_width_offset = tag.m_128457_("WidthOffset");
        float tmp_height_offset = tag.m_128457_("HeightOffset");
        this.width_offset = this.checkWidthOffset(tmp_width_offset);
        this.height_offset = this.checkHeightOffset(tmp_height_offset);
        this.page_index = tag.m_128451_("PageIndex");
        ArrayList<Integer> objs = new ArrayList<Integer>();
        for (int scrollOffset : scrollOffsets = tag.m_128465_("scroll_offsets")) {
            objs.add(scrollOffset);
        }
        this.scroll_offset = objs;
        this.sendOffsetToScrollPanel();
    }

    public void sendOffsetToScrollPanel() {
        CopyOnWriteArrayList<MonitorWidget> widgets = this.getPage().getWidgets();
        int index = 0;
        for (MonitorWidget widget : widgets) {
            if (!(widget instanceof MonitorScrollPanel)) continue;
            MonitorScrollPanel scrollPanel = (MonitorScrollPanel)widget;
            scrollPanel.setScrollOffset((float)this.getScroll_offset(index) * 0.001f);
            ++index;
        }
    }

    public static interface OnClickOuter {
        public void onClickOuter(IVsswMonitorProvider var1, ServerPlayer var2, float var3, float var4);
    }

    public static interface OnNbtChanged {
        public void onNbtChanged(VsswMonitorComponent var1);
    }
}

