/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.pages;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.monitors.base.IVsswMonitorProvider;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.block.monitors.pages.AbstractPage;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorButton;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorLine;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorScrollPanel;
import net.shao.valkyrien_space_war.block.monitors.ui_element.WidgetType;

public class RecordPage
extends AbstractPage {
    private byte parentPageIndex = 0;
    private static final String NEW_RECORD_TEXT = Component.m_237115_((String)"monitor.valkyrien_space_war.new_record").getString();
    private static final String DELETE_TEXT = Component.m_237115_((String)"monitor.valkyrien_space_war.delete").getString();
    private static final String[] LOOP_MODE_TEXT = new String[]{Component.m_237115_((String)"monitor.valkyrien_space_war.no_loop").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.single_loop").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.list_loop").getString()};
    private static final String PLAY_TEXT = Component.m_237115_((String)"monitor.valkyrien_space_war.play").getString();

    public RecordPage(IVsswMonitorProvider be) {
        this.addWidget(new MonitorButton(Component.m_237115_((String)"monitor.valkyrien_space_war.back").getString(), (player, bt) -> be.setPageIndex(this.parentPageIndex)).pos(0.0f, 0.02f).size(0.09f, 0.036f).setBackgroundColor(1293753855).setTextColor(15495508));
        this.addWidget(((MonitorButton)new MonitorButton(NEW_RECORD_TEXT, (player, bt) -> {
            if (be.getFlightControl() != null) {
                be.getFlightControl().startOrStopRecording();
            }
        }).setOnRenderMethod(bt -> {
            if (be.getFlightControl() != null) {
                bt.setText(be.getFlightControl().isRecording() ? "REC..." : NEW_RECORD_TEXT).setBackgroundColor(be.getFlightControl().isRecording() ? -328116993 : -1142822913).setTextColor(be.getFlightControl().isRecording() ? 1293753855 : 0x22ABBA);
            }
        })).pos(0.062f, 0.11f).size(0.21f, 0.06f).setTextSize(1.25f));
        this.addWidget(new MonitorButton(DELETE_TEXT, (player, bt) -> {
            if (be.getFlightControl() != null) {
                be.getFlightControl().deleteCurrentRecord();
            }
        }).pos(0.728f, 0.11f).size(0.21f, 0.06f).setTextSize(1.25f).setBackgroundColor(1293753855).setTextColor(15495508));
        this.addWidget(new MonitorLine(0.062f, 0.21f, 0.938f, 0.21f, 1416852991, 0.001f));
        MonitorScrollPanel scrollPanel = new Tmsp(be){}.pos(0.062f, 0.22f).size(0.876f, 0.6f);
        this.addWidget(scrollPanel);
        this.addWidget(new MonitorLine(0.062f, 0.82f, 0.938f, 0.82f, 1416852991, 0.001f));
        this.addWidget(((MonitorButton)new MonitorButton("<<", (player, bt) -> {
            if (be.getFlightControl() != null) {
                be.getFlightControl().playOrPauseReplay(-1);
            }
        }).setOnRenderMethod(bt -> {
            if (be.getFlightControl() != null) {
                RecordPage.setColorByMode(bt, be.getFlightControl(), -1);
            }
        })).pos(0.1f, 0.85f).size(0.15f, 0.06f).setTextSize(1.25f));
        this.addWidget(((MonitorButton)new MonitorButton(">>", (player, bt) -> {
            if (be.getFlightControl() != null) {
                be.getFlightControl().playOrPauseReplay(1);
            }
        }).setOnRenderMethod(bt -> {
            if (be.getFlightControl() != null) {
                RecordPage.setColorByMode(bt, be.getFlightControl(), 1);
            }
        })).pos(0.32f, 0.85f).size(0.15f, 0.06f).setTextSize(1.25f));
        this.addWidget(((MonitorButton)new MonitorButton("NO_LOOP", (player, bt) -> {
            if (be.getFlightControl() != null) {
                be.getFlightControl().nextLoopMode();
            }
        }).setOnRenderMethod(bt -> {
            if (be.getFlightControl() != null) {
                bt.setRenderText(RecordPage.getLoopModeText(be.getFlightControl().loop_mode));
                if (be.getFlightControl().loop_mode == 0) {
                    bt.setBackgroundColor(322848767).setTextColor(10729400);
                } else {
                    bt.setBackgroundColor(581679871).setTextColor(0x202020);
                }
            }
        })).pos(0.53f, 0.85f).size(0.175f, 0.06f).setTextSize(1.25f));
    }

    protected static void setColorByMode(MonitorButton bt, AbstractFlightControlBE be, int mode) {
        if (be.getReplayIndex() == mode) {
            bt.setBackgroundColor(581679871).setTextColor(0x202020);
        } else {
            bt.setBackgroundColor(322848767).setTextColor(12313063);
        }
    }

    private static String getLoopModeText(byte mode) {
        mode = (byte)(mode % LOOP_MODE_TEXT.length);
        return LOOP_MODE_TEXT[mode];
    }

    private static class Tmsp
    extends MonitorScrollPanel {
        private IVsswMonitorProvider be;
        private boolean needRefresh = true;

        public Tmsp(IVsswMonitorProvider be) {
            this.be = be;
        }

        private void refreshTurretList() {
            AbstractFlightControlBE fc;
            if (this.needRefresh) {
                this.removeButtons();
            }
            if ((fc = this.be.getFlightControl()) != null) {
                List itemRecords = fc.getItemRecords();
                ArrayList<String> names = new ArrayList<String>();
                int count = -1;
                for (String itemRecord : itemRecords) {
                    ++count;
                    names.add(itemRecord);
                    if (this.containsButton(itemRecord)) continue;
                    this.addChildren(((MonitorButton)new MonitorButton(itemRecord, (player, bt) -> fc.setSelect_rec(bt.getText())).setOnRenderMethod(bt -> Tmsp.setColorByMode(bt, fc))).pos(0.0f, 0.05f + (float)count * 0.1f).size(this.getWidth(), 0.06f).setTextSize(1.25f));
                }
                this.getChildren().removeIf(child -> {
                    if (child instanceof MonitorButton) {
                        MonitorButton button = (MonitorButton)child;
                        if (!names.contains(button.getText())) {
                            this.needRefresh = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
            }
        }

        protected static void setColorByMode(MonitorButton bt, AbstractFlightControlBE fc) {
            if (bt.getText().equals(fc.select_rec)) {
                bt.setBackgroundColor(581679871).setTextColor(0x202020);
            } else {
                bt.setBackgroundColor(322848767).setTextColor(10729400);
            }
        }

        private void removeButtons() {
            this.getChildren().removeIf(child -> child.getType() == WidgetType.BUTTON);
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource buffer, VsswMonitorComponent be) {
            this.refreshTurretList();
            super.render(poseStack, buffer, be);
        }

        @Override
        public void onClick(ServerPlayer player, VsswMonitorComponent be, float mouseX, float mouseY) {
            this.refreshTurretList();
            super.onClick(player, be, mouseX, mouseY);
        }

        @Override
        public void handleMouseScroll(VsswMonitorComponent be, double mouseX, double mouseY, double delta) {
            this.refreshTurretList();
            super.handleMouseScroll(be, mouseX, mouseY, delta);
        }
    }
}

