/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.ui_element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorDrawable;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorWidget;
import net.shao.valkyrien_space_war.block.monitors.ui_element.WidgetType;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;

public class MonitorButton
implements MonitorWidget,
MonitorDrawable {
    protected WidgetType type = WidgetType.BUTTON;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected String text = "";
    protected String renderText = "";
    protected int backgroundColor = -10066330;
    protected int fontColor = 0xFFFFFF;
    protected float fontScale = 0.0025f;
    protected RenderType renderType;
    float[] scissorBox = DEF_SCISSOR_DATA;
    private OnPress onPress;
    private OnRenderMethod onRenderMethod;
    protected byte align = 1;

    public MonitorButton() {
    }

    public MonitorButton(String text, OnPress onPress) {
        this.text = text;
        this.renderText = text;
        this.onPress = onPress;
    }

    public <T extends MonitorButton> T setOnRenderMethod(OnRenderMethod onRenderMethod) {
        this.onRenderMethod = onRenderMethod;
        return (T)this;
    }

    public MonitorButton pos(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public MonitorButton size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public MonitorButton setText(String text) {
        this.text = text;
        this.renderText = text;
        return this;
    }

    public MonitorButton setRenderText(String text) {
        this.renderText = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MonitorButton setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public MonitorButton setTextColor(int color) {
        this.fontColor = color;
        return this;
    }

    public MonitorButton setTexture(ResourceLocation texture) {
        this.renderType = CustomRenderTypes.createMonitorGuiRenderType(texture);
        return this;
    }

    public MonitorButton setTextAlign(byte align) {
        this.align = align;
        return this;
    }

    public MonitorButton setTextSize(float size) {
        this.fontScale = 0.0025f * size;
        return this;
    }

    public void setScissorBox(float x, float y, float width, float height) {
        this.scissorBox = new float[]{x, y, width, height};
    }

    @Override
    public WidgetType getType() {
        return this.type;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setScissorBox(float[] scissorBox) {
        if (scissorBox.length != 5) {
            return;
        }
        this.scissorBox = scissorBox;
    }

    @Override
    public float[] getScissorBox() {
        return this.scissorBox;
    }

    @Override
    public void handleMouseScroll(VsswMonitorComponent be, double mouseX, double mouseY, double delta) {
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, VsswMonitorComponent be) {
        if (this.onRenderMethod != null) {
            this.onRenderMethod.onRenderMethod(this);
        }
        boolean canRenderText = true;
        float renderX = this.getRenderX(be);
        float renderY = this.getRenderY(be);
        float renderWidth = this.getRenderWidth(be);
        float renderHeight = this.getRenderHeight(be);
        if (this.getScissorBox() != DEF_SCISSOR_DATA) {
            float[] sci = this.getScissorBox();
            if (renderY + renderHeight < sci[1]) {
                return;
            }
            if (renderY > sci[3]) {
                return;
            }
            if (renderY < sci[1]) {
                renderHeight -= sci[1] - renderY;
                renderY = sci[1];
                canRenderText = false;
            } else if (renderY + renderHeight > sci[3]) {
                renderHeight = sci[3] - renderY;
                canRenderText = false;
            }
        }
        if (this.backgroundColor != 0) {
            if (this.renderType == null) {
                this.fill(poseStack, buffer, renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.backgroundColor);
            } else {
                this.fillWithCustomBuffer(poseStack, buffer.m_6299_(this.renderType), renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.backgroundColor);
            }
        }
        if (!canRenderText) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_85836_();
        float ui_scale = Math.min(be.getHeight(), be.getWidth());
        float fsc = this.fontScale * ui_scale;
        float scaledX = switch (this.align) {
            case 1 -> renderX + (renderWidth - (float)font.m_92895_(this.renderText) * fsc) / 2.0f;
            case 2 -> renderX + renderWidth - (float)font.m_92895_(this.renderText) * fsc;
            default -> renderX;
        };
        Objects.requireNonNull(font);
        float scaledY = renderY + (renderHeight - 9.0f * fsc) / 2.0f;
        poseStack.m_85837_((double)scaledX, (double)scaledY, -0.001);
        poseStack.m_85841_(fsc, fsc, 1.0f);
        font.m_271703_(this.renderText, renderX, renderY, this.fontColor, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    @Override
    public void onClick(ServerPlayer player, VsswMonitorComponent be, float mouseX, float mouseY) {
        if (this.onPress != null) {
            System.out.println("\u6211\u88ab\u70b9\u51fb\u4e86: " + this.text);
            this.onPress.onPress(player, this);
        }
    }

    public static interface OnPress {
        public void onPress(ServerPlayer var1, MonitorButton var2);
    }

    public static interface OnRenderMethod {
        public void onRenderMethod(MonitorButton var1);
    }
}

