/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.ui_element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import org.joml.Matrix4f;

public interface MonitorDrawable {
    public static final byte ALIGN_LEFT = 0;
    public static final byte ALIGN_MID = 1;
    public static final byte ALIGN_RIGHT = 2;

    default public void fill(PoseStack poseStack, MultiBufferSource bufferSource, float x1, float y1, float x2, float y2, int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        VertexConsumer buffer = bufferSource.m_6299_(CustomRenderTypes.MONITOR_GUI_RENDER_TYPE);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int packedLight = 0xF000F0;
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
    }

    default public void fillWithCustomBuffer(PoseStack poseStack, VertexConsumer buffer, float x1, float y1, float x2, float y2, int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int packedLight = 0xF000F0;
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
    }

    default public void hLine(PoseStack poseStack, MultiBufferSource bufferSource, float x1, float x2, float y, float width, int color) {
        this.fill(poseStack, bufferSource, x1, y, x2, y + width, color);
    }

    default public void vLine(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y1, float y2, float width, int color) {
        this.fill(poseStack, bufferSource, x, y1, x + width, y2, color);
    }

    default public void drawLine(PoseStack poseStack, MultiBufferSource bufferSource, float x1, float y1, float x2, float y2, int color, float width) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.hypot(dx, dy);
        if (length < 1.0E-5f) {
            return;
        }
        float halfWidth = width * 0.5f;
        float nx = -dy / length * halfWidth;
        float ny = dx / length * halfWidth;
        float[] vertices = new float[]{x1 - nx, y1 - ny, x2 - nx, y2 - ny, x2 + nx, y2 + ny, x1 + nx, y1 + ny};
        this.fillQuad(poseStack, bufferSource, vertices, color);
    }

    default public void fillQuad(PoseStack poseStack, MultiBufferSource bufferSource, float[] vertices, int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        VertexConsumer buffer = bufferSource.m_6299_(CustomRenderTypes.MONITOR_GUI_RENDER_TYPE);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int packedLight = 0xF000F0;
        buffer.m_252986_(matrix, vertices[0], vertices[1], 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[6], vertices[7], 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[4], vertices[5], 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[2], vertices[3], 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
    }
}

