/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.ui_element;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerPlayer;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorDrawable;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorWidget;
import net.shao.valkyrien_space_war.block.monitors.ui_element.WidgetType;

public class MonitorLine
implements MonitorWidget,
MonitorDrawable {
    private final WidgetType type = WidgetType.LINE;
    private float x;
    private float y;
    private float x2;
    private float y2;
    private float width;
    private float height;
    private int color;
    private float lineWidth;
    float[] scissorBox = DEF_SCISSOR_DATA;

    public MonitorLine(float x1, float y1, float x2, float y2, int color, float lineWidth) {
        this.x = x1;
        this.y = y1;
        this.width = Math.abs(x2 - x1);
        this.height = Math.abs(y2 - y1);
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
        this.lineWidth = lineWidth;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY2() {
        return this.y2;
    }

    public void setX2(float x2) {
        this.x2 = x2;
    }

    public void setY2(float y2) {
        this.y2 = y2;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, VsswMonitorComponent be) {
        float[] scissorBox = this.getScissorBox();
        float xStart = be.getX_start();
        float yStart = be.getY_start();
        float renderX = xStart + this.getX() * be.getWidth();
        float renderY = yStart + (this.getY() + scissorBox[4]) * be.getHeight();
        float renderX2 = xStart + this.getX2() * be.getWidth();
        float renderY2 = yStart + (this.getY2() + scissorBox[4]) * be.getHeight();
        float clipX1 = scissorBox[0];
        float clipY1 = scissorBox[1];
        float clipX2 = scissorBox[2];
        float clipY2 = scissorBox[3];
        float pLineWidth = be.getWidth() * this.lineWidth;
        if (this.getScissorBox() == DEF_SCISSOR_DATA) {
            this.drawLine(poseStack, buffer, renderX, renderY, renderX2, renderY2, this.color, pLineWidth);
            return;
        }
        float[] lineCoords = new float[]{renderX, renderY, renderX2, renderY2};
        if (this.clipLineToScissorBox(new float[]{clipX1, clipY1, clipX2, clipY2}, lineCoords)) {
            this.drawLine(poseStack, buffer, lineCoords[0], lineCoords[1], lineCoords[2], lineCoords[3], this.color, pLineWidth);
        }
    }

    private boolean clipLineToScissorBox(float[] scissorBox, float[] line) {
        float temp;
        float x0 = line[0];
        float y0 = line[1];
        float x1 = line[2];
        float y1 = line[3];
        float clipX1 = scissorBox[0];
        float clipY1 = scissorBox[1];
        float clipX2 = scissorBox[2];
        float clipY2 = scissorBox[3];
        if (clipX1 > clipX2) {
            temp = clipX1;
            clipX1 = clipX2;
            clipX2 = temp;
        }
        if (clipY1 > clipY2) {
            temp = clipY1;
            clipY1 = clipY2;
            clipY2 = temp;
        }
        float dx = x1 - x0;
        float dy = y1 - y0;
        float p = 0.0f;
        float q = 0.0f;
        float t0 = 0.0f;
        float t1 = 1.0f;
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                p = -dx;
                q = x0 - clipX1;
            }
            if (i == 1) {
                p = dx;
                q = clipX2 - x0;
            }
            if (i == 2) {
                p = -dy;
                q = y0 - clipY1;
            }
            if (i == 3) {
                p = dy;
                q = clipY2 - y0;
            }
            if (p == 0.0f) {
                if (!(q < 0.0f)) continue;
                return false;
            }
            float t = q / p;
            if (p < 0.0f) {
                if (t > t1) {
                    return false;
                }
                if (!(t > t0)) continue;
                t0 = t;
                continue;
            }
            if (t < t0) {
                return false;
            }
            if (!(t < t1)) continue;
            t1 = t;
        }
        float nx0 = x0 + t0 * dx;
        float ny0 = y0 + t0 * dy;
        float nx1 = x0 + t1 * dx;
        float ny1 = y0 + t1 * dy;
        line[0] = nx0;
        line[1] = ny0;
        line[2] = nx1;
        line[3] = ny1;
        return true;
    }

    @Override
    public boolean canRender(VsswMonitorComponent be) {
        return true;
    }

    @Override
    public boolean isHovered(VsswMonitorComponent be, float mouseX, float mouseY) {
        return false;
    }

    @Override
    public WidgetType getType() {
        return this.type;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setScissorBox(float[] scissorBox) {
        if (scissorBox.length != 5) {
            return;
        }
        this.scissorBox = scissorBox;
    }

    @Override
    public float[] getScissorBox() {
        return this.scissorBox;
    }

    @Override
    public void onClick(ServerPlayer player, VsswMonitorComponent be, float mouseX, float mouseY) {
    }

    @Override
    public void handleMouseScroll(VsswMonitorComponent be, double mouseX, double mouseY, double delta) {
    }
}

