/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.ui_element;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerPlayer;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorDrawable;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorWidget;
import net.shao.valkyrien_space_war.block.monitors.ui_element.WidgetType;

public class MonitorProgressBar
implements MonitorWidget,
MonitorDrawable {
    protected WidgetType type = WidgetType.PROGRESS_BAR;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    float[] scissorBox = DEF_SCISSOR_DATA;
    protected int backgroundColor = -10066177;
    protected int foregroundColor = -1;
    protected float progress = 0.0f;
    private OnRenderMethod onRenderMethod;

    public MonitorProgressBar(OnRenderMethod onRenderMethod) {
        this.onRenderMethod = onRenderMethod;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public MonitorProgressBar pos(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public MonitorProgressBar size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public WidgetType getType() {
        return this.type;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setScissorBox(float[] scissorBox) {
        if (scissorBox.length != 5) {
            return;
        }
        this.scissorBox = scissorBox;
    }

    @Override
    public float[] getScissorBox() {
        return this.scissorBox;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public MonitorProgressBar setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public MonitorProgressBar setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, VsswMonitorComponent be) {
        if (this.onRenderMethod != null) {
            this.onRenderMethod.onRenderMethod(this);
        }
        float renderX = this.getRenderX(be);
        float renderY = this.getRenderY(be);
        float renderWidth = this.getRenderWidth(be);
        float renderHeight = this.getRenderHeight(be);
        if (this.getScissorBox() != DEF_SCISSOR_DATA) {
            float[] sci = this.getScissorBox();
            if (renderY + renderHeight < sci[1]) {
                return;
            }
            if (renderY > sci[3]) {
                return;
            }
            if (renderY < sci[1]) {
                renderHeight -= sci[1] - renderY;
                renderY = sci[1];
            } else if (renderY + renderHeight > sci[3]) {
                renderHeight = sci[3] - renderY;
            }
        }
        float w1 = renderWidth * this.progress;
        this.fill(poseStack, buffer, renderX, renderY, renderX + w1, renderY + renderHeight, this.foregroundColor);
        this.fill(poseStack, buffer, renderX + w1, renderY, renderWidth, renderY + renderHeight, this.backgroundColor);
    }

    @Override
    public void onClick(ServerPlayer player, VsswMonitorComponent be, float mouseX, float mouseY) {
    }

    @Override
    public void handleMouseScroll(VsswMonitorComponent be, double mouseX, double mouseY, double delta) {
    }

    public static interface OnRenderMethod {
        public void onRenderMethod(MonitorProgressBar var1);
    }
}

