/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.monitors.ui_element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.shao.valkyrien_space_war.block.monitors.base.VsswMonitorComponent;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorButton;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorDrawable;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorLine;
import net.shao.valkyrien_space_war.block.monitors.ui_element.MonitorWidget;
import net.shao.valkyrien_space_war.block.monitors.ui_element.WidgetType;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;

public class MonitorScrollPanel
implements MonitorWidget,
MonitorDrawable {
    private final List<MonitorWidget> children = new ArrayList<MonitorWidget>();
    private final WidgetType type = WidgetType.SCROLL_PANEL;
    private float scrollOffset;
    private float x;
    private float y;
    private float width;
    private float height;
    private float[] scissorBox = DEF_SCISSOR_DATA;
    private RenderType renderType;
    private String name;
    private int backgroundColor = 0;

    public MonitorScrollPanel pos(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public MonitorScrollPanel size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public MonitorScrollPanel setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MonitorScrollPanel setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public MonitorScrollPanel setTexture(ResourceLocation texture) {
        this.renderType = CustomRenderTypes.createMonitorGuiRenderType(texture);
        return this;
    }

    @Override
    public WidgetType getType() {
        return this.type;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setScissorBox(float[] scissorBox) {
        if (scissorBox.length != 5) {
            return;
        }
        this.scissorBox = scissorBox;
    }

    @Override
    public float[] getScissorBox() {
        return this.scissorBox;
    }

    private float getMinScroll() {
        float maxHeight = 0.0f;
        for (MonitorWidget child : this.children) {
            float v = child.getY();
            maxHeight = Math.max(maxHeight, v);
        }
        return Math.min(0.0f, -maxHeight);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void addChildren(MonitorWidget ... children) {
        for (MonitorWidget child : children) {
            child.setX(child.getX() + this.getX());
            child.setY(child.getY() + this.getY());
            if (child instanceof MonitorLine) {
                MonitorLine c = (MonitorLine)child;
                c.setX2(c.getX2() + this.getX());
                c.setY2(c.getY2() + this.getY());
            }
            this.children.add(child);
        }
    }

    public List<MonitorWidget> getChildren() {
        return this.children;
    }

    public boolean containsButton(String name) {
        for (MonitorWidget child : this.children) {
            if (child.getType() != WidgetType.BUTTON || !((MonitorButton)child).getText().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, VsswMonitorComponent be) {
        float[] sci;
        float renderX = this.getRenderX(be);
        float renderY = this.getRenderY(be);
        float renderWidth = this.getRenderWidth(be);
        float renderHeight = this.getRenderHeight(be);
        if (this.getScissorBox() != DEF_SCISSOR_DATA) {
            sci = this.getScissorBox();
            if (renderY + renderHeight < sci[1]) {
                return;
            }
            if (renderY > sci[1] + sci[3]) {
                return;
            }
            if (renderY < sci[1]) {
                renderY = sci[1];
                renderHeight -= sci[1] - renderY;
            }
            if (renderY + renderHeight > sci[3]) {
                renderHeight = sci[3] - renderY;
            }
        }
        if (this.backgroundColor != 0) {
            if (this.renderType == null) {
                this.fill(poseStack, buffer, renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.backgroundColor);
            } else {
                this.fillWithCustomBuffer(poseStack, buffer.m_6299_(this.renderType), renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.backgroundColor);
            }
        }
        sci = new float[]{renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.scrollOffset};
        for (MonitorWidget child : this.children) {
            poseStack.m_85837_(0.0, 0.0, -1.0E-5);
            child.setScissorBox(sci);
            child.render(poseStack, buffer, be);
        }
    }

    public void setScrollOffset(float scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    @Override
    public void onClick(ServerPlayer player, VsswMonitorComponent be, float mouseX, float mouseY) {
        int scrollIndex = be.getScrollIndex(this);
        if (scrollIndex != -1) {
            this.scrollOffset = (float)be.getScroll_offset(scrollIndex) * 0.001f;
        }
        float localY = mouseY - this.scrollOffset * be.getHeight();
        for (MonitorWidget child : this.children) {
            if (!child.isHovered(be, mouseX, localY)) continue;
            child.onClick(player, be, mouseX, localY);
            break;
        }
    }

    @Override
    public void handleMouseScroll(VsswMonitorComponent be, double mouseX, double mouseY, double delta) {
        for (MonitorWidget child : this.children) {
            if (child.getType() != WidgetType.EDIT_BOX || !child.isHovered(be, (float)mouseX, (float)mouseY)) continue;
            child.handleMouseScroll(be, mouseX, mouseY, delta);
            return;
        }
        int scrollIndex = be.getScrollIndex(this);
        if (scrollIndex == -1) {
            return;
        }
        this.scrollOffset = (float)be.getScroll_offset(scrollIndex) * 0.001f;
        this.scrollOffset = Math.min(0.0f, Math.max(this.scrollOffset + (float)(delta * (double)0.1f), this.getMinScroll()));
        be.setScroll_offset(scrollIndex, (int)(this.scrollOffset * 1000.0f));
    }
}

