/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.radar;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.radar.base.BaseRadarBE;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.raycast.LongRangeRaycaster;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;

public class CreativeModeRadarBE
extends BaseRadarBE {
    private int range = 2048;
    private ScannerThread scannerThread;
    private volatile HashSet<LivingEntity> livingEntityInRange;
    private volatile HashSet<Ship> shipInRange;

    public CreativeModeRadarBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_MODE_RADAR_BE.get(), pPos, pBlockState);
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        this.range = Math.min(this.range, 3000000);
        tag.m_128405_("Range", this.range);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.range = Math.min(tag.m_128451_("Range"), 3000000);
    }

    private void addNewThread() {
        this.scannerThread = new ScannerThread(this);
        threadPool.submit(this.scannerThread);
    }

    private void setLivingEntityInRange(HashSet<LivingEntity> livingEntityInRange) {
        this.livingEntityInRange = livingEntityInRange;
    }

    private void setShipInRange(HashSet<Ship> shipInRange) {
        this.shipInRange = shipInRange;
    }

    private HashSet<LivingEntity> getLivingEntitiesInRange(HashSet<LivingEntity> entities) {
        if (this.scannerThread == null) {
            this.addNewThread();
        }
        this.scannerThread.needRefreshEntities(entities);
        return this.livingEntityInRange == null ? EMPTY_ENTITY_SET : this.livingEntityInRange;
    }

    @Override
    public HashSet<Ship> getShips() {
        if (this.scannerThread == null) {
            this.addNewThread();
        }
        this.scannerThread.needRefreshShips();
        return this.shipInRange == null ? EMPTY_SHIP_SET : this.shipInRange;
    }

    @Override
    public HashSet<LivingEntity> getMonsters() {
        if (this.f_58857_ != null && ModResourceManager.allMonsters.get(this.f_58857_) != null) {
            return this.getLivingEntitiesInRange(ModResourceManager.allMonsters.get(this.f_58857_));
        }
        return EMPTY_ENTITY_SET;
    }

    @Override
    public HashSet<LivingEntity> getAnimals() {
        if (this.f_58857_ != null && ModResourceManager.allAnimals.get(this.f_58857_) != null) {
            return this.getLivingEntitiesInRange(ModResourceManager.allAnimals.get(this.f_58857_));
        }
        return EMPTY_ENTITY_SET;
    }

    @Override
    public HashSet<LivingEntity> getPlayers() {
        if (this.f_58857_ != null && ModResourceManager.allPlayers.get(this.f_58857_) != null) {
            HashSet<LivingEntity> livingEntitiesInRange = this.getLivingEntitiesInRange(ModResourceManager.allPlayers.get(this.f_58857_));
            livingEntitiesInRange.removeIf(e -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    return p.m_5833_();
                }
                return false;
            });
            return this.getLivingEntitiesInRange(ModResourceManager.allPlayers.get(this.f_58857_));
        }
        return EMPTY_ENTITY_SET;
    }

    @Override
    public HashSet<LivingEntity> getLivingEntities() {
        if (this.f_58857_ != null && ModResourceManager.allLivingEntities.get(this.f_58857_) != null) {
            return this.getLivingEntitiesInRange(ModResourceManager.allLivingEntities.get(this.f_58857_));
        }
        return EMPTY_ENTITY_SET;
    }

    private void removeThread() {
        this.scannerThread = null;
    }

    private static class ScannerThread
    implements Runnable {
        private final CreativeModeRadarBE be;
        private final CopyOnWriteArraySet<LivingEntity> needRefreshEntities = new CopyOnWriteArraySet();
        private final AtomicBoolean needRefreshShips = new AtomicBoolean(false);
        private final int range;

        public ScannerThread(CreativeModeRadarBE be) {
            this.be = be;
            this.range = be.range;
        }

        public void needRefreshEntities(HashSet<LivingEntity> entities) {
            this.needRefreshEntities.addAll(entities);
        }

        public void needRefreshShips() {
            this.needRefreshShips.set(true);
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted() && !this.be.m_58901_()) {
                    if (!this.needRefreshEntities.isEmpty()) {
                        HashSet<LivingEntity> entities = new HashSet<LivingEntity>(this.needRefreshEntities);
                        this.needRefreshEntities.clear();
                        this.be.setLivingEntityInRange(this.getLivingEntitiesInRange(entities));
                    }
                    if (this.needRefreshShips.getAndSet(false)) {
                        this.be.setShipInRange(this.getShips());
                    }
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.be.removeThread();
            }
        }

        private HashSet<LivingEntity> getLivingEntitiesInRange(Set<LivingEntity> entities) {
            Level level = this.be.m_58904_();
            if (level == null || level.m_5776_()) {
                return BaseRadarBE.EMPTY_ENTITY_SET;
            }
            if (entities != null && !entities.isEmpty()) {
                BlockPos blockPos = this.be.m_58899_();
                Vector3d bp = new Vector3d((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                ServerShip serverShip = this.be.getServerShip();
                if (serverShip != null) {
                    bp = serverShip.getShipToWorld().transformPosition(bp);
                }
                LevelLightEngine lightEngine = level.m_5518_();
                long max_range = (long)this.range * (long)this.range;
                HashSet<LivingEntity> result = new HashSet<LivingEntity>();
                for (LivingEntity entity2 : entities) {
                    long z;
                    long y;
                    long x;
                    long dis;
                    BlockPos ep = entity2.m_20097_().m_7494_();
                    boolean isCheck = level.m_46472_() != Level.f_46428_ || lightEngine.m_75814_(LightLayer.SKY).m_7768_(ep) > 0;
                    if (!isCheck || (dis = (x = (long)(bp.x() - (double)ep.m_123341_())) * x + (y = (long)(bp.y() - (double)ep.m_123342_())) * y + (z = (long)(bp.z() - (double)ep.m_123343_())) * z) > max_range) continue;
                    result.add(entity2);
                }
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 finalBp = new Vec3(bp.x(), bp.y(), bp.z());
                result.removeIf(entity -> LongRangeRaycaster.hasOcclusion(true, serverLevel, finalBp, entity.m_146892_()) != null);
                return result;
            }
            return BaseRadarBE.EMPTY_ENTITY_SET;
        }

        public HashSet<Ship> getShips() {
            Level level = this.be.m_58904_();
            if (level == null || level.m_5776_()) {
                return BaseRadarBE.EMPTY_SHIP_SET;
            }
            HashSet<Ship> result = new HashSet<Ship>();
            QueryableShipData<LoadedServerShip> ships = VsUtil.getLoadedShips((ServerLevel)level);
            if (ships.isEmpty()) {
                return result;
            }
            BlockPos blockPos = this.be.m_58899_();
            Vector3d bp = new Vector3d((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            ServerShip serverShip = this.be.getServerShip();
            if (serverShip != null) {
                bp = serverShip.getShipToWorld().transformPosition(bp);
            }
            LevelLightEngine lightEngine = level.m_5518_();
            long max_range = (long)this.range * (long)this.range;
            Vector3d finalBp = bp;
            ships.forEach(ship -> {
                long z;
                long y;
                long x;
                long dis;
                Vector3dc posVec = ship.getTransform().getPositionInWorld();
                if (lightEngine.m_75814_(LightLayer.SKY).m_7768_(new BlockPos((int)posVec.x(), (int)posVec.y(), (int)posVec.z())) > 0 && (dis = (x = (long)(finalBp.x() - posVec.x())) * x + (y = (long)(finalBp.y() - posVec.y())) * y + (z = (long)(finalBp.z() - posVec.z())) * z) <= max_range) {
                    result.add((Ship)ship);
                }
            });
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 bpVec3 = new Vec3(bp.x(), bp.y(), bp.z());
            result.removeIf(ship -> {
                Vector3dc positionInWorld = ship.getTransform().getPositionInWorld();
                return LongRangeRaycaster.hasOcclusion(true, serverLevel, bpVec3, new Vec3(positionInWorld.x(), positionInWorld.y(), positionInWorld.z())) != null;
            });
            return result;
        }
    }
}

