/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FcRecord {
    private final List<Frame> frames = new ArrayList<Frame>();
    private boolean isRecording = false;
    public String name = "no_name";
    public boolean canRecord;
    private int currentFrame = 0;
    private boolean isNextRewind = false;
    private boolean isPrevRewind = false;

    public FcRecord(boolean canRecord) {
        this.canRecord = canRecord;
    }

    public void startRecording() {
        this.frames.clear();
        this.isRecording = true;
    }

    public void update(Vector3f pos, Quaternionf rot) {
        if (this.isRecording) {
            this.frames.add(new Frame(pos, rot));
        }
    }

    public void update(Vector3d pos, Quaterniond rot) {
        if (this.isRecording) {
            this.frames.add(new Frame(new Vector3f((float)pos.x, (float)pos.y, (float)pos.z), new Quaternionf((float)rot.x, (float)rot.y, (float)rot.z, (float)rot.w)));
        }
    }

    public void stopAndSave(ServerLevel level, String recordName) throws IOException {
        this.isRecording = false;
        if (this.frames.isEmpty()) {
            return;
        }
        this.canRecord = false;
        this.name = recordName;
        Path path = FcRecord.getRecordPath(level, recordName);
        this.saveToFile(path);
    }

    private void saveToFile(Path path) throws IOException {
        CompoundTag rootTag = new CompoundTag();
        ListTag frameList = new ListTag();
        for (Frame frame : this.frames) {
            CompoundTag frameTag = new CompoundTag();
            frameTag.m_128350_("posX", frame.pos.x());
            frameTag.m_128350_("posY", frame.pos.y());
            frameTag.m_128350_("posZ", frame.pos.z());
            frameTag.m_128350_("rotX", frame.rot.x());
            frameTag.m_128350_("rotY", frame.rot.y());
            frameTag.m_128350_("rotZ", frame.rot.z());
            frameTag.m_128350_("rotW", frame.rot.w());
            frameList.add((Object)frameTag);
        }
        rootTag.m_128365_("frames", (Tag)frameList);
        rootTag.m_128359_("name", this.name);
        rootTag.m_128405_("version", 1);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (DataOutputStream outputStream = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            NbtIo.m_128947_((CompoundTag)rootTag, (OutputStream)outputStream);
        }
    }

    public static FcRecord loadRecording(ServerLevel level, String recordName) throws IOException {
        CompoundTag rootTag;
        Path path = FcRecord.getRecordPath(level, recordName);
        try (DataInputStream inputStream = new DataInputStream(Files.newInputStream(path, new OpenOption[0]));){
            rootTag = NbtIo.m_128939_((InputStream)inputStream);
        }
        if (rootTag == null || !rootTag.m_128425_("frames", 9)) {
            throw new IOException("Invalid record format");
        }
        FcRecord record = new FcRecord(false);
        ListTag frameList = rootTag.m_128437_("frames", 10);
        record.name = rootTag.m_128461_("name");
        for (Tag tag : frameList) {
            CompoundTag frameTag = (CompoundTag)tag;
            Vector3f pos = new Vector3f(frameTag.m_128457_("posX"), frameTag.m_128457_("posY"), frameTag.m_128457_("posZ"));
            Quaternionf rot = new Quaternionf(frameTag.m_128457_("rotX"), frameTag.m_128457_("rotY"), frameTag.m_128457_("rotZ"), frameTag.m_128457_("rotW"));
            record.frames.add(new Frame(pos, rot));
        }
        return record;
    }

    public static List<String> getRecordFiles(ServerLevel level) {
        ArrayList<String> files;
        block9: {
            Path recordDir = level.m_7654_().m_129843_(LevelResource.f_78182_).resolve("records");
            files = new ArrayList<String>();
            try {
                if (!Files.exists(recordDir, new LinkOption[0])) break block9;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(recordDir, "*.rec");){
                    for (Path entry : stream) {
                        files.add(entry.getFileName().toString().replace(".rec", ""));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return files;
    }

    public static Path getRecordPath(ServerLevel level, String recordName) {
        Path worldPath = level.m_7654_().m_129843_(LevelResource.f_78182_);
        return worldPath.resolve("records").resolve(recordName + ".rec");
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public void setCurrentFrameIndex(int frameIndex) {
        this.currentFrame = frameIndex;
    }

    public Frame getFrame(int index) {
        return switch (index) {
            case 1 -> this.nextFrame();
            case -1 -> this.prevFrame();
            default -> this.frames.get(index);
        };
    }

    public Frame getFrameLoop(int index) {
        return switch (index) {
            case 1 -> this.nextFrameLoop();
            case -1 -> this.prevFrameLoop();
            default -> this.frames.get(index);
        };
    }

    public Frame nextFrame() {
        ++this.currentFrame;
        if (this.currentFrame >= this.frames.size()) {
            this.currentFrame = 0;
            return null;
        }
        return this.frames.get(this.currentFrame);
    }

    public Frame prevFrame() {
        --this.currentFrame;
        if (this.currentFrame >= this.frames.size() || this.currentFrame < 0) {
            this.currentFrame = 0;
            return null;
        }
        return this.frames.get(this.currentFrame);
    }

    public Frame nextFrameLoop() {
        if (this.isNextRewind) {
            --this.currentFrame;
            if (this.currentFrame < 0) {
                this.isNextRewind = false;
                this.currentFrame = 0;
            }
        } else {
            ++this.currentFrame;
            if (this.currentFrame >= this.frames.size()) {
                this.isNextRewind = true;
                this.currentFrame = this.frames.size() - 1;
            }
        }
        return this.frames.get(this.currentFrame);
    }

    public Frame prevFrameLoop() {
        if (this.isPrevRewind) {
            ++this.currentFrame;
            if (this.currentFrame >= this.frames.size()) {
                this.isPrevRewind = false;
                this.currentFrame = this.frames.size() - 1;
            }
        } else {
            --this.currentFrame;
            if (this.currentFrame < 0) {
                this.isPrevRewind = true;
                this.currentFrame = 0;
            }
        }
        return this.frames.get(this.currentFrame);
    }

    public void resetFrame() {
        this.currentFrame = 0;
    }

    public int frameCount() {
        return this.frames.size();
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public record Frame(Vector3f pos, Quaternionf rot) {
        private final Vector3f pos;
        private final Quaternionf rot;

        public Frame(Vector3f pos, Quaternionf rot) {
            this.pos = new Vector3f((Vector3fc)pos);
            this.rot = new Quaternionf((Quaternionfc)rot);
        }

        public Vector3f pos() {
            return new Vector3f((Vector3fc)this.pos);
        }

        public Quaternionf rot() {
            return new Quaternionf((Quaternionfc)this.rot);
        }
    }
}

