/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.record;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.shao.valkyrien_space_war.block.record.RecordManagerBE;
import net.shao.valkyrien_space_war.block.record.RecordManagerMenu;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.record.AddRecordPacket;
import net.shao.valkyrien_space_war.network.record.RemoveRecordPacket;
import net.shao.valkyrien_space_war.network.record.RequestRecordListPacket;

public class RecordManagerScreen
extends AbstractContainerScreen<RecordManagerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/record_manager_gui.png");
    protected final RecordManagerBE be;
    private int x;
    private int y;
    private RecordScrollPanel availableFilesPanel;
    private RecordScrollPanel selectedFilesPanel;
    private List<String> availableFiles = new ArrayList<String>();
    private List<String> selectedFiles = new ArrayList<String>();
    private EditBox renameBox;

    public RecordManagerScreen(RecordManagerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.be = (RecordManagerBE)((RecordManagerMenu)this.f_97732_).be;
        this.f_97726_ = 256;
        this.f_97727_ = 186;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        ModNetworkHandler.sendToServer(new RequestRecordListPacket(this.be.m_58899_()));
        this.availableFilesPanel = new RecordScrollPanel(this.f_96541_, 117, 88, this.y + 8, this.x + 8, false);
        this.m_142416_((GuiEventListener)this.availableFilesPanel);
        this.selectedFilesPanel = new RecordScrollPanel(this.f_96541_, 117, 67, this.y + 29, this.x + 131, true);
        this.m_142416_((GuiEventListener)this.selectedFilesPanel);
    }

    public void setRecordFiles(List<String> available, List<String> selected) {
        this.availableFiles = available;
        this.selectedFiles = selected;
        this.availableFilesPanel.setFiles(available);
        this.selectedFilesPanel.setFiles(selected);
    }

    protected void m_6597_(Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        super.m_6597_(pSlot, pSlotId, pMouseButton, pType);
        System.out.println("\u70b9\u51fb\u4e86\u63d2\u69fd");
        ModNetworkHandler.sendToServer(new RequestRecordListPacket(this.be.m_58899_()));
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        pGuiGraphics.m_280218_(TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280509_(this.x + 8, this.y + 8, this.x + 8 + 117, this.y + 8 + 88, -1442840576);
        pGuiGraphics.m_280509_(this.x + 131, this.y + 29, this.x + 131 + 117, this.y + 29 + 67, -1442840576);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private class RecordScrollPanel
    extends ScrollPanel {
        private List<String> files;
        private int entryHeight;
        private int padding;
        private int totalHeight;
        private final boolean isSelectedPanel;

        public RecordScrollPanel(Minecraft mc, int width, int height, int top, int left, boolean isSelectedPanel) {
            super(mc, width, height, top, left);
            this.files = new ArrayList<String>();
            this.entryHeight = 12;
            this.padding = 2;
            this.isSelectedPanel = isSelectedPanel;
        }

        public void setFiles(List<String> files) {
            this.files = files;
            this.totalHeight = files.size() * (this.entryHeight + this.padding) + this.padding;
        }

        protected int getContentHeight() {
            return this.totalHeight;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            for (int i = 0; i < this.files.size(); ++i) {
                String file = this.files.get(i);
                int y = baseY + i * (this.entryHeight + this.padding);
                if (y < this.top || y + this.entryHeight > this.top + this.height) continue;
                int bgColor = this.isMouseOverFile(mouseX, mouseY, i) ? 0xFFFFFF : 0xAAAAAA;
                guiGraphics.m_280509_(this.left, y, this.left + this.width, y + this.entryHeight, bgColor << 8 | 0x44);
                int textColor = 0;
                guiGraphics.m_280488_(((RecordManagerScreen)RecordManagerScreen.this).f_96541_.f_91062_, file, this.left + 2, y + (this.entryHeight - 8) / 2, textColor);
            }
        }

        private boolean isMouseOverFile(int mouseX, int mouseY, int index) {
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int y = baseY + index * (this.entryHeight + this.padding);
            return mouseX >= this.left && mouseX <= this.left + this.width && mouseY >= y && mouseY <= y + this.entryHeight;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            int baseY = this.top + this.border - (int)this.scrollDistance;
            for (int i = 0; i < this.files.size(); ++i) {
                int y = baseY + i * (this.entryHeight + this.padding);
                if (!this.isMouseOverFile((int)mouseX, (int)mouseY, i)) continue;
                String fileName = this.files.get(i);
                if (this.isSelectedPanel) {
                    ModNetworkHandler.sendToServer(new RemoveRecordPacket(RecordManagerScreen.this.be.m_58899_(), fileName));
                } else {
                    ModNetworkHandler.sendToServer(new AddRecordPacket(RecordManagerScreen.this.be.m_58899_(), fileName));
                }
                return true;
            }
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }
}

