/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.seat.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.radar.base.RadarTarget;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBlock;
import net.shao.valkyrien_space_war.block.seat.base.ShipControlSeatMenu;
import net.shao.valkyrien_space_war.block.seat.base.ShipControlSeatScreen;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCapability;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCraftProxy;
import net.shao.valkyrien_space_war.function.raycast.LongRangeRaycaster;
import net.shao.valkyrien_space_war.function.rs_channel.IRsChannelProvider;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.function.util.ModServerUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.input.VsswInputState;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.hologram.SyncHologramRenderTargetPacket;
import net.shao.valkyrien_space_war.network.rs_channel.SyncRsProviderChannelToClientPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;

public class BaseShipControlSeatBE
extends ModGuestBE
implements MenuProvider,
IRsChannelProvider {
    private static final ModConnectorBE.ConnectorType type = ModConnectorBE.ConnectorType.SEAT;
    public Vector3f faceVec;
    public Quaternionf rotationForRender;
    public float faceAngle;
    public float[] input = new float[VsswInputState.KEY_LENGTH];
    public float[] clientInputs = new float[VsswInputState.KEY_LENGTH];
    protected ServerPlayer owner;
    public HashMap<Long, SingleRenderTarget> hologramRenderTargets = new HashMap();
    private static final double hologramHeight = 1.62;
    private CopyOnWriteArrayList<Ship> sortedShips = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<LivingEntity> sortedEntities = new CopyOnWriteArrayList();
    public static final int HOLOGRAM_FOV = 70;
    private final float maxDistanceSq = 9.0E12f;
    private final Vector3f eyePos;
    private final double cosHalfFOV = Math.cos(Math.toRadians(35.0));
    private boolean isControlling = false;
    private String[] rs_channels = new String[20];
    protected float yaw;
    protected float pitch = 0.0f;
    protected boolean resetCameraRot = true;
    public ComputerCapability computerCapability;
    private int detectionCd = 0;
    private boolean hasPlayerInRange = true;
    private int refreshRadarCd = 0;
    private boolean clearHologramRenderTarget = false;
    private final HologramRenderTargetSnapshot EMPTY_SNAPSHOT = new HologramRenderTargetSnapshot(0, new Vector3f[0], new boolean[0], new long[0]);
    private HologramRenderTargetSnapshot lastSnapshot;
    private boolean[] prevBoolInput = new boolean[VsswInputState.KEY_LENGTH];
    private int targetLoopDirection = 1;

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return type;
    }

    public BaseShipControlSeatBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        Direction value = (Direction)pBlockState.m_61143_((Property)BaseShipControlSeatBlock.FACING);
        this.faceVec = new Vector3f((float)value.m_122429_(), (float)value.m_122430_(), (float)value.m_122431_());
        this.faceAngle = (float)Math.toDegrees(Math.atan2(-this.faceVec.x, this.faceVec.z));
        this.rotationForRender = new Quaternionf().rotationY((float)Math.atan2(-this.faceVec.x, -this.faceVec.z));
        this.eyePos = new Vector3f((float)pPos.m_123341_() + 0.5f, (float)((double)pPos.m_123342_() + this.getHologramHeight()), (float)pPos.m_123343_() + 0.5f);
        this.computerCapability = ComputerCraftProxy.create(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (this.computerCapability != null && this.computerCapability.isPeripheralCap(cap)) {
            return this.computerCapability.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.computerCapability != null) {
            this.computerCapability.removePeripheral();
        }
    }

    @Override
    public void m_7651_() {
        this.input = new float[VsswInputState.KEY_LENGTH];
        super.m_7651_();
    }

    public double getHologramHeight() {
        return 1.62;
    }

    public boolean isControlling() {
        return this.isControlling;
    }

    public void setControlling(boolean isControlling) {
        this.isControlling = isControlling;
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ServerShip sereverShip = this.getServerShip();
        this.checkRsChannels((Ship)sereverShip);
        AbstractFlightControlBE fc = this.getFlightControl();
        if (fc == null) {
            return;
        }
        if (sereverShip == null) {
            return;
        }
        if (this.detectionCd-- <= 0) {
            this.detectionCd = 10;
            BlockPos wPos = VsUtil.getShipToWorldBlockPos((Ship)sereverShip, new BlockPos((Vec3i)pPos));
            this.hasPlayerInRange = BaseShipControlSeatBE.playerIsInRange((ServerLevel)pLevel, wPos);
        }
        if (!this.hasPlayerInRange) {
            return;
        }
        this.checkRadar(fc, (Ship)sereverShip, pLevel, pPos);
    }

    private void checkRsChannels(Ship sereverShip) {
        String id = "null";
        if (sereverShip != null) {
            long shipId = sereverShip.getId();
            id = Long.toString(shipId);
        }
        for (int i = 0; i < this.rs_channels.length; ++i) {
            if (this.rs_channels[i] != null && !this.rs_channels[i].isEmpty()) continue;
            this.rs_channels[i] = id + "-def";
        }
    }

    private void checkRadar(AbstractFlightControlBE fc, Ship sereverShip, Level pLevel, BlockPos pPos) {
        RadarTarget target = fc.getTarget();
        if (target == null || target.isEmpty()) {
            this.initHologramRenderTarget(pPos);
            if (this.refreshRadarCd-- <= 0) {
                this.refreshRadarCd = 20;
                this.nextRadarTarget();
            }
        } else {
            this.checkOwner();
            Matrix4dc worldToShip = VsUtil.getWorldToShipTransform(sereverShip);
            Vector3f eyeWPos = VsUtil.getShipToWorldPos(sereverShip, this.eyePos);
            for (Ship s : target.getShips()) {
                boolean occluded;
                Vector3dc shipPos = s.getTransform().getPositionInWorld();
                boolean bl = occluded = LongRangeRaycaster.hasOcclusion(true, (ServerLevel)pLevel, new Vec3((double)eyeWPos.x(), (double)eyeWPos.y(), (double)eyeWPos.z()), new Vec3(shipPos.x(), shipPos.y(), shipPos.z())) != null;
                if (occluded) {
                    this.loopRadarTarget(this.targetLoopDirection);
                    return;
                }
                Vector3d tgPos = worldToShip.transformPosition(new Vector3d(shipPos));
                boolean inFOV = ModMathUtil.isInFOV(this.eyePos, this.faceVec, tgPos, 9.0E12f, this.cosHalfFOV);
                if (inFOV) continue;
                this.loopRadarTarget(this.targetLoopDirection);
                return;
            }
            for (LivingEntity entity : target.getEntities()) {
                boolean occluded;
                if (!entity.m_6084_()) {
                    this.loopRadarTarget(this.targetLoopDirection);
                    continue;
                }
                boolean bl = occluded = LongRangeRaycaster.hasOcclusion(true, (ServerLevel)pLevel, new Vec3((double)eyeWPos.x(), (double)eyeWPos.y(), (double)eyeWPos.z()), entity.m_20182_()) != null;
                if (occluded) {
                    this.loopRadarTarget(this.targetLoopDirection);
                    return;
                }
                Vector3d tgPos = worldToShip.transformPosition(new Vector3d((Vector3fc)entity.m_20182_().m_252839_()));
                boolean inFOV = ModMathUtil.isInFOV(this.eyePos, this.faceVec, tgPos, 9.0E12f, this.cosHalfFOV);
                if (inFOV) continue;
                this.loopRadarTarget(this.targetLoopDirection);
                return;
            }
            this.syncHologramRenderTarget(target, pPos);
        }
    }

    private static boolean playerIsInRange(ServerLevel level, BlockPos center) {
        int radiusSquared = 1024;
        Predicate<ServerPlayer> detectionPredicate = player -> player.m_6084_() && player.m_20275_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()) <= (double)radiusSquared;
        return level.m_8795_(detectionPredicate).size() > 0;
    }

    private void initHologramRenderTarget(BlockPos bp) {
        if (this.clearHologramRenderTarget) {
            return;
        }
        ModNetworkHandler.sendToNearbyPlayers(2, this.f_58857_, bp, new SyncHologramRenderTargetPacket(bp, 0, null, null, null));
        this.lastSnapshot = this.EMPTY_SNAPSHOT;
        this.clearHologramRenderTarget = true;
    }

    private void syncHologramRenderTarget(RadarTarget target, BlockPos bp) {
        List ships = target.getShips().stream().toList();
        List entities = target.getEntities().stream().toList();
        int size = ships.size() + entities.size();
        if (size > Short.MAX_VALUE) {
            return;
        }
        short count = (short)size;
        Vector3f[] positions = new Vector3f[size];
        boolean[] isShip = new boolean[size];
        long[] ids = new long[size];
        int index = 0;
        for (Ship ship : ships) {
            Vector3dc positionInWorld = ship.getTransform().getPositionInWorld();
            positions[index] = new Vector3f((float)positionInWorld.x(), (float)positionInWorld.y(), (float)positionInWorld.z());
            isShip[index] = true;
            ids[index] = ship.getId();
            ++index;
        }
        for (LivingEntity entity : entities) {
            positions[index] = entity.m_146892_().m_252839_();
            isShip[index] = false;
            ids[index] = entity.m_19879_();
            ++index;
        }
        HologramRenderTargetSnapshot snapShot = new HologramRenderTargetSnapshot(count, positions, isShip, ids);
        if (!this.isSameSnapshot(snapShot, this.lastSnapshot)) {
            ModNetworkHandler.sendToNearbyPlayers(2, this.f_58857_, bp, new SyncHologramRenderTargetPacket(bp, snapShot.count, snapShot.positions, snapShot.isShip, snapShot.ids));
        }
        this.lastSnapshot = snapShot;
        this.clearHologramRenderTarget = false;
    }

    private boolean isSameSnapshot(HologramRenderTargetSnapshot snapshot1, HologramRenderTargetSnapshot snapshot2) {
        if (snapshot1 == null || snapshot2 == null) {
            return false;
        }
        if (snapshot1.count != snapshot2.count) {
            return false;
        }
        for (int i = 0; i < snapshot1.count; ++i) {
            if (snapshot1.positions[i].distanceSquared((Vector3fc)snapshot2.positions[i]) > 1.0E-4f) {
                return false;
            }
            if (snapshot1.isShip[i] == snapshot2.isShip[i]) continue;
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveHologramRenderTarget(short count, Vector3f[] positions, boolean[] isShip, long[] ids) {
        if (count > 0) {
            HashSet<Long> idsInCurrentCycle = new HashSet<Long>();
            for (int i = 0; i < count; ++i) {
                long id = isShip[i] ? ids[i] : -ids[i];
                idsInCurrentCycle.add(id);
                if (this.hologramRenderTargets.containsKey(id)) {
                    this.hologramRenderTargets.get(id).setPos(positions[i]);
                    continue;
                }
                this.hologramRenderTargets.put(id, new SingleRenderTarget(positions[i], System.currentTimeMillis()));
            }
            HashSet<Long> idsToRemove = new HashSet<Long>(this.hologramRenderTargets.keySet());
            idsToRemove.removeAll(idsInCurrentCycle);
            for (Long id : idsToRemove) {
                this.hologramRenderTargets.remove(id);
            }
        } else {
            this.hologramRenderTargets.clear();
        }
    }

    public void setInput(boolean[] mask, boolean[] boolInput, float[] input) {
        int i;
        int floatCount = 13;
        for (i = 0; i < floatCount; ++i) {
            if (!mask[i]) continue;
            this.input[i] = input[i];
            if (this.computerCapability == null) continue;
            this.computerCapability.queueEvent("vssw_axis_input", new Object[]{i + 1, Float.valueOf(input[i])});
        }
        for (i = floatCount; i < VsswInputState.KEY_LENGTH; ++i) {
            this.input[i] = boolInput[i] ? 1.0f : 0.0f;
        }
        this.checkNewInput(boolInput);
        this.prevBoolInput = boolInput;
    }

    public float[] getInput() {
        return (float[])this.input.clone();
    }

    public String[] getInputKeyNames() {
        return VsswInputState.keyNames;
    }

    private void checkNewInput(boolean[] boolInput) {
        AbstractFlightControlBE fc = this.getFlightControl();
        for (int i = 13; i < VsswInputState.KEY_LENGTH; ++i) {
            if (this.prevBoolInput[i] == boolInput[i]) continue;
            if (fc != null) {
                if (boolInput[i]) {
                    switch (i) {
                        case 20: {
                            this.nextRadarTarget();
                            break;
                        }
                        case 21: {
                            this.prevRadarTarget();
                            break;
                        }
                        case 19: {
                            this.nextRadarMode(fc);
                            break;
                        }
                        case 27: {
                            fc.prevGunLevel();
                            break;
                        }
                        case 28: {
                            fc.nextGunLevel();
                            break;
                        }
                        case 23: {
                            fc.thrusterDown();
                            break;
                        }
                        case 22: {
                            fc.thrusterUp();
                            break;
                        }
                        case 15: {
                            fc.setSpCoupled(!fc.isSpCoupled());
                            break;
                        }
                        case 29: {
                            fc.setEngineOn(!fc.isEngineOn());
                            break;
                        }
                        case 16: {
                            fc.startAutoLevel(this.owner);
                        }
                    }
                }
                switch (i) {
                    case 14: {
                        fc.switchBurner();
                    }
                }
            }
            if (i >= 30) {
                this.onRedStoneOutput(i - 30, boolInput[i]);
            }
            if (this.computerCapability == null) continue;
            this.computerCapability.queueEvent("vssw_button_input", new Object[]{i + 1, boolInput[i]});
        }
        if (fc != null) {
            fc.setFire((Player)this.owner, this.input[12] > 0.0f, 1.0f - this.input[12]);
        }
    }

    private void onRedStoneOutput(int outputIndex, boolean on) {
        this.sendRsChannel(this.rs_channels[outputIndex], on ? 15 : 0);
    }

    @Override
    public String[] getRsChannels() {
        return this.rs_channels;
    }

    @Override
    public void setRsChannels(String[] channelName) {
        this.rs_channels = channelName;
    }

    private void checkOwner() {
        if (this.owner == null && this.f_58857_ != null) {
            Optional<ServerPlayer> nearestPlayer = ModServerUtil.findNearestPlayer((ServerLevel)this.f_58857_, this.m_58899_());
            nearestPlayer.ifPresent(serverPlayer -> {
                this.owner = serverPlayer;
            });
        }
    }

    public void setOwner(ServerPlayer owner) {
        this.owner = owner;
    }

    public Player getOwner() {
        return this.owner;
    }

    public String[] getRs_channels() {
        return this.rs_channels;
    }

    public void updateRsChannelName(int index, String name) {
        if (index < 0 || index >= this.rs_channels.length) {
            return;
        }
        this.rs_channels[index] = name;
        this.m_6596_();
    }

    public void syncRsChannelNames(ServerPlayer player) {
        ModNetworkHandler.sendToPlayer(player, new SyncRsProviderChannelToClientPacket(this.m_58899_(), this.getRs_channels()));
    }

    @Override
    public void setClientRsChannels(String[] channelNames) {
        if (!this.f_58857_.m_5776_()) {
            return;
        }
        if (channelNames.length != this.rs_channels.length) {
            return;
        }
        for (int i = 0; i < channelNames.length; ++i) {
            this.rs_channels[i] = channelNames[i];
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ShipControlSeatScreen) {
            ShipControlSeatScreen screen2 = (ShipControlSeatScreen)screen;
            screen2.updateRsChannelNames();
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isResetCameraRot() {
        return this.resetCameraRot;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
        this.syncToClient();
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
        this.syncToClient();
    }

    public void setResetCameraRot(boolean resetCameraRot) {
        this.resetCameraRot = resetCameraRot;
        this.syncToClient();
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128350_("pitch", this.pitch);
        tag.m_128379_("resetCamRot", this.resetCameraRot);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.yaw = tag.m_128457_("yaw");
        this.pitch = tag.m_128457_("pitch");
        this.resetCameraRot = tag.m_128471_("resetCamRot");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.putRsChannelsToTag(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadRsChannelsFromTag(tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resetClientInputs() {
        this.clientInputs = new float[VsswInputState.KEY_LENGTH];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientInput(float[] floatsInstance, boolean[] boolInstance) {
        for (int i = 0; i < VsswInputState.KEY_LENGTH; ++i) {
            this.clientInputs[i] = i < 13 ? floatsInstance[i] : (boolInstance[i] ? 1.0f : 0.0f);
        }
    }

    private void nextRadarMode(AbstractFlightControlBE fc) {
        fc.nextRadarMode();
        this.nextRadarTarget();
    }

    private void nextRadarTarget() {
        this.targetLoopDirection = 1;
        this.loopRadarTarget(1);
    }

    private void prevRadarTarget() {
        this.targetLoopDirection = -1;
        this.loopRadarTarget(-1);
    }

    private void loopRadarTarget(int direction) {
        this.updateSortedTargets();
        AbstractFlightControlBE fc = this.getFlightControl();
        if (fc == null) {
            return;
        }
        RadarTarget newTarget = new RadarTarget();
        int firstShipIndex = -1;
        int firstEntityIndex = -1;
        if (fc.getTarget() != null) {
            if (fc.radarMode == 1 || fc.radarMode == 5) {
                Ship firstShip = fc.getTarget().getFirstShip();
                int n = firstShipIndex = firstShip != null ? this.sortedShips.indexOf(firstShip) : firstShipIndex;
            }
            if (firstShipIndex == -1) {
                LivingEntity firstEntity = fc.getTarget().getFirstEntity();
                firstEntityIndex = firstEntity != null ? this.sortedEntities.indexOf(firstEntity) : firstEntityIndex;
            }
        }
        int targetCount = fc.getTargetCount();
        for (int i = 0; i < targetCount; ++i) {
            int entityIndexOffset;
            int shipIndexOffset = firstShipIndex == -1 ? i : firstShipIndex + i * direction + direction;
            int n = entityIndexOffset = firstEntityIndex == -1 ? i : firstEntityIndex + i * direction + direction;
            shipIndexOffset = !this.sortedShips.isEmpty() ? (shipIndexOffset < 0 ? this.sortedShips.size() + shipIndexOffset : shipIndexOffset % this.sortedShips.size()) : -1;
            entityIndexOffset = !this.sortedEntities.isEmpty() ? (entityIndexOffset < 0 ? this.sortedEntities.size() + entityIndexOffset : entityIndexOffset % this.sortedEntities.size()) : -1;
            if (fc.radarMode == 1 || fc.radarMode == 5) {
                if (shipIndexOffset != -1) {
                    newTarget.addShip(this.sortedShips.get(shipIndexOffset));
                    continue;
                }
                if (fc.radarMode != 5 || entityIndexOffset == -1) continue;
                newTarget.addEntity(this.sortedEntities.get(entityIndexOffset));
                continue;
            }
            if (entityIndexOffset == -1) continue;
            newTarget.addEntity(this.sortedEntities.get(entityIndexOffset));
        }
        if (newTarget.isEmpty()) {
            fc.setEmptyRadarTarget();
        } else {
            fc.setTarget(newTarget);
        }
    }

    private void updateSortedTargets() {
        ServerShip sereverShip = this.getServerShip();
        if (sereverShip == null) {
            return;
        }
        RadarTarget radarTargetsInFOV = this.getRadarTargetsInFOV();
        if (radarTargetsInFOV == null || radarTargetsInFOV.isEmpty()) {
            this.sortedShips.clear();
            this.sortedEntities.clear();
        } else {
            this.sortedShips = new CopyOnWriteArrayList<Ship>(radarTargetsInFOV.getShips());
            this.sortedEntities = new CopyOnWriteArrayList<LivingEntity>(radarTargetsInFOV.getEntities());
        }
        BlockPos bp = this.m_58899_();
        Vector3d bpV3 = new Vector3d((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
        Matrix4dc worldToShip = VsUtil.getWorldToShipTransform((Ship)sereverShip);
        Quaterniond seatRot = new Quaterniond().rotationY(Math.toRadians(this.faceAngle));
        AbstractFlightControlBE fc = this.getFlightControl();
        if (fc == null) {
            return;
        }
        if (fc.radarMode == 1 || fc.radarMode == 5) {
            this.sortedShips.sort((ship1, ship2) -> {
                Vector3d s1 = worldToShip.transformPosition(new Vector3d(ship1.getTransform().getPositionInWorld())).sub((Vector3dc)bpV3, new Vector3d());
                Vector3d s2 = worldToShip.transformPosition(new Vector3d(ship2.getTransform().getPositionInWorld())).sub((Vector3dc)bpV3, new Vector3d());
                s1 = seatRot.transform(s1);
                s2 = seatRot.transform(s2);
                return Double.compare(s2.x(), s1.x());
            });
            if (fc.radarMode == 5) {
                this.sortedEntities.sort((e1, e2) -> {
                    Vector3d ep1 = worldToShip.transformPosition(new Vector3d(e1.m_20182_().m_7096_(), e1.m_20182_().m_7098_(), e1.m_20182_().m_7094_())).sub((Vector3dc)bpV3, new Vector3d());
                    Vector3d ep2 = worldToShip.transformPosition(new Vector3d(e2.m_20182_().m_7096_(), e2.m_20182_().m_7098_(), e2.m_20182_().m_7094_())).sub((Vector3dc)bpV3, new Vector3d());
                    ep1 = seatRot.transform(ep1);
                    ep2 = seatRot.transform(ep2);
                    return Double.compare(ep2.x(), ep1.x());
                });
            }
        } else {
            this.sortedEntities.sort((e1, e2) -> {
                Vector3d ep1 = worldToShip.transformPosition(new Vector3d(e1.m_20182_().m_7096_(), e1.m_20182_().m_7098_(), e1.m_20182_().m_7094_())).sub((Vector3dc)bpV3, new Vector3d());
                Vector3d ep2 = worldToShip.transformPosition(new Vector3d(e2.m_20182_().m_7096_(), e2.m_20182_().m_7098_(), e2.m_20182_().m_7094_())).sub((Vector3dc)bpV3, new Vector3d());
                ep1 = seatRot.transform(ep1);
                ep2 = seatRot.transform(ep2);
                return Double.compare(ep2.x(), ep1.x());
            });
        }
    }

    private RadarTarget getRadarTargetsInFOV() {
        ServerShip sereverShip = this.getServerShip();
        if (sereverShip == null) {
            return null;
        }
        RadarTarget result = new RadarTarget();
        AbstractFlightControlBE fc = this.getFlightControl();
        if (fc != null) {
            RadarTarget allTargets = fc.getRadarTargetsByMode(fc.radarMode);
            if (allTargets.isEmpty()) {
                return result;
            }
            Matrix4dc worldToShip = VsUtil.getWorldToShipTransform((Ship)sereverShip);
            HashSet<Ship> ships = result.getShips();
            allTargets.getShips().forEach(ship -> {
                Vector3d tgPos = worldToShip.transformPosition(new Vector3d(ship.getTransform().getPositionInWorld()));
                boolean inFOV = ModMathUtil.isInFOV(this.eyePos, this.faceVec, tgPos, 9.0E12f, this.cosHalfFOV);
                if (inFOV) {
                    ships.add((Ship)ship);
                }
            });
            HashSet<LivingEntity> entities = result.getEntities();
            allTargets.getEntities().forEach(e -> {
                Vector3d tgPos = worldToShip.transformPosition(new Vector3d((Vector3fc)e.m_20182_().m_252839_()));
                boolean inFOV = ModMathUtil.isInFOV(this.eyePos, this.faceVec, tgPos, 9.0E12f, this.cosHalfFOV);
                if (inFOV) {
                    entities.add((LivingEntity)e);
                }
            });
        }
        return result;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.valkyrien_space_war.base_ship_control_seat");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ShipControlSeatMenu(pContainerId, pPlayerInventory, this);
    }

    public record HologramRenderTargetSnapshot(short count, Vector3f[] positions, boolean[] isShip, long[] ids) {
    }

    public static class SingleRenderTarget {
        private Vector3f pos;
        private long time;

        public SingleRenderTarget(Vector3f pos, long time) {
            this.pos = pos;
            this.time = time;
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public long getTime() {
            return this.time;
        }

        public void setPos(Vector3f pos) {
            this.pos = pos;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

