/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.seat.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.seat.base.ShipControlSeatMenu;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.control_seat.ControlSeatSetupPacket;
import net.shao.valkyrien_space_war.network.rs_channel.UpdateRsProviderChannelPacket;
import net.shao.valkyrien_space_war.screen.ui.ClearButton;
import org.valkyrienskies.core.api.ships.ClientShip;

public class ShipControlSeatScreen
extends AbstractContainerScreen<ShipControlSeatMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/seat_rs_channel.png");
    private static final int ITEM_HEIGHT = 15;
    private static final int PADDING = 5;
    public RsChannelScrollPanel scrollPanel;
    private final BaseShipControlSeatBE be;
    private AbstractWidget focusedWidget = null;
    private String selfId;
    private static final Component SELF_SHIP_COMP = Component.m_237115_((String)"gui.valkyrien_space_war.self_ship_id");
    protected int x;
    protected int y;
    private static final Component RS_CHANNEL_TITLE = Component.m_237115_((String)"gui.valkyrien_space_war.red_stone_channel");

    public ShipControlSeatScreen(ShipControlSeatMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.be = menu.getBlockEntity();
        this.f_97726_ = 216;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        ClientShip clientShip = this.be.getClientShip();
        this.selfId = ModGuiUtil.formatNumberRightAlign(clientShip == null ? -1 : (int)clientShip.getId(), 9);
        this.selfId = SELF_SHIP_COMP.getString() + ": " + this.selfId;
        this.scrollPanel = new RsChannelScrollPanel(this.f_96541_, this.f_97726_ - 12, this.f_97727_ - 47, this.f_97736_ + 40, this.f_97735_ + 6);
        ClearButton resetHeadButton = new ClearButton(this.x + 8, this.y + 8, 60, 16, (Component)Component.m_237115_((String)"gui.valkyrien_space_war.resetCamera"), button -> {
            boolean b = !this.be.isResetCameraRot();
            ModNetworkHandler.sendToServer(new ControlSeatSetupPacket(this.be.m_58899_(), this.be.getYaw(), this.be.getPitch(), b));
            this.setButtonColor(button, b);
        });
        this.setButtonColor(resetHeadButton, this.be.isResetCameraRot());
        resetHeadButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.sitting_in_the_control_seat")));
        EditBox yawBox = new EditBox(this.f_96547_, this.x + 98, this.y + 8, 35, 15, (Component)Component.m_237113_((String)"yaw"));
        EditBox pitchBox = new EditBox(this.f_96547_, this.x + 173, this.y + 8, 35, 15, (Component)Component.m_237113_((String)"pitch"));
        yawBox.m_94144_(String.valueOf(this.be.getYaw()));
        yawBox.m_94151_(val -> ModNetworkHandler.sendToServer(new ControlSeatSetupPacket(this.be.m_58899_(), Mth.m_14177_((float)ModGuiUtil.parseFloat(val)), this.be.getPitch(), this.be.isResetCameraRot())));
        pitchBox.m_94144_(String.valueOf(this.be.getPitch()));
        pitchBox.m_94151_(val -> ModNetworkHandler.sendToServer(new ControlSeatSetupPacket(this.be.m_58899_(), this.be.getYaw(), Mth.m_14177_((float)ModGuiUtil.parseFloat(val)), this.be.isResetCameraRot())));
        this.m_142416_((GuiEventListener)this.scrollPanel);
        this.m_142416_((GuiEventListener)yawBox);
        this.m_142416_((GuiEventListener)pitchBox);
        this.m_142416_((GuiEventListener)resetHeadButton);
    }

    private void setButtonColor(ClearButton cb, boolean b) {
        if (b) {
            cb.setColor(0.75f, 1.0f, 0.75f);
        } else {
            cb.setColor(0.25f, 0.25f, 0.25f);
        }
    }

    public void updateRsChannelNames() {
        this.scrollPanel.updateRsChannelNames();
    }

    private void updateFocusedEditBox(EditBox editBox, double mouseX, double mouseY) {
        this.focusedWidget = editBox;
        editBox.m_93692_(true);
        editBox.m_5716_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.focusedWidget != null) {
            this.focusedWidget = null;
        } else if (this.focusedWidget != null) {
            return this.focusedWidget.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.focusedWidget != null) {
            return this.focusedWidget.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280488_(this.f_96547_, "  YAW", 68, 12, 0xFFFFFF);
        pGuiGraphics.m_280488_(this.f_96547_, "PITCH", 138, 12, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, RS_CHANNEL_TITLE, 18, 29, 0xFFFFFF);
        pGuiGraphics.m_280488_(this.f_96547_, this.selfId, 100, 29, 0xFFFFFF);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private class RsChannelScrollPanel
    extends ScrollPanel {
        private List<Row> children;
        private int tTop;

        public RsChannelScrollPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.children = new CopyOnWriteArrayList<Row>();
            this.tTop = top - 15;
            this.updateRsChannelNames();
        }

        public void updateRsChannelNames() {
            this.children.clear();
            int y = 0;
            for (int i = 0; i < ShipControlSeatScreen.this.be.getRs_channels().length; ++i) {
                this.children.add(new Row(i, y));
                y += 20;
            }
        }

        protected int getContentHeight() {
            return this.children.size() * 20 + 5;
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            for (Row child : this.children) {
                int y = relativeY + child.y;
                if (y <= this.tTop || y >= this.bottom) continue;
                child.render(guiGraphics, this.left, y, mouseX, mouseY);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            double panelY = (float)this.top - this.scrollDistance;
            for (Row child : this.children) {
                if (!child.isMouseOver(this.left, (int)panelY, mouseX, mouseY)) continue;
                child.onClick(mouseX, mouseY);
                return true;
            }
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }

        private class Row {
            private final int channelIndex;
            private final EditBox shipIdBox;
            private final EditBox channelNameBox;
            public int y;

            public Row(int index, int y) {
                this.y = y;
                this.channelIndex = index;
                String channelName = ShipControlSeatScreen.this.be.getRs_channels()[this.channelIndex];
                String[] strings = ModGuiUtil.splitFirstOccurrence(channelName, "-");
                this.shipIdBox = new EditBox(ShipControlSeatScreen.this.f_96547_, 0, 0, 60, 15, (Component)Component.m_237113_((String)"id"));
                this.shipIdBox.m_94144_(strings[0] == null ? "" : strings[0]);
                this.shipIdBox.m_94151_(val -> {
                    if (val.isEmpty() || ModGuiUtil.isAllDigits(val)) {
                        this.syncToServer();
                    } else {
                        String filteredVal = ModGuiUtil.filterNumbers(val);
                        this.shipIdBox.m_94144_(filteredVal);
                    }
                });
                this.channelNameBox = new EditBox(ShipControlSeatScreen.this.f_96547_, 0, 0, 100, 15, (Component)Component.m_237113_((String)"name"));
                this.channelNameBox.m_94144_(strings[1] == null ? "" : strings[1]);
                this.channelNameBox.m_94151_(val -> this.syncToServer());
            }

            private void syncToServer() {
                ModNetworkHandler.sendToServer(new UpdateRsProviderChannelPacket(ShipControlSeatScreen.this.be.m_58899_(), this.channelIndex, this.shipIdBox.m_94155_() + "-" + this.channelNameBox.m_94155_()));
            }

            public void render(GuiGraphics guiGraphics, int panelX, int panelY, int mouseX, int mouseY) {
                guiGraphics.m_280488_(ShipControlSeatScreen.this.f_96547_, String.valueOf(this.channelIndex), panelX + 1, panelY, 0xFFFFFF);
                this.shipIdBox.m_252865_(panelX + 14);
                this.shipIdBox.m_253211_(panelY);
                this.shipIdBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
                guiGraphics.m_280488_(ShipControlSeatScreen.this.f_96547_, "-", panelX + 78, panelY + 4, 0xFFFFFF);
                this.channelNameBox.m_252865_(panelX + 86);
                this.channelNameBox.m_253211_(panelY);
                this.channelNameBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            }

            public boolean isMouseOver(int panelX, int panelY, double mouseX, double mouseY) {
                int entryTop = panelY + this.y;
                int entryBottom = entryTop + 15;
                return mouseY >= (double)entryTop && mouseY <= (double)entryBottom;
            }

            public void onClick(double mouseX, double mouseY) {
                if (ShipControlSeatScreen.this.focusedWidget != null) {
                    ShipControlSeatScreen.this.focusedWidget.m_93692_(false);
                }
                if (this.shipIdBox.m_5953_(mouseX, mouseY)) {
                    ShipControlSeatScreen.this.updateFocusedEditBox(this.shipIdBox, mouseX, mouseY);
                } else if (this.channelNameBox.m_5953_(mouseX, mouseY)) {
                    ShipControlSeatScreen.this.updateFocusedEditBox(this.channelNameBox, mouseX, mouseY);
                }
            }
        }
    }
}

