/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.seat.hologram;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.seat.base.BaseShipControlSeatBE;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.block.turret.energy.BasicEnergyTurretBE;
import net.shao.valkyrien_space_war.compat.gregtech.GTValuesDup;
import net.shao.valkyrien_space_war.function.render.CustomRenderTypes;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import org.joml.Matrix2f;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.ClientShip;

public class SeatHologramRenderer {
    public static final byte ALIGN_LEFT = 0;
    public static final byte ALIGN_MID = 1;
    public static final byte ALIGN_RIGHT = 2;
    public static final ResourceLocation BLANK_TEX = new ResourceLocation("valkyrien_space_war", "textures/gui/blank.png");
    public static final RenderType HOLOGRAM_RENDER_TYPE = CustomRenderTypes.createHologramRenderType(BLANK_TEX);
    public static final RenderType HOLOGRAM_LINE_RENDER_TYPE = CustomRenderTypes.createHologramRenderType(new ResourceLocation("valkyrien_space_war", "textures/hologram/hologram_line.png"));
    private static final Matrix2f rot90 = new Matrix2f(0.0f, -1.0f, 1.0f, 0.0f);
    private static final String[] RADAR_MODE_NAMES = new String[]{Component.m_237115_((String)"monitor.valkyrien_space_war.radar_null").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.radar_ships").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.radar_monsters").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.radar_players").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.radar_animals").getString(), Component.m_237115_((String)"monitor.valkyrien_space_war.radar_all").getString()};
    private static final int HOLOGRAM_COLOR = 54940;
    private static final int LOCK_BOX_SHIP_COLOR = -16776961;
    private static final int LOCK_BOX_ENTITY_COLOR = -1142822913;
    private static final String ENGINE_OFF_TEXT = Component.m_237115_((String)"monitor.valkyrien_space_war.engine_off").getString();

    public void renderHologram(BaseShipControlSeatBE seat, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ClientShip clientShip = seat.getClientShip();
        if (clientShip == null) {
            SeatHologramRenderer.drawText(-0.5f, -0.5f, 1.0f, 1.0f, 1, 0x22ABBA, "NO SHIP FOUND", 0.5f, poseStack, bufferSource);
            return;
        }
        AbstractFlightControlBE fc = seat.getFlightControl();
        if (fc != null) {
            SeatHologramRenderer.drawRadarMode(fc, poseStack, bufferSource);
            this.drawTurret(fc, poseStack, bufferSource);
            this.drawThrusterLevel(fc, poseStack, bufferSource);
            this.drawCoupled(fc, poseStack, bufferSource);
            this.drawEngineState(fc, poseStack, bufferSource);
        }
        Matrix4dc worldToShip = clientShip.getRenderTransform().getWorldToShip();
        Matrix4dc shipToWorld = clientShip.getRenderTransform().getShipToWorld();
        Vector3f raw_front = new Vector3f((Vector3fc)seat.faceVec);
        Vector3f raw_right = new Vector3f(rot90.m00() * raw_front.x + rot90.m01() * raw_front.z, raw_front.y, rot90.m10() * raw_front.x + rot90.m11() * raw_front.z);
        Quaterniond rot = shipToWorld.getNormalizedRotation(new Quaterniond());
        Vector3d front = rot.transform(new Vector3d((Vector3fc)raw_front));
        Vector3d right = rot.transform(new Vector3d((Vector3fc)raw_right));
        Vector3d top = rot.transform(new Vector3d(0.0, 1.0, 0.0));
        double pitch = Math.asin(front.y());
        BlockPos blockPos = seat.m_58899_();
        Vector3d shipHologramCenter = new Vector3d((double)blockPos.m_123341_() + 0.5 + (double)seat.faceVec.x(), (double)blockPos.m_123342_() + seat.getHologramHeight(), (double)blockPos.m_123343_() + 0.5 + (double)seat.faceVec.z());
        Minecraft mc = Minecraft.m_91087_();
        Vec3 camera = mc.f_91063_.m_109153_().m_90583_();
        Vector3d cameraToShipPos = worldToShip.transformPosition(new Vector3d(camera.f_82479_, camera.f_82480_, camera.f_82481_));
        Vector3d eyePos = cameraToShipPos.sub((Vector3dc)shipHologramCenter, new Vector3d());
        this.drawCross(poseStack, bufferSource);
        SeatHologramRenderer.drawAtt(eyePos, pitch, poseStack, bufferSource, top, right);
        this.drawRadarTarget(seat, poseStack, bufferSource, worldToShip, shipHologramCenter, cameraToShipPos);
        this.drawControlLine(seat, poseStack, bufferSource);
        this.drawSpeedAndHeight(seat, poseStack, bufferSource);
    }

    private void drawSpeedAndHeight(BaseShipControlSeatBE seat, PoseStack poseStack, MultiBufferSource bufferSource) {
        ClientShip clientShip = seat.getClientShip();
        double speed = clientShip.getVelocity().length();
        String speedStr = String.format("%.1f KM/H", speed * 3.6);
        SeatHologramRenderer.drawText(0.25f, 0.1f, 1.0f, 0.15f, 2, 54940, speedStr, 0.25f, poseStack, bufferSource);
        Vector3dc positionInWorld = clientShip.getRenderTransform().getPositionInWorld();
        String heightStr = String.format("H: %.1f M", positionInWorld.y());
        SeatHologramRenderer.drawText(0.25f, 0.05f, 1.0f, 0.15f, 2, 54940, heightStr, 0.25f, poseStack, bufferSource);
    }

    private void drawControlLine(BaseShipControlSeatBE seat, PoseStack poseStack, MultiBufferSource bufferSource) {
        float[] clientInputs = seat.clientInputs;
        float yaw = clientInputs[8] - clientInputs[9];
        float pitch = clientInputs[10] - clientInputs[11];
        SeatHologramRenderer.drawLine(poseStack, bufferSource, 0.0f, 0.0f, 0.5f * -yaw, 0.5f * -pitch, -103, 0.005f);
    }

    private void drawCoupled(AbstractFlightControlBE fc, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (!fc.spCoupled && System.currentTimeMillis() % 1000L < 500L) {
            SeatHologramRenderer.drawText(0.35f, 0.2f, 1.0f, 0.15f, 2, -16777216, 0x66FF0000, "DECOUPLED", 0.5f, poseStack, bufferSource);
        }
    }

    private void drawEngineState(AbstractFlightControlBE fc, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (!fc.isEngineOn()) {
            SeatHologramRenderer.drawText(0.35f, 0.25f, 1.0f, 0.15f, 2, -16777216, 0x66FF0000, ENGINE_OFF_TEXT, 0.5f, poseStack, bufferSource);
        }
    }

    private static void drawRadarMode(AbstractFlightControlBE fc, PoseStack poseStack, MultiBufferSource bufferSource) {
        SeatHologramRenderer.drawText(-0.5f, 0.25f, 1.0f, 0.1f, 1, 54940, "< " + RADAR_MODE_NAMES[fc.radarMode] + " >", 0.25f, poseStack, bufferSource);
    }

    private void drawThrusterLevel(AbstractFlightControlBE fc, PoseStack poseStack, MultiBufferSource bufferSource) {
        SeatHologramRenderer.drawText(-0.35f, 0.25f, 1.0f, 0.1f, 0, 54940, Component.m_237115_((String)"monitor.valkyrien_space_war.thruster_strength").getString() + ": " + fc.spThrusterLevel, 0.25f, poseStack, bufferSource);
    }

    private void drawTurret(AbstractFlightControlBE fc, PoseStack poseStack, MultiBufferSource bufferSource) {
        Level level = fc.m_58904_();
        if (level == null) {
            return;
        }
        float x = -0.5f;
        float y = 0.0f;
        int count = 0;
        VertexConsumer buffer = bufferSource.m_6299_(HOLOGRAM_RENDER_TYPE);
        BlockPos fcPos = fc.m_58899_();
        for (BlockPos childPos : fc.getChildren()) {
            AbstractTurretBE turretBE;
            BlockPos bePos = new BlockPos(fcPos.m_123341_() + childPos.m_123341_(), fcPos.m_123342_() + childPos.m_123342_(), fcPos.m_123343_() + childPos.m_123343_());
            BlockEntity blockEntity = level.m_7702_(bePos);
            if (blockEntity instanceof AbstractTurretBE && (turretBE = (AbstractTurretBE)blockEntity) instanceof BasicEnergyTurretBE) {
                BasicEnergyTurretBE energyTurretBE = (BasicEnergyTurretBE)turretBE;
                this.drawEnergyTurret(x, y, energyTurretBE, poseStack, bufferSource, buffer);
                y += 0.055f;
                ++count;
            }
            if (count <= 5) continue;
            break;
        }
    }

    private void drawEnergyTurret(float x, float y, BasicEnergyTurretBE energyTurretBE, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer) {
        float energy = (float)energyTurretBE.getEnergyStored() / (float)energyTurretBE.getEnergyCapacity();
        SeatHologramRenderer.drawText(x, y, 1.0f, 0.1f, 0, -1, ChatFormatting.GRAY + energyTurretBE.m_5446_().getString() + " " + ChatFormatting.BOLD + GTValuesDup.VNF[energyTurretBE.getGunLevel()], 0.25f, poseStack, bufferSource);
        SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, x, y + 0.07f, x + 0.15f * energy, y + 0.07f, 14064895, 0.01f);
        if (energy < 1.0f) {
            SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, x + 0.15f * energy, y + 0.07f, x + 0.15f, y + 0.07f, 0x666666FF, 0.01f);
        }
        SeatHologramRenderer.drawText(x + 0.15f, y + 0.02f, 1.0f, 0.1f, 0, -1, ChatFormatting.GRAY + " " + energyTurretBE.getProjectileCount(), 0.25f, poseStack, bufferSource);
    }

    private void drawCross(PoseStack poseStack, MultiBufferSource bufferSource) {
        float start = 0.005f;
        float end = 0.015f;
        VertexConsumer buffer = bufferSource.m_6299_(HOLOGRAM_RENDER_TYPE);
        int color = SeatHologramRenderer.combineColorAlpha(54940, 1.0f);
        SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, start, 0.0f, end, 0.0f, color, 0.005f);
        SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, -start, 0.0f, -end, 0.0f, color, 0.005f);
        SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, 0.0f, start, 0.0f, end, color, 0.005f);
        SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, 0.0f, -start, 0.0f, -end, color, 0.005f);
    }

    private void drawRadarTarget(BaseShipControlSeatBE seat, PoseStack poseStack, MultiBufferSource bufferSource, Matrix4dc worldToShip, Vector3d shipHologramCenter, Vector3d cameraToShipPos) {
        float borderX = 0.75f;
        float borderY = 0.6f;
        long currentTime = System.currentTimeMillis();
        ArrayList lines = new ArrayList();
        seat.hologramRenderTargets.forEach((id, renderTarget) -> {
            boolean isZAxis;
            Vector3d tgPos = worldToShip.transformPosition(new Vector3d((Vector3fc)renderTarget.getPos()));
            double[] offsets = SeatHologramRenderer.calculateScreenOffset(tgPos, shipHologramCenter, cameraToShipPos, isZAxis = seat.faceVec.x() == 0.0f);
            if (offsets != null) {
                double d = isZAxis ? (seat.faceVec.z() > 0.0f ? offsets[0] : -offsets[0]) : (offsets[0] = seat.faceVec.x() > 0.0f ? -offsets[0] : offsets[0]);
                if (Math.abs(offsets[0]) < (double)borderX && Math.abs(offsets[1]) < (double)borderY) {
                    double dis = tgPos.sub((Vector3dc)shipHologramCenter, new Vector3d()).length();
                    SeatHologramRenderer.drawText((float)offsets[0] + 0.01f, (float)offsets[1], 0.2f, 0.1f, 0, 54940, (int)dis + "m", 0.25f, poseStack, bufferSource);
                    LockBox lBox = this.getDefaultLockBox();
                    long t = currentTime - renderTarget.getTime();
                    long st = t < 500L ? t : 500L;
                    lBox.scale((float)(1.05 - (double)((float)st / 500.0f)));
                    double radians = Math.toRadians((float)(t % 1000L) * 360.0f / 1000.0f);
                    float sin = (float)ModMathUtil.fastSin(radians);
                    float cos = (float)ModMathUtil.fastCos(radians);
                    Matrix2f rotMat = new Matrix2f(cos, sin, -sin, cos);
                    lBox.transform(rotMat).move((float)offsets[0], (float)offsets[1]);
                    for (int i = 0; i < lBox.box.length; ++i) {
                        int next = (i + 1) % lBox.box.length;
                        int color = id >= 0L ? -16776961 : -1142822913;
                        lines.add(new HologramLine(lBox.box[i].x, lBox.box[i].y, lBox.box[next].x, lBox.box[next].y, color, 0.003f));
                    }
                }
            }
        });
        VertexConsumer buffer = bufferSource.m_6299_(HOLOGRAM_RENDER_TYPE);
        for (HologramLine line : lines) {
            SeatHologramRenderer.drawLineWithBuffer(poseStack, buffer, line.x1, line.y1, line.x2, line.y2, line.color, line.width);
        }
    }

    private static void drawAtt(Vector3d eyePos, double pitch, PoseStack poseStack, MultiBufferSource bufferSource, Vector3d top, Vector3d right) {
        double yy;
        double eye_dis = Math.sqrt(eyePos.x() * eyePos.x() + eyePos.z() * eyePos.z());
        double eye_pitch_err = Math.asin(eyePos.y() / eyePos.length());
        double ori_pitch = pitch - eye_pitch_err;
        float horizonOffset = (float)(eye_dis * ModMathUtil.fastTan(ori_pitch));
        float holoBorderY = 0.25f;
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>();
        ArrayList<HologramText> texts = new ArrayList<HologramText>();
        if (Math.abs(horizonOffset) < holoBorderY) {
            float opa = 1.0f - Math.abs(horizonOffset) / holoBorderY;
            lines.add(new HologramLine(-0.2f, horizonOffset, -0.05f, horizonOffset, SeatHologramRenderer.combineColorAlpha(0xFFFFFF, opa), 0.005f));
            lines.add(new HologramLine(0.05f, horizonOffset, 0.2f, horizonOffset, SeatHologramRenderer.combineColorAlpha(0xFFFFFF, opa), 0.005f));
        }
        double lint_interval = Math.toRadians(5.0);
        boolean needUp = true;
        boolean needDown = true;
        for (double d = lint_interval; d < 1.5707963267948966; d += lint_interval) {
            String str;
            int color2;
            int color;
            float opa;
            if (needUp) {
                float yOffset = (float)(eye_dis * ModMathUtil.fastTan(ori_pitch + d));
                if (Math.abs(yOffset) < holoBorderY) {
                    opa = 1.0f - Math.abs(yOffset) / holoBorderY;
                    color = SeatHologramRenderer.combineColorAlpha(54940, opa);
                    color2 = SeatHologramRenderer.combineColorAlpha2(54940, opa);
                    str = String.valueOf((int)Math.floor(Math.toDegrees(-d) + 0.5));
                    texts.add(new HologramText(-0.123f, yOffset - 0.0075f, 0.01f, 0.01f, 1, color2, str, 0.175f));
                    texts.add(new HologramText(0.123f, yOffset - 0.0075f, 0.01f, 0.01f, 1, color2, str, 0.175f));
                    lines.add(new HologramLine(-0.1f, yOffset, -0.075f, yOffset, color, 0.0075f));
                    lines.add(new HologramLine(-0.1f, yOffset, -0.1f, yOffset - 0.015f, color, 0.0075f));
                    lines.add(new HologramLine(0.075f, yOffset, 0.1f, yOffset, color, 0.0075f));
                    lines.add(new HologramLine(0.1f, yOffset, 0.1f, yOffset - 0.015f, color, 0.0075f));
                }
                if (yOffset > holoBorderY) {
                    needUp = false;
                }
            }
            if (!needDown) continue;
            float nyOffset = (float)(eye_dis * ModMathUtil.fastTan(ori_pitch - d));
            if (Math.abs(nyOffset) < holoBorderY && Math.abs(d) < 1.55) {
                opa = 1.0f - Math.abs(nyOffset) / holoBorderY;
                color = SeatHologramRenderer.combineColorAlpha(54940, opa);
                color2 = SeatHologramRenderer.combineColorAlpha2(54940, opa);
                str = String.valueOf((int)Math.floor(Math.toDegrees(d) + 0.5));
                texts.add(new HologramText(-0.123f, nyOffset, 0.001f, 0.01f, 1, color2, str, 0.175f));
                texts.add(new HologramText(0.123f, nyOffset, 0.001f, 0.01f, 1, color2, str, 0.175f));
                lines.add(new HologramLine(-0.1f, nyOffset, -0.075f, nyOffset, color, 0.0075f));
                lines.add(new HologramLine(-0.1f, nyOffset, -0.1f, nyOffset + 0.015f, color, 0.0075f));
                lines.add(new HologramLine(0.075f, nyOffset, 0.1f, nyOffset, color, 0.0075f));
                lines.add(new HologramLine(0.1f, nyOffset, 0.1f, nyOffset + 0.015f, color, 0.0075f));
            }
            if (!(nyOffset < -holoBorderY)) continue;
            needDown = false;
        }
        double len2dy = Math.sqrt(top.y() * top.y() + right.y() * right.y());
        double sinR = yy = -right.y / len2dy;
        double cosR = SeatHologramRenderer.sin2cos(yy);
        if (top.y() < 0.0) {
            cosR = -cosR;
        }
        Matrix2f rotMat = new Matrix2f((float)cosR, (float)(-sinR), (float)sinR, (float)cosR);
        VertexConsumer attBuffer = bufferSource.m_6299_(HOLOGRAM_LINE_RENDER_TYPE);
        for (HologramLine line : lines) {
            Vector2f start = rotMat.transform(line.x1, line.y1, new Vector2f());
            Vector2f end = rotMat.transform(line.x2, line.y2, new Vector2f());
            SeatHologramRenderer.drawLineWithBuffer(poseStack, attBuffer, start.x(), start.y(), end.x(), end.y(), line.color, line.width);
        }
        for (HologramText text : texts) {
            Vector2f pos = rotMat.transform(text.x, text.y, new Vector2f());
            SeatHologramRenderer.drawText(pos.x(), pos.y(), text.width, text.height, text.align, text.color, text.text, text.scale, poseStack, bufferSource);
        }
    }

    public static double sin2cos(double s) {
        return Math.sqrt(1.0 - s * s);
    }

    public static int combineColorAlpha(int rgb, float alpha) {
        int a = (int)(Math.min(Math.max(alpha, 0.05f), 1.0f) * 255.0f + 0.5f);
        return rgb << 8 | a & 0xFF;
    }

    public static int combineColorAlpha2(int rgb, float alpha) {
        int a = (int)(Math.min(Math.max(alpha, 0.05f), 1.0f) * 255.0f + 0.5f);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawText(float x, float y, float width, float height, int align, int color, String text, float scale, PoseStack poseStack, MultiBufferSource bufferSource) {
        SeatHologramRenderer.drawText(x, y, width, height, align, color, 0, text, scale, poseStack, bufferSource);
    }

    public static void drawText(float x, float y, float width, float height, int align, int color, int bgColor, String text, float scale, PoseStack poseStack, MultiBufferSource bufferSource) {
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_85836_();
        scale *= 0.01f;
        float scaledX = switch (align) {
            case 1 -> x + (width - (float)font.m_92895_(text) * scale) / 2.0f;
            case 2 -> x + height - (float)font.m_92895_(text) * scale;
            default -> x;
        };
        Objects.requireNonNull(font);
        float scaledY = y + (height - 9.0f * scale) / 2.0f;
        poseStack.m_252880_(scaledX, scaledY, 0.0f);
        poseStack.m_85841_(scale, scale, 0.0f);
        font.m_271703_(text, x, y, color, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, bgColor, 0xF000F0);
        poseStack.m_85849_();
    }

    public static void drawLineWithBuffer(PoseStack poseStack, VertexConsumer buffer, float x1, float y1, float x2, float y2, int color, float width) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.hypot(dx, dy);
        if (length < 1.0E-5f) {
            return;
        }
        float halfWidth = width * 0.5f;
        float nx = -dy / length * halfWidth;
        float ny = dx / length * halfWidth;
        float[] vertices = new float[]{x1 - nx, y1 - ny, x2 - nx, y2 - ny, x2 + nx, y2 + ny, x1 + nx, y1 + ny};
        SeatHologramRenderer.fillQuadWithBuffer(poseStack, buffer, vertices, color);
    }

    public static void fillQuadWithBuffer(PoseStack poseStack, VertexConsumer buffer, float[] vertices, int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int packedLight = 0xF000F0;
        buffer.m_252986_(matrix, vertices[0], vertices[1], 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[6], vertices[7], 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[4], vertices[5], 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(matrix, vertices[2], vertices[3], 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
    }

    public static void drawLine(PoseStack poseStack, MultiBufferSource bufferSource, float x1, float y1, float x2, float y2, int color, float width) {
        SeatHologramRenderer.drawLineWithBuffer(poseStack, bufferSource.m_6299_(HOLOGRAM_RENDER_TYPE), x1, y1, x2, y2, color, width);
    }

    public static double[] calculateScreenOffset(Vector3d tgPos, Vector3d center, Vector3d eyePos, boolean isZAxis) {
        double intersectionY;
        double intersectionX;
        double intersectionZ;
        double fixedDirValue;
        double eyeDir;
        double dirDelta;
        if (isZAxis) {
            dirDelta = tgPos.z - eyePos.z;
            eyeDir = eyePos.z;
            fixedDirValue = center.z;
        } else {
            dirDelta = tgPos.x - eyePos.x;
            eyeDir = eyePos.x;
            fixedDirValue = center.x;
        }
        if (dirDelta == 0.0) {
            if (Math.abs(eyeDir - fixedDirValue) < 1.0E-6) {
                if (isZAxis) {
                    return new double[]{tgPos.x - center.x, tgPos.y - center.y};
                }
                return new double[]{tgPos.z - center.z, tgPos.y - center.y};
            }
            return null;
        }
        double t = (fixedDirValue - eyeDir) / dirDelta;
        if (isZAxis) {
            intersectionZ = fixedDirValue;
            intersectionX = eyePos.x + t * (tgPos.x - eyePos.x);
            intersectionY = eyePos.y + t * (tgPos.y - eyePos.y);
        } else {
            intersectionX = fixedDirValue;
            intersectionY = eyePos.y + t * (tgPos.y - eyePos.y);
            intersectionZ = eyePos.z + t * (tgPos.z - eyePos.z);
        }
        if (isZAxis) {
            return new double[]{center.x - intersectionX, center.y - intersectionY};
        }
        return new double[]{center.z - intersectionZ, center.y - intersectionY};
    }

    private LockBox getDefaultLockBox() {
        return new LockBox(new Vector2f[]{new Vector2f(0.0f, 0.5f), new Vector2f(-0.4330127f, -0.25f), new Vector2f(0.4330127f, -0.25f)});
    }

    public record HologramLine(float x1, float y1, float x2, float y2, int color, float width) {
    }

    public record HologramText(float x, float y, float width, float height, int align, int color, String text, float scale) {
    }

    private static class LockBox {
        public Vector2f[] box;

        public LockBox(Vector2f[] box) {
            this.box = box;
        }

        public void scale(float scale) {
            for (int i = 0; i < this.box.length; ++i) {
                this.box[i] = new Vector2f(this.box[i].x * scale, this.box[i].y * scale);
            }
        }

        public LockBox transform(Matrix2f mat) {
            for (int i = 0; i < this.box.length; ++i) {
                this.box[i] = mat.transform(this.box[i]);
            }
            return this;
        }

        public void move(float x, float y) {
            for (int i = 0; i < this.box.length; ++i) {
                this.box[i] = new Vector2f(this.box[i].x + x, this.box[i].y + y);
            }
        }
    }
}

