/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.base;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.shao.valkyrien_space_war.block.base.RedStoneBlockUtil;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.item.tool.VsswTools;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractThruster
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final DirectionProperty HORIZONTAL_FACING = DirectionProperty.m_61546_((String)"horizontal_facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty CLICK_FACE = DirectionProperty.m_61549_((String)"click_face", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});

    protected AbstractThruster(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)CLICK_FACE, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof VsswTools) {
            return InteractionResult.PASS;
        }
        if (!pLevel.m_5776_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof AbstractThrusterBE) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((AbstractThrusterBE)blockEntity), (BlockPos)pPos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void m_6861_(BlockState pState, Level level, BlockPos pos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        RedStoneBlockUtil.onNeighborChanged(level, pos);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : (lvl, pos, st, be) -> ((AbstractThrusterBE)be).tick(lvl, pos, st);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{HORIZONTAL_FACING}).m_61104_(new Property[]{CLICK_FACE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_().m_122424_();
        Direction horizontalDirection = context.m_8125_().m_122424_();
        Direction clickedFace = context.m_43719_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            facing = facing.m_122424_();
            horizontalDirection = horizontalDirection.m_122424_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)horizontalDirection)).m_61124_((Property)CLICK_FACE, (Comparable)clickedFace);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)((BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING))).m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)HORIZONTAL_FACING)));
    }
}

