/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.base;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.flight_control.base.AbstractFlightControlBE;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThruster;
import net.shao.valkyrien_space_war.block.thruster.base.ThrusterParticleRenderer;
import net.shao.valkyrien_space_war.block.thruster.base.ThrusterTrail;
import net.shao.valkyrien_space_war.block.thruster.base.menu.VectorThrusterMenu;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCapability;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCraftProxy;
import net.shao.valkyrien_space_war.event.ServerEvent;
import net.shao.valkyrien_space_war.function.util.BeRendererUtil;
import net.shao.valkyrien_space_war.function.util.ModMathUtil;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.function.vs.inducer.BlockEntityShipForcesInducer;
import net.shao.valkyrien_space_war.function.vs.inducer.IBEShipForceInducer;
import net.shao.valkyrien_space_war.sound.LoopSoundController;
import net.shao.valkyrien_space_war.sound.ModSounds;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;

public abstract class AbstractThrusterBE
extends ModGuestBE
implements IBEShipForceInducer,
MenuProvider {
    public static final ModConnectorBE.ConnectorType type = ModConnectorBE.ConnectorType.THRUSTER;
    public final Vector3f baseDirection;
    public final Vector3f baseDir2;
    private Vector3f currentDirection;
    private Vector3f currentDirProxy;
    private Vector3f offsetProxy;
    public Vector3f oldDirection;
    private double currentThrust;
    private double oldThrust;
    private Quaternionf FACE_ROT;
    private boolean updateFlag = false;
    protected final String uid;
    protected int startColor = -940834817;
    protected int endColor = 7659827;
    protected int dirIndex = 0;
    private boolean parentNotIsSameShip = true;
    private Quaterniondc rotationFromParent = new Quaterniond();
    private Vector3f baseDirProxy = new Vector3f();
    public final Quaternionf rotationForRender;
    private final FluidTank fluidTank = new FluidTank(1000){

        protected void onContentsChanged() {
            AbstractThrusterBE.this.m_6596_();
            AbstractThrusterBE.this.f_58857_.m_7260_(AbstractThrusterBE.this.f_58858_, AbstractThrusterBE.this.m_58900_(), AbstractThrusterBE.this.m_58900_(), 3);
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluidTank);
    private ServerShip parentShip = null;
    private ServerShip selfShip = null;
    private AbstractFlightControlBE fc = null;
    public ComputerCapability computerCapability;
    private float lastVolume = 0.0f;
    private int parentBreakCount = 0;
    private long beat;

    public AbstractThrusterBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        Direction value = (Direction)pBlockState.m_61143_((Property)AbstractThruster.FACING);
        this.baseDirection = new Vector3f((float)value.m_122429_(), (float)value.m_122430_(), (float)value.m_122431_());
        this.baseDirProxy = new Vector3f((Vector3fc)this.baseDirection);
        Direction value2 = (Direction)pBlockState.m_61143_((Property)AbstractThruster.HORIZONTAL_FACING);
        this.baseDir2 = new Vector3f((float)value2.m_122429_(), (float)value2.m_122430_(), (float)value2.m_122431_());
        Direction value3 = (Direction)pBlockState.m_61143_((Property)AbstractThruster.CLICK_FACE);
        Vector3f clickFace = new Vector3f((float)value3.m_122429_(), (float)value3.m_122430_(), (float)value3.m_122431_());
        this.rotationForRender = BeRendererUtil.getRotationFromFace(new Vector3f((Vector3fc)this.baseDirection), this.baseDir2, clickFace);
        this.currentDirection = new Vector3f((Vector3fc)this.baseDirection);
        this.oldDirection = new Vector3f((Vector3fc)this.baseDirection);
        this.currentThrust = 0.0;
        this.uid = this.m_5446_().getString() + "-" + pPos.m_121878_();
        this.dirIndex = Math.abs(this.baseDirection.x()) > Math.abs(this.baseDirection.y()) && Math.abs(this.baseDirection.x()) > Math.abs(this.baseDirection.z()) ? 0 : (Math.abs(this.baseDirection.y()) > Math.abs(this.baseDirection.z()) ? 1 : 2);
        this.computerCapability = ComputerCraftProxy.create(this);
    }

    @Override
    public void tick(Level pLevel1, BlockPos pPos, BlockState pState1) {
        ServerShip ship;
        super.tick(pLevel1, pPos, pState1);
        if (this.updateFlag) {
            this.syncToClient();
            this.updateFlag = false;
        }
        if ((ship = this.getServerShip()) == null) {
            return;
        }
        BlockEntityShipForcesInducer inducer = BlockEntityShipForcesInducer.getOrCreate(ship);
        inducer.update(this);
        this.updateShipAndFc();
    }

    private void updateShipAndFc() {
        this.fc = this.getFlightControl();
        if (this.fc != null) {
            this.parentShip = this.fc.getServerShip();
            this.selfShip = this.getServerShip();
        }
        this.parentNotIsSameShip = this.parentShip != null && this.selfShip != null && this.parentShip != this.selfShip;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.m_58904_();
    }

    @Override
    public void removeParent() {
        super.removeParent();
        this.setCurrentThrust(0.0);
    }

    public String getUID() {
        return this.uid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        this.playSound();
    }

    public void renderThrusterParticles(PoseStack pPoseStack, MultiBufferSource pBuffer) {
        this.getThrusterParticleRenderer().renderTick(this, pPoseStack, pBuffer);
    }

    protected abstract ThrusterParticleRenderer getThrusterParticleRenderer();

    @Nullable
    protected abstract ThrusterTrail getThrusterTrail();

    protected abstract void removeThrusterTrail();

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        if (this.computerCapability != null && this.computerCapability.isPeripheralCap(cap)) {
            return this.computerCapability.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
        if (this.computerCapability != null) {
            this.computerCapability.removePeripheral();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new VectorThrusterMenu(pContainerId, pPlayerInventory, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        Vector3d pos = new Vector3d(this.getBlockCenter().m_7096_(), this.getBlockCenter().m_7098_(), this.getBlockCenter().m_7094_());
        if (this.getClientShip() != null) {
            pos = this.getClientShip().getRenderTransform().getShipToWorld().transformPosition(pos);
        }
        if (this.currentThrust > 0.0) {
            double v = this.getCurrentThrust() / this.getMaxThrust();
            float p = (float)(0.5 + v * 1.0);
            float volume = 0.25f + (float)(v * 128.0);
            LoopSoundController.startOrUpdateLoop(this.f_58857_, this, (SoundEvent)ModSounds.SMALL_VECTOR_THRUSTER.get(), volume, p, true, new Vec3(pos.x(), pos.y(), pos.z()));
            this.lastVolume = volume;
        } else if (this.lastVolume > 0.0f) {
            this.lastVolume = Mth.m_14179_((float)0.8f, (float)0.0f, (float)this.lastVolume);
            if (this.lastVolume < 0.01f) {
                this.lastVolume = 0.0f;
            }
            LoopSoundController.startOrUpdateLoop(this.f_58857_, this, (SoundEvent)ModSounds.SMALL_VECTOR_THRUSTER.get(), this.lastVolume, 0.5f, true, new Vec3(pos.x(), pos.y(), pos.z()));
        } else {
            LoopSoundController.stopLoop(this.f_58857_, this);
        }
    }

    public void setEulerAngles(float yaw, float pitch) {
        Quaternionf rotationFromFace = this.getRotationFromFace();
        Quaternionf q = rotationFromFace.rotateY((float)Math.toRadians(yaw)).rotateX((float)Math.toRadians(pitch));
        Vector3f transform = q.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        this.setCurrentDirection(transform.x(), transform.y(), transform.z());
    }

    public Quaternionf getRotationFromFace() {
        return new Quaternionf((Quaternionfc)this.rotationForRender);
    }

    public float[] getEulerAngles() {
        Quaternionf rotationFromFace = this.getRotationFromFace();
        Quaternionf conjugate = rotationFromFace.conjugate(new Quaternionf());
        float frameTime = this.getFrameTime();
        Vector3f vector3f = new Vector3f(Mth.m_14179_((float)frameTime, (float)this.oldDirection.x(), (float)this.currentDirection.x()), Mth.m_14179_((float)frameTime, (float)this.oldDirection.y(), (float)this.currentDirection.y()), Mth.m_14179_((float)frameTime, (float)this.oldDirection.z(), (float)this.currentDirection.z()));
        Vector3f current = conjugate.transform((Vector3fc)vector3f, new Vector3f());
        float yaw = (float)Math.toDegrees(-Math.atan2(current.x, current.z));
        float pitch = (float)Math.abs(Math.toDegrees(Math.acos(current.y)));
        return new float[]{yaw, pitch};
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public double getCurrentThrust() {
        return this.currentThrust;
    }

    public double getOldThrust() {
        return this.oldThrust;
    }

    public Vector3f getPositionOffset() {
        if (this.getServerShip() != null) {
            return this.offsetProxy == null ? this.getDefPositionOffset() : this.offsetProxy;
        }
        return new Vector3f();
    }

    private Vector3f getDefPositionOffset() {
        if (this.getServerShip() == null) {
            return new Vector3f();
        }
        Vector3dc positionInShip = this.getServerShip().getTransform().getPositionInShip();
        return this.blockCenter.m_82492_(positionInShip.x(), positionInShip.y(), positionInShip.z()).m_252839_();
    }

    public Vector3f getBaseDirection() {
        return new Vector3f((Vector3fc)this.baseDirection);
    }

    public Vector3f getCurrentDirectionProxy() {
        if (this.parentNotIsSameShip) {
            return this.currentDirProxy == null ? new Vector3f((Vector3fc)this.currentDirection) : this.currentDirProxy;
        }
        return this.currentDirection;
    }

    public Vector3f getCurrentDirection() {
        return this.currentDirection;
    }

    public void setCurrentDirection(float x, float y, float z) {
        if (this.parentNotIsSameShip) {
            Vector3f vector3f = new Vector3f(x, y, z);
            this.currentDirection = this.rotationFromParent.conjugate(new Quaterniond()).transform(vector3f);
        } else {
            this.currentDirection = new Vector3f(x, y, z);
        }
        this.updateFlag = true;
    }

    public void setCurrentDirection(Vector3f direction) {
        this.setCurrentDirection(direction.x(), direction.y(), direction.z());
    }

    public void setCurrentDirection(Vector3d direction) {
        this.setCurrentDirection((float)direction.x(), (float)direction.y(), (float)direction.z());
    }

    public void initCurrentDirection() {
        this.setCurrentDirection(this.baseDirection.x(), this.baseDirection.y(), this.baseDirection.z());
    }

    public Vector3d getCurrentForce() {
        return new Vector3d((Vector3fc)this.currentDirection).mul(this.currentThrust).negate();
    }

    public void setCurrentThrust(double thrust) {
        if (this.currentThrust != thrust) {
            this.currentThrust = thrust;
            this.updateFlag = true;
        }
    }

    public void setColors(int startColor, int endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.syncToClient();
    }

    public int getStartColor() {
        return this.startColor;
    }

    public int getEndColor() {
        return this.endColor;
    }

    @Override
    public void onActivationChanged(int power) {
        this.setCurrentThrust((double)power / 15.0 * this.getMaxThrust());
    }

    @Override
    public void updatePhysics(PhysShip physShip, VsUtil.PhysImplSnapshot snapshot) {
        this.updateCurrentDirProxy();
        this.updateOffsetProxy();
        Vector3d currentForce = physShip.getTransform().getShipToWorld().transformDirection(this.getCurrentForce());
        if (this.parentNotIsSameShip) {
            this.rotationFromParent = this.parentShip.getTransform().getShipToWorldRotation().conjugate(new Quaterniond()).mul(this.selfShip.getTransform().getShipToWorldRotation());
            this.baseDirProxy = this.rotationFromParent.transform(new Vector3f((Vector3fc)this.baseDirection));
        }
        physShip.applyInvariantForceToPos((Vector3dc)ModMathUtil.checkAndReplaceNaN(currentForce), (Vector3dc)new Vector3d((Vector3fc)this.getDefPositionOffset()));
    }

    private void updateCurrentDirProxy() {
        if (this.parentNotIsSameShip) {
            Vector3d selfDirToWorld = this.selfShip.getTransform().getShipToWorldRotation().transform(new Vector3d((Vector3fc)this.currentDirection));
            Vector3d selfToParentDir = this.parentShip.getTransform().getWorldToShip().transformDirection((Vector3dc)selfDirToWorld, new Vector3d());
            this.currentDirProxy = new Vector3f((float)selfToParentDir.x, (float)selfToParentDir.y, (float)selfToParentDir.z);
        }
    }

    private void updateOffsetProxy() {
        if (this.fc == null) {
            this.offsetProxy = this.getDefPositionOffset();
            return;
        }
        VsUtil.PhysImplSnapshot lastSnapshot = this.fc.getLastSnapshot();
        if (this.selfShip == null || this.parentShip == null || lastSnapshot == null) {
            this.offsetProxy = this.getDefPositionOffset();
            return;
        }
        if (this.parentShip == this.selfShip) {
            Vector3d newCenter = this.selfShip.getTransform().getPositionInShip().add((Vector3dc)lastSnapshot.centerOfMass(), new Vector3d());
            this.offsetProxy = this.blockCenter.m_82492_(newCenter.x(), newCenter.y(), newCenter.z()).m_252839_();
        } else {
            Vector3d offset = lastSnapshot.finalOffsets().get(this.selfShip.getId());
            if (offset == null) {
                ++this.parentBreakCount;
                if (this.parentBreakCount > 20) {
                    this.parentBreakCount = 0;
                    ServerEvent.addOnServerTickListener(0, () -> {
                        this.fc.removeChildren(this.m_58899_());
                        this.removeParent();
                    });
                }
                this.offsetProxy = this.getDefPositionOffset();
                return;
            }
            Vector3d sub = new Vector3d(this.blockCenter.m_7096_(), this.blockCenter.m_7098_(), this.blockCenter.m_7094_()).sub(this.selfShip.getTransform().getPositionInShip());
            Vector3d transform = this.rotationFromParent.transform(sub);
            Vector3d finalOffset = offset.add((Vector3dc)transform, new Vector3d());
            Vector3d v = lastSnapshot.centerOfMass();
            Vector3f centerOfMass = new Vector3f().set(v.x(), v.y(), v.z());
            this.offsetProxy = new Vector3f().set(finalOffset.x(), finalOffset.y(), finalOffset.z()).sub((Vector3fc)centerOfMass);
        }
    }

    public abstract double getMaxThrust();

    public abstract float getMaxAngle();

    public boolean isDirectionValid(Vector3f desiredDirection) {
        Vector3f dir = desiredDirection.normalize();
        double dot = this.baseDirection.dot((Vector3fc)dir);
        double angle = Math.acos(dot);
        return angle <= (double)this.getMaxAngle();
    }

    public Vector3d clampDirection(Vector3d desiredDirection) {
        Vector3d dir = new Vector3d((Vector3dc)desiredDirection);
        Vector3d base = new Vector3d((Vector3fc)this.baseDirProxy);
        double maxAngle = this.getMaxAngle();
        double cosTheta = dir.dot((Vector3dc)base);
        if (cosTheta >= Math.cos(maxAngle)) {
            return dir.normalize();
        }
        Vector3d parallel = base.mul(cosTheta);
        Vector3d vertical = dir.sub((Vector3dc)parallel);
        double sinThetaMax = Math.sin(maxAngle);
        double verticalScale = sinThetaMax / vertical.length();
        return parallel.add((Vector3dc)vertical.mul(verticalScale)).normalize();
    }

    public static Vector3d slerp(Vector3d a, Vector3d b, double t) {
        double dot = a.dot((Vector3dc)b);
        double theta = Math.acos(dot = Math.max(-1.0, Math.min(1.0, dot)));
        if (theta < 1.0E-6) {
            return new Vector3d((Vector3dc)a);
        }
        double sinTheta = Math.sin(theta);
        double wa = Math.sin((1.0 - t) * theta) / sinTheta;
        double wb = Math.sin(t * theta) / sinTheta;
        return new Vector3d(a.x * wa + b.x * wb, a.y * wa + b.y * wb, a.z * wa + b.z * wb).normalize();
    }

    public Vector3d calculateTorque() {
        Vector3d r = new Vector3d((Vector3fc)this.getPositionOffset());
        return r.cross((Vector3dc)this.getCurrentForce());
    }

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return type;
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128350_("DirectionX", this.currentDirection.x());
        tag.m_128350_("DirectionY", this.currentDirection.y());
        tag.m_128350_("DirectionZ", this.currentDirection.z());
        tag.m_128347_("Thrust", this.currentThrust);
        tag.m_128405_("StartColor", this.startColor);
        tag.m_128405_("EndColor", this.endColor);
        CompoundTag fluidTag = new CompoundTag();
        this.fluidTank.writeToNBT(fluidTag);
        tag.m_128365_("FluidTank", (Tag)fluidTag);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.beat = System.currentTimeMillis();
            this.oldDirection = new Vector3f((Vector3fc)this.currentDirection);
        }
        super.loadTag(tag);
        this.currentDirection = new Vector3f(tag.m_128457_("DirectionX"), tag.m_128457_("DirectionY"), tag.m_128457_("DirectionZ"));
        this.oldThrust = this.currentThrust;
        this.currentThrust = tag.m_128459_("Thrust");
        if (tag.m_128441_("FluidTank")) {
            this.fluidTank.readFromNBT(tag.m_128469_("FluidTank"));
        }
        this.startColor = tag.m_128451_("StartColor");
        this.endColor = tag.m_128451_("EndColor");
    }

    public float getFrameTime() {
        float v = (float)(System.currentTimeMillis() - this.beat) / 1000.0f;
        return Mth.m_14036_((float)(v * 20.0f), (float)0.0f, (float)1.0f);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractThrusterBE other = (AbstractThrusterBE)obj;
        return other.m_58899_().equals((Object)this.m_58899_());
    }

    public double getEfficiency(Vector3d direction) {
        double dot = new Vector3d((Vector3fc)this.baseDirection).dot((Vector3dc)direction);
        return dot * dot;
    }
}

