/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.base;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.function.render.CubeRenderer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ThrusterParticleRenderer {
    private static final int MAX_LIFETIME = 200;
    private static final long GENERATION_INTERVAL = 1L;
    private static final Random RANDOM = new Random();
    private final HashSet<Cube> cubes = new HashSet();
    private final float length;
    private final float width;
    private final float innerLength;
    private final float innerWidth;
    private final float middleLength;
    private final float middleWidth;
    private final float speed;
    private final float scale;
    private int innerStartColor;
    private int innerEndColor;
    private int middleStartColor;
    private int middleEndColor;
    private int outerStartColor;
    private int outerEndColor;
    private long lastGenerationTime = System.currentTimeMillis();
    private final Vector3f offset;
    private final float offset2;

    public ThrusterParticleRenderer(float length, float width, float innerRatio, float middleRatio, float speed, float scale, int startColor, int endColor, Vector3f offset, float offset2) {
        this.length = length;
        this.width = width;
        this.speed = speed;
        this.scale = scale;
        this.setColors(startColor, endColor);
        this.innerLength = length * innerRatio;
        this.innerWidth = width * innerRatio;
        this.middleLength = length * middleRatio;
        this.middleWidth = width * middleRatio;
        this.offset = offset;
        this.offset2 = offset2;
    }

    private void setColors(int startColor, int endColor) {
        this.innerStartColor = ThrusterParticleRenderer.adjustBrightness(startColor, 1.5f);
        this.innerEndColor = ThrusterParticleRenderer.adjustBrightness(endColor, 1.5f);
        this.middleStartColor = startColor;
        this.middleEndColor = endColor;
        this.outerStartColor = ThrusterParticleRenderer.adjustBrightness(startColor, 0.75f);
        this.outerEndColor = ThrusterParticleRenderer.adjustBrightness(endColor, 0.75f);
    }

    public void renderTick(AbstractThrusterBE be, PoseStack pPoseStack, MultiBufferSource pBuffer) {
        long currentTime = System.currentTimeMillis();
        this.setColors(be.getStartColor(), be.getEndColor());
        this.cubes.removeIf(cube -> (double)cube.birthTime + 200.0 * (1.0 - Math.random() * 0.3) < (double)currentTime || cube.getScale(cube.getAge()) < 0.05f);
        if (currentTime - this.lastGenerationTime >= 1L) {
            this.generateParticles(be, currentTime);
            this.lastGenerationTime = currentTime;
        }
        pPoseStack.m_85836_();
        Quaternionf rotationFromFace = be.getRotationFromFace();
        Vector3f transform = rotationFromFace.transform(new Vector3f((Vector3fc)this.offset));
        pPoseStack.m_252880_(transform.x, transform.y, transform.z);
        float[] eulerAngles = be.getEulerAngles();
        float yaw = (float)Math.toRadians(Mth.m_14177_((float)(eulerAngles[0] + 180.0f)));
        float pitch = (float)Math.toRadians(eulerAngles[1]);
        rotationFromFace.rotateY(-yaw).rotateX(-pitch);
        pPoseStack.m_252781_(rotationFromFace);
        pPoseStack.m_252880_(0.0f, this.offset2, 0.0f);
        this.cubes.forEach(cube -> cube.render(pPoseStack, pBuffer));
        pPoseStack.m_85849_();
    }

    private void generateParticles(AbstractThrusterBE be, long currentTime) {
        float fSpeed = 0.25f + (float)(be.getCurrentThrust() / (be.getMaxThrust() / 4.0));
        fSpeed = Math.min(fSpeed, 1.5f) * this.speed;
        float fScale = (float)(be.getCurrentThrust() / (be.getMaxThrust() / 4.0));
        fScale = Math.min(fScale, 2.0f) * this.scale;
        for (int i = 0; i < 2; ++i) {
            Vector3f innerPos = this.generateRectanglePoint(-this.innerLength / 2.0f, -this.innerWidth / 2.0f, this.innerLength / 2.0f, this.innerWidth / 2.0f, this.scale, -this.scale);
            innerPos.y += 0.15f;
            this.cubes.add(new Cube(innerPos, currentTime, this.innerStartColor, this.innerEndColor, fScale, fSpeed));
            Vector3f middlePos = this.generateRingPoint(-this.innerLength / 2.0f, -this.innerWidth / 2.0f, this.innerLength / 2.0f, this.innerWidth / 2.0f, -this.middleLength / 2.0f, -this.middleWidth / 2.0f, this.middleLength / 2.0f, this.middleWidth / 2.0f, this.scale, -this.scale);
            middlePos.y += 0.15f;
            this.cubes.add(new Cube(middlePos, currentTime, this.middleStartColor, this.middleEndColor, fScale, fSpeed * 0.7f));
            Vector3f outerPos = this.generateRingPoint(-this.middleLength / 2.0f, -this.middleWidth / 2.0f, this.middleLength / 2.0f, this.middleWidth / 2.0f, -this.length / 2.0f, -this.width / 2.0f, this.length / 2.0f, this.width / 2.0f, this.scale, -this.scale);
            outerPos.y += 0.15f;
            this.cubes.add(new Cube(outerPos, currentTime, this.outerStartColor, this.outerEndColor, fScale, fSpeed * 0.35f));
        }
    }

    private Vector3f generateRectanglePoint(float x1, float z1, float x2, float z2, float y1, float y2) {
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float minZ = Math.min(z1, z2);
        float maxZ = Math.max(z1, z2);
        float randomX = minX + RANDOM.nextFloat() * (maxX - minX);
        float randomY = minY + RANDOM.nextFloat() * (maxY - minY);
        float randomZ = minZ + RANDOM.nextFloat() * (maxZ - minZ);
        return new Vector3f(randomX, randomY, randomZ);
    }

    private Vector3f generateRingPoint(float innerX1, float innerZ1, float innerX2, float innerZ2, float outerX1, float outerZ1, float outerX2, float outerZ2, float y1, float y2) {
        float randomZ;
        float randomX;
        float innerMinX = Math.min(innerX1, innerX2);
        float innerMaxX = Math.max(innerX1, innerX2);
        float innerMinZ = Math.min(innerZ1, innerZ2);
        float innerMaxZ = Math.max(innerZ1, innerZ2);
        float outerMinX = Math.min(outerX1, outerX2);
        float outerMaxX = Math.max(outerX1, outerX2);
        float outerMinZ = Math.min(outerZ1, outerZ2);
        float outerMaxZ = Math.max(outerZ1, outerZ2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        float randomY = minY + RANDOM.nextFloat() * (maxY - minY);
        do {
            randomX = outerMinX + RANDOM.nextFloat() * (outerMaxX - outerMinX);
            randomZ = outerMinZ + RANDOM.nextFloat() * (outerMaxZ - outerMinZ);
        } while (!(randomX < innerMinX || randomX > innerMaxX || randomZ < innerMinZ) && !(randomZ > innerMaxZ));
        return new Vector3f(randomX, randomY, randomZ);
    }

    public static int adjustBrightness(int color, float brightnessFactor) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        r = (int)((float)r * brightnessFactor);
        g = (int)((float)g * brightnessFactor);
        b = (int)((float)b * brightnessFactor);
        r = Math.min(255, Math.max(0, r));
        g = Math.min(255, Math.max(0, g));
        b = Math.min(255, Math.max(0, b));
        return r << 24 | g << 16 | b << 8 | a;
    }

    private class Cube {
        Vector3f pos;
        Vector3f lastPos;
        long birthTime;
        int startColor;
        int endColor;
        float scale;
        final float speed;

        public Cube(Vector3f pos, long birthTime, int startColor, int endColor, float scale, float speed) {
            this.pos = pos;
            this.lastPos = new Vector3f((Vector3fc)pos);
            this.birthTime = birthTime;
            this.startColor = startColor;
            this.endColor = endColor;
            this.scale = scale;
            this.speed = speed;
        }

        public void render(PoseStack pPoseStack, MultiBufferSource pBuffer) {
            long age = this.getAge();
            if (age >= 200L) {
                return;
            }
            float progress = (float)age / 200.0f;
            this.pos.y += this.speed * 0.05f;
            int color = this.interpolateColor(this.startColor, this.endColor, progress);
            float iScale = this.getScale(age) + 0.15f;
            float finalScale = this.scale * iScale;
            float r = (float)(color >> 24 & 0xFF) / 255.0f;
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float b = (float)(color >> 8 & 0xFF) / 255.0f;
            float a = (float)(color & 0xFF) / 255.0f;
            CubeRenderer.renderCube(pPoseStack, pBuffer, new Vec3(this.pos), new Vec3(this.lastPos), finalScale, finalScale * 4.0f, new float[]{r, g, b, a});
        }

        public long getAge() {
            long currentTime = System.currentTimeMillis();
            return currentTime - this.birthTime;
        }

        public float getScale(long age) {
            float progress = (float)age / 200.0f;
            if (progress <= 0.2f) {
                return 0.8f + progress * 2.0f;
            }
            float adjustedProgress = (progress - 0.2f) / 0.8f;
            adjustedProgress = Math.min(adjustedProgress, 1.0f);
            return 1.2f * (1.0f - adjustedProgress);
        }

        private int interpolateColor(int startColor, int endColor, float progress) {
            int startA = startColor >> 24 & 0xFF;
            int startR = startColor >> 16 & 0xFF;
            int startG = startColor >> 8 & 0xFF;
            int startB = startColor & 0xFF;
            int endA = endColor >> 24 & 0xFF;
            int endR = endColor >> 16 & 0xFF;
            int endG = endColor >> 8 & 0xFF;
            int endB = endColor & 0xFF;
            int a = (int)((float)startA + (float)(endA - startA) * progress);
            int r = (int)((float)startR + (float)(endR - startR) * progress);
            int g = (int)((float)startG + (float)(endG - startG) * progress);
            int b = (int)((float)startB + (float)(endB - startB) * progress);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

