/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.base;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.function.manager.ModResourceManager;
import net.shao.valkyrien_space_war.function.render.ModTrailRenderer;

public class ThrusterTrail {
    protected static final int MAX_AGE = 2000;
    protected ArrayList<Point> trailPositions = new ArrayList();
    protected Vec3 position;
    protected float radius;
    float r;
    float g;
    float b;
    float a;
    private long lastTime;

    public ThrusterTrail(float radius, int color) {
        this.radius = radius;
        this.r = (float)(color >> 24 & 0xFF) / 255.0f;
        this.g = (float)(color >> 16 & 0xFF) / 255.0f;
        this.b = (float)(color >> 8 & 0xFF) / 255.0f;
        this.a = (float)(color & 0xFF) / 255.0f;
        ModResourceManager.ALL_THRUSTER_TRAILS.add(this);
    }

    public void updatePosition(double x, double y, double z) {
        long l = System.currentTimeMillis();
        Vec3 vec3 = new Vec3(x, y, z);
        this.trailPositions.add(0, new Point(vec3, l));
        this.lastTime = l;
    }

    public boolean needRemove() {
        return this.trailPositions.isEmpty();
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource buffer, float partialTick) {
        long l = System.currentTimeMillis();
        this.trailPositions.removeIf(t -> l - t.time > 2000L);
        Vec3[] points = new Vec3[this.trailPositions.size()];
        for (int i = 0; i < this.trailPositions.size(); ++i) {
            Vec3 pos = this.trailPositions.get((int)i).pos;
            points[i] = new Vec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        }
        float v = 1.0f - (float)(l - this.lastTime) / 2000.0f;
        v = Math.max(0.0f, Math.min(1.0f, v));
        poseStack.m_85836_();
        ModTrailRenderer.renderTrail(poseStack, (MultiBufferSource)buffer, points, this.radius, new float[]{this.r, this.g, this.b, this.a * v});
        poseStack.m_85849_();
    }

    private record Point(Vec3 pos, long time) {
    }
}

