/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.base.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.block.thruster.base.menu.VectorThrusterMenu;
import net.shao.valkyrien_space_war.function.render.ModGuiUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.thruster.ThrusterSetColorPacket;
import net.shao.valkyrien_space_war.network.thruster.ThrusterSetDirPacket;
import net.shao.valkyrien_space_war.screen.ModKeyTypeContainerScreen;
import net.shao.valkyrien_space_war.screen.ui.ImageButton;
import org.joml.Vector3f;

public class VectorThrusterScreen
extends ModKeyTypeContainerScreen<VectorThrusterMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/thruster/vector_thruster_gui.png");
    private static final ResourceLocation AREA_TEXTURE = new ResourceLocation("valkyrien_space_war", "textures/gui/thruster/ash_area.png");
    private static final int TANK_WIDTH = 7;
    private static final int TANK_HEIGHT = 56;
    private static final int TANK_X = 161;
    private static final int TANK_Y = 8;
    protected ImageWidget dirArea;
    private final int dirAreaSize = 58;
    private EditBox startColor;
    private EditBox endColor;
    protected final VectorThrusterMenu menu;
    protected final AbstractThrusterBE be;
    protected int x;
    protected int y;
    private static final String BASE_DIR = Component.m_237115_((String)"gui.valkyrien_space_war.base_direction").getString();
    private static final String CURRENT_DIR = Component.m_237115_((String)"gui.valkyrien_space_war.current_direction").getString();
    private static final String CURRENT_THRUST = Component.m_237115_((String)"gui.valkyrien_space_war.current_thrust").getString();

    public VectorThrusterScreen(VectorThrusterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.menu = pMenu;
        this.be = this.menu.be;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.dirArea = new ImageButton(this.x + 7, this.y + 7, 58, 58, AREA_TEXTURE, (btn, x, y) -> {
            double vx = x * 2.0 - 1.0;
            double vy = y * 2.0 - 1.0;
            double maxDeg = Math.toDegrees(this.be.getMaxAngle());
            double yaw = Math.toDegrees(Math.atan2(vx, vy));
            double pitch = Math.sqrt(vx * vx + vy * vy) * maxDeg;
            pitch = Math.min(pitch, maxDeg);
            ModNetworkHandler.sendToServer(new ThrusterSetDirPacket(this.be.m_58899_(), (float)yaw, (float)pitch));
        });
        this.dirArea.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tip.valkyrien_space_war.thruster_dir_selection").m_130940_(ChatFormatting.GREEN)));
        this.startColor = new EditBox(this.f_96547_, this.x + 8, this.y + 73, 75, 8, (Component)Component.m_237113_((String)"startColor"));
        this.endColor = new EditBox(this.f_96547_, this.x + 93, this.y + 73, 75, 8, (Component)Component.m_237113_((String)"endColor"));
        this.startColor.m_94144_(ModGuiUtil.intToHexString(this.be.getStartColor()));
        this.endColor.m_94144_(ModGuiUtil.intToHexString(this.be.getEndColor()));
        this.startColor.m_94151_(s -> ModNetworkHandler.sendToServer(new ThrusterSetColorPacket(this.be.m_58899_(), ModGuiUtil.convertToColorInt(s), this.be.getEndColor())));
        this.endColor.m_94151_(s -> ModNetworkHandler.sendToServer(new ThrusterSetColorPacket(this.be.m_58899_(), this.be.getStartColor(), ModGuiUtil.convertToColorInt(s))));
        this.m_142416_((GuiEventListener)this.dirArea);
        this.m_142416_((GuiEventListener)this.startColor);
        this.m_142416_((GuiEventListener)this.endColor);
    }

    private void renderTank(GuiGraphics pGuiGraphics, int x, int y) {
        FluidStack fluidStack = this.menu.getFluidStack();
        int amount = this.menu.getFluidAmount();
        int capacity = this.menu.getCapacity();
        if (!fluidStack.isEmpty()) {
            int fluidHeight = (int)((float)amount / (float)capacity * 56.0f);
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation fluidTexture = renderProps.getStillTexture(fluidStack);
            TextureAtlasSprite fluidSprite = (TextureAtlasSprite)this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(fluidTexture);
            int color = renderProps.getTintColor(fluidStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            for (int i = 0; i < fluidHeight; ++i) {
                pGuiGraphics.m_280159_(x, y + 56 - i - 1, 0, 7, 1, fluidSprite);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        pGuiGraphics.m_280056_(this.f_96547_, BASE_DIR, 74, 10, 0, false);
        pGuiGraphics.m_280056_(this.f_96547_, this.getBaseDirection(), 74, 20, 0, false);
        pGuiGraphics.m_280056_(this.f_96547_, CURRENT_DIR, 74, 30, 0, false);
        pGuiGraphics.m_280056_(this.f_96547_, this.getCurrentDirection(), 74, 40, 0, false);
        pGuiGraphics.m_280056_(this.f_96547_, CURRENT_THRUST, 74, 50, 0, false);
        pGuiGraphics.m_280056_(this.f_96547_, "" + (int)Math.floor(this.be.getCurrentThrust()), 74, 60, 0, false);
        float[] eulerAngles = this.be.getEulerAngles();
        float yaw = (float)Math.toRadians(eulerAngles[0]);
        float pitchP = (float)((double)eulerAngles[1] / Math.toDegrees(this.be.getMaxAngle()));
        float xOffset = -((float)Math.sin(yaw)) * pitchP * 58.0f / 2.0f;
        float zOffset = (float)Math.cos(yaw) * pitchP * 58.0f / 2.0f;
        ModGuiUtil.drawLine(pGuiGraphics, 36.0f, 36.0f, (int)(36.0f + xOffset), (int)(36.0f + zOffset), 2.0f, -6710887);
    }

    protected String getBaseDirection() {
        Vector3f baseDirection = this.be.getBaseDirection();
        return String.format("%.2f, %.2f, %.2f", Float.valueOf(baseDirection.x()), Float.valueOf(baseDirection.y()), Float.valueOf(baseDirection.z()));
    }

    protected String getCurrentDirection() {
        Vector3f currentDirection = this.be.getCurrentDirection();
        return String.format("%.2f, %.2f, %.2f", Float.valueOf(currentDirection.x()), Float.valueOf(currentDirection.y()), Float.valueOf(currentDirection.z()));
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        super.m_280072_(pGuiGraphics, mouseX, mouseY);
        if (this.isMouseOverTank(mouseX, mouseY)) {
            String text = this.getFluidInfo();
            pGuiGraphics.m_280056_(this.f_96547_, text, mouseX, mouseY, 0xFFFFFF, false);
        }
    }

    private boolean isMouseOverTank(int mouseX, int mouseY) {
        int tankX = this.f_97735_ + 161;
        int tankY = this.f_97736_ + 8;
        return mouseX >= tankX && mouseX < tankX + 7 && mouseY >= tankY && mouseY < tankY + 56;
    }

    private String getFluidInfo() {
        if (this.menu.getFluidStack().isEmpty()) {
            return "\u7a7a: 0/" + this.menu.getCapacity() + " mB";
        }
        return this.menu.getFluidStack().getDisplayName().getString() + ": " + this.menu.getFluidAmount() + "/" + this.menu.getCapacity() + " mB";
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderTank(pGuiGraphics, x + 161, y + 8);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }
}

