/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.thruster.normal;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.shao.valkyrien_space_war.block.ModBlockEntities;
import net.shao.valkyrien_space_war.block.thruster.base.AbstractThrusterBE;
import net.shao.valkyrien_space_war.block.thruster.base.ThrusterParticleRenderer;
import net.shao.valkyrien_space_war.block.thruster.base.ThrusterTrail;
import net.shao.valkyrien_space_war.block.thruster.normal.NormalThrusterModel;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;

public class NormalThrusterBE
extends AbstractThrusterBE {
    public static final double MAX_THRUST = 1.0E8;
    private static final float MAX_ANGLE = 0.0f;
    private final ThrusterParticleRenderer thrusterParticleRenderer = new ThrusterParticleRenderer(0.75f, 0.45f, 0.7f, 0.9f, 3.5f, 0.075f, -940834970, 7659810, new Vector3f(0.0f, 0.0f, 0.0f), 0.65f);
    private ThrusterTrail thrusterTrail = null;

    public NormalThrusterBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.NORMAL_THRUSTER_BE.get(), pPos, pBlockState);
    }

    @Override
    protected ThrusterParticleRenderer getThrusterParticleRenderer() {
        return this.thrusterParticleRenderer;
    }

    @Override
    @Nullable
    protected ThrusterTrail getThrusterTrail() {
        return this.thrusterTrail == null ? (this.thrusterTrail = new ThrusterTrail(0.2f, this.startColor)) : this.thrusterTrail;
    }

    @Override
    public void renderTick() {
        super.renderTick();
        ClientShip clientShip = this.getClientShip();
        if (this.getThrusterTrail() != null && clientShip != null) {
            int maxVelocityIndex;
            boolean flag = false;
            ShipTransform renderTransform = this.getClientShip().getRenderTransform();
            Vector3d velocity = renderTransform.getWorldToShip().transformDirection(clientShip.getVelocity(), new Vector3d());
            int n = Math.abs(velocity.x()) > Math.abs(velocity.y()) && Math.abs(velocity.x()) > Math.abs(velocity.z()) ? 0 : (maxVelocityIndex = Math.abs(velocity.y()) > Math.abs(velocity.z()) ? 1 : 2);
            if (maxVelocityIndex == this.dirIndex) {
                double[] vDouble = new double[]{velocity.x(), velocity.y(), velocity.z()};
                double[] dArray = new double[]{this.baseDirection.x(), this.baseDirection.y(), this.baseDirection.z()};
                double[] dirDouble = dArray;
                if (vDouble[maxVelocityIndex] * dirDouble[this.dirIndex] < 0.0 && Math.abs(vDouble[maxVelocityIndex]) > 20.0) {
                    Vec3 bc = this.getBlockCenter().m_82549_(new Vec3(this.baseDirection).m_82490_(2.0));
                    Vector3d vector3d = renderTransform.getShipToWorld().transformPosition(new Vector3d(bc.m_7096_(), bc.m_7098_(), bc.m_7094_()));
                    this.getThrusterTrail().updatePosition(vector3d.x(), vector3d.y(), vector3d.z());
                    flag = true;
                }
            }
            if (!flag) {
                this.removeThrusterTrail();
            }
        }
    }

    @Override
    protected void removeThrusterTrail() {
        if (this.thrusterTrail != null) {
            this.thrusterTrail = null;
        }
    }

    @Override
    public double getMaxThrust() {
        return 1.0E8;
    }

    @Override
    public float getMaxAngle() {
        return 0.0f;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.valkyrien_space_war.normal_thruster");
    }

    public static class Renderer
    implements BlockEntityRenderer<NormalThrusterBE> {
        private final NormalThrusterModel model;
        public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("valkyrien_space_war", "textures/block/normal_thruster.png");

        public Renderer(BlockEntityRendererProvider.Context context) {
            this.model = new NormalThrusterModel(context.m_173582_(NormalThrusterModel.LAYER_LOCATION));
        }

        public int m_142163_() {
            return 256;
        }

        public void render(NormalThrusterBE be, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            this.model.render(be, pPoseStack, pBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE_LOCATION)), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            be.renderThrusterParticles(pPoseStack, pBuffer);
            pPoseStack.m_85849_();
        }
    }
}

