/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractItemTurretBE
extends AbstractTurretBE {
    public final ItemStackHandler itemHandler = new ItemStackHandler(9);
    private LazyOptional<IItemHandler> itemOptional = LazyOptional.of(() -> this.itemHandler);

    public AbstractItemTurretBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.itemOptional = LazyOptional.of(() -> this.itemHandler);
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemOptional.invalidate();
    }

    public void drops() {
        int count = this.itemHandler.getSlots();
        SimpleContainer inventory = new SimpleContainer(count);
        for (int i = 0; i < count; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }
}

