/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.base;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.shao.valkyrien_space_war.block.base.ModConnectorBE;
import net.shao.valkyrien_space_war.block.base.ModGuestBE;
import net.shao.valkyrien_space_war.block.base.PhyGuestBE;
import net.shao.valkyrien_space_war.block.radar.base.TmpTarget;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurret;
import net.shao.valkyrien_space_war.block.turret.base.BallisticCalculator;
import net.shao.valkyrien_space_war.block.turret.base.TurretCameraEntity;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCapability;
import net.shao.valkyrien_space_war.compat.computercraft.ComputerCraftProxy;
import net.shao.valkyrien_space_war.compat.fe.FeStorageCapability;
import net.shao.valkyrien_space_war.compat.gregtech.GtEnergyCapability;
import net.shao.valkyrien_space_war.compat.gregtech.GtEnergyContainerProxy;
import net.shao.valkyrien_space_war.entity.ModEntities;
import net.shao.valkyrien_space_war.input.ModKeyBindings;
import net.shao.valkyrien_space_war.projectile.base.ProjectileProperties;
import net.shao.valkyrien_space_war.projectile.base.ProjectileUtil;
import net.shao.valkyrien_space_war.projectile.base.VSSWProjectile;
import net.shao.valkyrien_space_war.sound.LoopSoundController;
import net.shao.valkyrien_space_war.sound.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.ServerShip;

public abstract class AbstractTurretBE
extends ModGuestBE
implements MenuProvider,
PhyGuestBE {
    public final Vector3f faceVec;
    public final float faceAngle;
    public final boolean inverted;
    protected float pitch;
    protected float yaw;
    protected float oYaw;
    protected float oPitch;
    public float minYaw = -180.0f;
    public float maxYaw = 180.0f;
    public float minPitch;
    public float maxPitch;
    protected TmpTarget target;
    protected boolean onFire;
    protected int fireTicks;
    protected byte fireRate = (byte)10;
    private static final ModConnectorBE.ConnectorType type = ModConnectorBE.ConnectorType.TURRET;
    protected UUID activePlayer;
    protected Player owner;
    protected float[] targetRotation = new float[2];
    public Quaternionf rotationForRender;
    public Vec3 blockCenter;
    protected BallisticCalculator ballisticCalculator;
    protected String uid;
    private boolean isOnRotation = false;
    protected ComputerCapability computerCapability;
    protected GtEnergyCapability gtEnergyCapability;
    protected FeStorageCapability feStorageCapability;
    protected LazyOptional<IEnergyStorage> feEnergyHandler;
    private boolean clientRotSync = false;
    private long beat;

    public AbstractTurretBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        Direction value = (Direction)pBlockState.m_61143_((Property)AbstractTurret.FACING);
        this.faceVec = new Vector3f((float)value.m_122429_(), (float)value.m_122430_(), (float)value.m_122431_());
        float degrees = (float)Math.toDegrees(Math.atan2(-this.faceVec.x, this.faceVec.z));
        this.inverted = (Boolean)pBlockState.m_61143_((Property)AbstractTurret.INVERTED);
        this.minPitch = this.inverted ? -45.0f : -90.0f;
        this.maxPitch = this.inverted ? 90.0f : 45.0f;
        this.yaw = this.faceAngle = this.inverted ? -degrees : degrees;
        this.pitch = 0.0f;
        this.oYaw = this.yaw;
        this.oPitch = this.pitch;
        this.targetRotation[0] = this.yaw;
        this.targetRotation[1] = this.pitch;
        this.rotationForRender = new Quaternionf().rotationY((float)Math.atan2(-this.faceVec.x, -this.faceVec.z));
        this.blockCenter = pPos.m_252807_();
        this.ballisticCalculator = new BallisticCalculator(16.0f, 0.05f, 0.99f, this.getBarrelLength());
        this.uid = this.m_5446_().getString() + "-" + pPos.m_121878_();
        this.computerCapability = ComputerCraftProxy.create(this);
        this.gtEnergyCapability = GtEnergyContainerProxy.create(this);
    }

    public void onLoad() {
        super.onLoad();
        this.newFeStorageCapability();
    }

    private void newFeStorageCapability() {
        this.feStorageCapability = new FeStorageCapability(this, (int)Math.min(this.getEnergyCapacity() * 4L, Integer.MAX_VALUE), this.getVoltageLevel(), Math.min(this.getInputAmperage(), Integer.MAX_VALUE));
        this.feEnergyHandler = LazyOptional.of(() -> this.feStorageCapability);
    }

    @Override
    public void tick(Level pLevel1, BlockPos pPos, BlockState pState1) {
        super.tick(pLevel1, pPos, pState1);
        this.lockTarget();
        this.checkRotation();
        if (this.isOnRotation && this.getEnergyStored() >= (long)this.getRotationEnergyCost()) {
            this.changeEnergy(-this.getRotationEnergyCost());
        }
        if (this.fireTicks > 0) {
            --this.fireTicks;
        }
        if (this.checkFireOnSafeArea() && this.canShoot()) {
            this.shoot();
        }
    }

    @Override
    public void onActivationChanged(int power) {
        boolean bl = this.onFire = power > 0;
        if (power > 0) {
            float v = 1.0f - Math.min(Math.max((float)power / 15.0f, 0.0f), 1.0f);
            this.setFireRate(v);
        }
    }

    public void calcProjectile() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Player ownerPlayer = this.activePlayer == null ? this.owner : this.f_58857_.m_46003_(this.activePlayer);
            Vec3 dir = this.getShootDir();
            Vec3 pos = this.getShootPos();
            ServerShip ship = this.getServerShip();
            if (ship != null) {
                Matrix4dc shipToWorld = ship.getTransform().getShipToWorld();
                Vector3d posOnShip = shipToWorld.transformPosition(new Vector3d(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()));
                Vector3f dirOnShip = shipToWorld.transformDirection(dir.m_252839_());
                dir = new Vec3((double)dirOnShip.x(), (double)dirOnShip.y(), (double)dirOnShip.z());
                pos = new Vec3(posOnShip.x(), posOnShip.y(), posOnShip.z());
            }
            this.spawnProjectile(ownerPlayer, this.f_58857_, ship != null, dir, pos).spawn();
        }
    }

    protected Vec3 getShootDir() {
        double radiansYaw = -Math.toRadians(this.yaw);
        double radiansPitch = -Math.toRadians(this.pitch);
        double cosPitch = Math.cos(radiansPitch);
        return new Vec3(Math.sin(radiansYaw) * cosPitch, Math.sin(radiansPitch), Math.cos(radiansYaw) * cosPitch);
    }

    protected abstract VSSWProjectile spawnProjectile(Player var1, Level var2, boolean var3, Vec3 var4, Vec3 var5);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerCapability != null && this.computerCapability.isPeripheralCap(cap)) {
            return this.computerCapability.getPeripheralCapability();
        }
        if (this.gtEnergyCapability != null && this.gtEnergyCapability.isGtEnergyCap(cap)) {
            return this.gtEnergyCapability.getGtEnergyCapability();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.feEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.computerCapability != null) {
            this.computerCapability.removePeripheral();
        }
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.invalidate();
        }
        this.feEnergyHandler.invalidate();
    }

    public long getEnergyStored() {
        return this.gtEnergyCapability == null ? (long)this.feStorageCapability.getGtEnergyStored() : this.gtEnergyCapability.getEnergyStored();
    }

    protected void changeEnergy(long l) {
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.changeEnergy(l);
        } else {
            this.feStorageCapability.changeEnergyFromGt(l);
        }
    }

    public abstract long getEnergyCapacity();

    public abstract int getVoltageLevel();

    public abstract long getInputAmperage();

    public abstract int getRotationEnergyCost();

    protected abstract float getBarrelLength();

    public abstract ProjectileProperties getProjectileProperties();

    public String getUID() {
        return this.uid;
    }

    private boolean checkFireOnSafeArea() {
        float tmpMaxYaw;
        float tmpYaw;
        boolean inSafeArea = this.maxYaw < this.minYaw ? (tmpYaw = (this.yaw + 360.0f) % 360.0f) <= (tmpMaxYaw = (this.maxYaw + 360.0f) % 360.0f) && tmpYaw >= this.minYaw : this.yaw <= this.maxYaw && this.yaw >= this.minYaw;
        return this.onFire && inSafeArea;
    }

    @Override
    public void phyTick() {
    }

    private void lockTarget() {
        if (this.activePlayer == null && this.target != null) {
            this.calTargetAngle(this.calcBallistic(this.target));
        }
    }

    private Vec3 calcBallistic(TmpTarget tmpTarget) {
        double[] pitchAndTime;
        Vec3 resultPos = new Vec3(tmpTarget.position.m_252839_());
        float[] gravDragByDimension = ProjectileUtil.getGravDragByDimension((ResourceKey<Level>)this.f_58857_.m_46472_());
        ProjectileProperties projectileProperties = this.getProjectileProperties();
        this.ballisticCalculator.setMuzzleVelocity(projectileProperties.muzzleVelocity());
        this.ballisticCalculator.setGravity(this.getProjectileProperties().gravity() * gravDragByDimension[0]);
        float v = projectileProperties.drag() * gravDragByDimension[1];
        float drag = v == 0.0f ? 1.0f : v;
        this.ballisticCalculator.setDrag(drag);
        Vec3 shootPos = new Vec3(this.getShootPos().m_7096_(), this.getShootPos().m_7098_(), this.getShootPos().m_7094_());
        if (this.getServerShip() != null) {
            Vector3d vector3d = this.getServerShip().getShipToWorld().transformPosition(new Vector3d((Vector3fc)shootPos.m_252839_()));
            shootPos = new Vec3(vector3d.x(), vector3d.y(), vector3d.z());
        }
        if (!Double.isNaN((pitchAndTime = this.ballisticCalculator.calculate(shootPos, tmpTarget.position))[1])) {
            Vec3 tgPosition;
            Vec3 scale = tmpTarget.velocity.m_82490_(pitchAndTime[1]);
            scale = scale.m_82490_(0.05);
            resultPos = tgPosition = tmpTarget.position.m_82549_(scale);
            if (pitchAndTime[1] > 1.5) {
                double[] result = this.ballisticCalculator.calculate(shootPos, tgPosition);
                Vec3 targetPos = tgPosition.m_82546_(shootPos);
                double pitch = -result[0];
                double length = targetPos.m_82553_();
                Quaternionf rot = new Quaternionf().rotateY((float)Math.atan2(-targetPos.f_82481_, targetPos.f_82479_)).rotateZ((float)Mth.m_14175_((double)pitch));
                Vector3d oPoint = rot.transform(new Vector3d(length, 0.0, 0.0));
                Vec3 finalPoint = new Vec3(oPoint.x(), oPoint.y(), oPoint.z());
                resultPos = finalPoint.m_82549_(shootPos);
            }
        }
        return resultPos;
    }

    private void calTargetAngle(Vec3 tgPos) {
        Vec3 position = new Vec3(tgPos.m_7096_(), tgPos.m_7098_(), tgPos.m_7094_());
        if (this.getServerShip() != null) {
            Vector3d vector3d = this.getServerShip().getWorldToShip().transformPosition(new Vector3d((Vector3fc)position.m_252839_()));
            position = new Vec3(vector3d.x(), vector3d.y(), vector3d.z());
        }
        Vec3 subtract = position.m_82546_(this.getShootPos());
        float yaw = (float)Math.toDegrees(Math.atan2(-subtract.m_7096_(), subtract.m_7094_()));
        float pitch = (float)(-Math.toDegrees(Math.asin(subtract.m_7098_() / subtract.m_82553_())));
        this.setTargetAngles(yaw, pitch);
    }

    private void checkRotation() {
        if (this.getEnergyStored() < (long)this.getRotationEnergyCost()) {
            return;
        }
        if (this.targetRotation[0] == this.yaw && this.targetRotation[1] == this.pitch) {
            if (this.clientRotSync) {
                this.setAngle(this.yaw, this.pitch);
                this.clientRotSync = false;
            }
            this.isOnRotation = false;
            return;
        }
        float maxRotationSpeed = this.getMaxRotationSpeed();
        float yawErr = Mth.m_14177_((float)(this.targetRotation[0] - this.yaw));
        float pitchErr = Mth.m_14177_((float)(this.targetRotation[1] - this.pitch));
        float maxAg = Math.max(Math.abs(yawErr), Math.abs(pitchErr));
        if (maxAg < maxRotationSpeed) {
            this.setAngle(this.targetRotation[0], this.targetRotation[1]);
        } else {
            float maxAgP = maxAg == 0.0f ? 0.0f : maxRotationSpeed / maxAg;
            this.setAngle(this.yaw + (yawErr *= maxAgP), this.pitch + (pitchErr *= maxAgP));
        }
        this.isOnRotation = true;
        this.clientRotSync = true;
    }

    public void setTarget(TmpTarget target) {
        this.target = target;
    }

    public void setEmptyTarget() {
        this.target = null;
    }

    protected void shoot() {
        this.fireTicks = this.getFireRate();
    }

    protected abstract boolean canShoot();

    public void setFireRate(byte fireRate) {
        this.fireRate = (byte)Math.max(0, fireRate);
        this.syncToClient();
    }

    public void setFireRate(float rate) {
        rate = Math.max(0.0f, Math.min(1.0f, rate));
        float v1 = (float)this.getMinFireRate() + (float)(this.getMaxFireRate() - this.getMinFireRate()) * rate;
        this.setFireRate((byte)v1);
    }

    public byte getFireRate() {
        return this.fireRate;
    }

    protected int getMinFireRate() {
        return 0;
    }

    protected int getMaxFireRate() {
        return 100;
    }

    @Override
    public Vec3 getBlockCenter() {
        return this.blockCenter;
    }

    public abstract Vec3 getShootPosOffset();

    public Vec3 getShootPos() {
        Vec3 shootPosOffset = this.getShootPosOffset();
        Vector3f transform = new Quaternionf().rotateY((float)Math.toRadians(-this.yaw)).rotateX((float)Math.toRadians(this.pitch)).transform(shootPosOffset.m_252839_());
        return this.getBlockCenter().m_82520_((double)transform.x(), (double)transform.y(), (double)transform.z());
    }

    public static void activateTurret(ServerPlayer player, BlockPos pos) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof AbstractTurretBE) {
            AbstractTurretBE be = (AbstractTurretBE)blockEntity;
            be.activate(player);
        }
    }

    public void activate(ServerPlayer player) {
        if (this.activePlayer == null) {
            this.activePlayer = player.m_20148_();
            ServerLevel serverLevel = player.m_284548_();
            TurretCameraEntity turretCameraEntity = new TurretCameraEntity((EntityType)ModEntities.TURRET_CAMERA_ENTITY.get(), (Level)serverLevel);
            turretCameraEntity.setPlayer(player);
            turretCameraEntity.setBe(this);
            turretCameraEntity.m_146884_(this.getBlockCenter());
            turretCameraEntity.m_146922_(this.yaw);
            turretCameraEntity.m_146926_(this.pitch);
            serverLevel.m_7967_((Entity)turretCameraEntity);
            player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)turretCameraEntity));
        }
    }

    public static Component getClientMsg() {
        return Component.m_237115_((String)"key.valkyrien_space_war.press_tip_head").m_7220_(ModKeyBindings.EXIT_TURRET_CAMERA.getKey().m_84875_()).m_7220_((Component)Component.m_237115_((String)"key.valkyrien_space_war.press_tip_tail"));
    }

    public void deactivate() {
        ServerPlayer player;
        if (this.f_58857_ != null && this.activePlayer != null && (player = (ServerPlayer)this.f_58857_.m_46003_(this.activePlayer)) != null) {
            player.m_9213_((Entity)player);
        }
        this.resetRotation();
        this.activePlayer = null;
        this.syncToClient();
    }

    private void resetRotation() {
        this.targetRotation[0] = this.faceAngle;
        this.targetRotation[1] = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        this.playSound();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        if (this.oYaw != this.yaw || this.oPitch != this.pitch) {
            Vector3d pos = new Vector3d(this.getBlockCenter().m_7096_(), this.getBlockCenter().m_7098_(), this.getBlockCenter().m_7094_());
            if (this.getClientShip() != null) {
                pos = this.getClientShip().getRenderTransform().getShipToWorld().transformPosition(pos);
            }
            LoopSoundController.startOrUpdateLoop(this.f_58857_, this, (SoundEvent)ModSounds.TURRET_ROTATE.get(), 1.0f, 1.0f, false, new Vec3(pos.x(), pos.y(), pos.z()));
        } else {
            LoopSoundController.stopLoop(this.f_58857_, this);
        }
    }

    @Override
    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            LoopSoundController.stopLoop(this.f_58857_, this);
        }
        super.m_7651_();
    }

    public abstract float getMaxRotationSpeed();

    public abstract Vec3 getEyeOffset();

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getOYaw() {
        return this.oYaw;
    }

    public float getOPitch() {
        return this.oPitch;
    }

    public void setOnFire(@Nullable Player player, boolean onFire) {
        this.owner = player;
        this.onFire = onFire;
    }

    public void setOnFire(@Nullable Player player, boolean onFire, float rate) {
        this.owner = player;
        this.onFire = onFire;
        if (onFire) {
            this.setFireRate(rate);
        }
    }

    public boolean isOnFire() {
        return this.onFire;
    }

    public void setAngleLimit(float minYaw, float maxYaw, float minPitch, float maxPitch) {
        this.minYaw = minYaw;
        this.maxYaw = maxYaw;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        this.syncToClient();
    }

    public void setTargetAngles(float yaw, float pitch) {
        float tmpMaxYaw;
        float tmpYaw;
        float tgYaw = this.maxYaw < this.minYaw ? ((tmpYaw = (yaw + 360.0f) % 360.0f) > (tmpMaxYaw = (this.maxYaw + 360.0f) % 360.0f) ? this.maxYaw : Math.max(tmpYaw, this.minYaw)) : (yaw > this.maxYaw ? this.maxYaw : Math.max(yaw, this.minYaw));
        float tgPitch = Mth.m_14036_((float)pitch, (float)this.minPitch, (float)this.maxPitch);
        this.targetRotation = new float[]{tgYaw, tgPitch};
    }

    protected void setAngle(float yaw, float pitch) {
        this.yaw = Mth.m_14177_((float)yaw);
        this.pitch = Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f);
        this.syncToClient();
    }

    @Override
    protected void putTag(CompoundTag tag) {
        super.putTag(tag);
        tag.m_128344_("FireRate", this.fireRate);
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128350_("Pitch", this.pitch);
        tag.m_128350_("minYaw", this.minYaw);
        tag.m_128350_("maxYaw", this.maxYaw);
        tag.m_128350_("minPitch", this.minPitch);
        tag.m_128350_("maxPitch", this.maxPitch);
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.putTag(tag);
        } else {
            if (this.feStorageCapability == null) {
                this.newFeStorageCapability();
            }
            this.feStorageCapability.putTag(tag);
        }
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.beat = System.currentTimeMillis();
            this.oYaw = this.yaw;
            this.oPitch = this.pitch;
        }
        super.loadTag(tag);
        this.fireRate = tag.m_128445_("FireRate");
        this.yaw = tag.m_128457_("Yaw");
        this.pitch = tag.m_128457_("Pitch");
        this.minYaw = tag.m_128457_("minYaw");
        this.maxYaw = tag.m_128457_("maxYaw");
        this.minPitch = tag.m_128457_("minPitch");
        this.maxPitch = tag.m_128457_("maxPitch");
        this.targetRotation = new float[]{this.yaw, this.pitch};
        if (this.gtEnergyCapability != null) {
            this.gtEnergyCapability.loadTag(tag);
        } else {
            if (this.feStorageCapability == null) {
                this.newFeStorageCapability();
            }
            this.feStorageCapability.loadTag(tag);
        }
    }

    public float getFrameTime() {
        float v = (float)(System.currentTimeMillis() - this.beat) / 1000.0f;
        return Mth.m_14036_((float)(v * 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    public ModConnectorBE.ConnectorType getBeType() {
        return type;
    }
}

