/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.base;

import net.minecraft.world.phys.Vec3;

public class BallisticCalculator {
    private static final float[] PITCH_LIST = new float[9001];
    private float muzzleVelocity;
    private float gravity;
    private float drag;
    private float barrelLength;

    public BallisticCalculator(float muzzleVelocity, float gravity, float drag, float barrelLength) {
        this.muzzleVelocity = muzzleVelocity;
        this.gravity = gravity;
        this.drag = drag;
        this.barrelLength = barrelLength;
    }

    public double[] calculate(Vec3 start, Vec3 end) {
        Vec3 subtract = new Vec3(end.m_7096_(), end.m_7098_(), end.m_7094_()).m_82546_(start);
        double xDis = Math.sqrt(subtract.m_7096_() * subtract.m_7096_() + subtract.m_7094_() * subtract.m_7094_());
        return this.ag_binary_search(xDis, subtract.m_7098_());
    }

    public double[] ag_binary_search(double xDis, double yDis) {
        int mid;
        double result;
        int low = 0;
        int high = PITCH_LIST.length - 1;
        double pitch = 0.0;
        double time = 0.0;
        int count = 0;
        while (!(low > high || (result = yDis - this.getY2(time = this.getTime(xDis, pitch = (double)PITCH_LIST[mid = (low + high) / 2]), pitch)) >= -0.01 && result <= 0.01)) {
            if (result < 0.0) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
            ++count;
        }
        return new double[]{pitch, time};
    }

    private double getTime(double dis, double pitch) {
        double cosPitch = Math.abs(Math.cos(pitch));
        dis -= (double)this.barrelLength * cosPitch;
        double v0 = cosPitch * (double)this.muzzleVelocity;
        if (this.drag == 0.0f || this.drag == 1.0f) {
            return dis / v0;
        }
        return Math.abs(Math.log(1.0 - dis / (100.0 * v0)) / this.ln(this.drag));
    }

    private double getY2(double t, double pitch) {
        if (t > 10000.0) {
            return 0.0;
        }
        double grav = this.gravity;
        double drag = this.drag;
        double sinPitch = -Math.sin(pitch);
        double y0 = (double)this.barrelLength * sinPitch;
        double v0 = this.muzzleVelocity;
        if (t < 1.0) {
            return y0;
        }
        double vy_init = v0 * sinPitch;
        double n = Math.floor(t);
        double alpha = t - n;
        double y_n = this.calculate(n, y0, grav, drag, vy_init);
        double y_n1 = this.calculate(n + 1.0, y0, grav, drag, vy_init);
        return y_n + (y_n1 - y_n) * alpha;
    }

    private double calculate(double n_steps, double y0, double grav, double drag, double vy_init) {
        if (drag == 1.0) {
            double term_velocity = vy_init * n_steps;
            double term_gravity = grav * n_steps * (n_steps - 1.0) / 2.0;
            return y0 + term_velocity - term_gravity;
        }
        double drag_n = Math.pow(drag, n_steps);
        double common_div = 1.0 - drag;
        double term_velocity = vy_init * (1.0 - drag_n) / common_div;
        double term_gravity = grav / common_div * (n_steps - (1.0 - drag_n) / common_div);
        return y0 + term_velocity - term_gravity;
    }

    private double ln(float x) {
        return Math.log(x) / Math.log(Math.exp(1.0));
    }

    public void setMuzzleVelocity(float muzzleVelocity) {
        this.muzzleVelocity = muzzleVelocity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void setDrag(float drag) {
        this.drag = drag;
    }

    public void setBarrelLength(float barrelLength) {
        this.barrelLength = barrelLength;
    }

    static {
        int count = 0;
        float f = -90.0f;
        while (f < 90.0f) {
            BallisticCalculator.PITCH_LIST[count] = (float)Math.toRadians(f);
            ++count;
            f = (float)((double)f + 0.02);
        }
    }
}

