/*
 * Decompiled with CFR 0.152.
 */
package net.shao.valkyrien_space_war.block.turret.base;

import java.util.HashMap;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.shao.valkyrien_space_war.block.turret.base.AbstractTurretBE;
import net.shao.valkyrien_space_war.function.vs.VsUtil;
import net.shao.valkyrien_space_war.network.ModNetworkHandler;
import net.shao.valkyrien_space_war.network.turret.EntityDataSyncPacket;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ClientShip;

public class TurretCameraEntity
extends Entity {
    public static final HashMap<ServerPlayer, TurretCameraEntity> cameraEntities = new HashMap();
    private static final EntityDataAccessor<BlockPos> DATA_BE_POS = SynchedEntityData.m_135353_(TurretCameraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private ServerPlayer player;
    private AbstractTurretBE be;
    private boolean onFire = false;
    private boolean isInitialized;
    private float yaw;
    private float pitch;
    private AbstractTurretBE clientBe;
    @OnlyIn(value=Dist.CLIENT)
    private ClientShip clientShip;
    @OnlyIn(value=Dist.CLIENT)
    private Vector3d positionIfOnShip;
    private boolean needsUpdate;

    public TurretCameraEntity(EntityType<?> type, Level pLevel) {
        super(type, pLevel);
        this.f_19794_ = true;
        this.m_20331_(true);
        this.f_19804_.m_135372_(DATA_BE_POS, (Object)BlockPos.f_121853_);
    }

    public void m_8119_() {
        if (!(this.m_9236_().f_46443_ || this.player != null && this.player.m_6084_())) {
            this.remove();
        }
    }

    public void clientTick() {
        if (this.needsUpdate) {
            this.syncDataToServer();
            this.needsUpdate = false;
        }
    }

    public void m_6034_(double p_20210_, double p_20211_, double p_20212_) {
        super.m_6034_(p_20210_, p_20211_, p_20212_);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYRot, float pXRot, int pLerpSteps, boolean pTeleport) {
    }

    public void syncDataToServer() {
        if (this.m_9236_().f_46443_) {
            CompoundTag tag = new CompoundTag();
            float[] renderAngles = this.getRenderAngles();
            tag.m_128350_("yaw", renderAngles[0]);
            tag.m_128350_("pitch", renderAngles[1]);
            tag.m_128379_("onFire", this.onFire);
            ModNetworkHandler.sendToServer(new EntityDataSyncPacket(this.m_19879_(), tag));
        }
    }

    public void loadClientData(CompoundTag data) {
        if (data.m_128441_("yaw") && data.m_128441_("pitch")) {
            float yaw = Mth.m_14036_((float)data.m_128457_("yaw"), (float)-180.0f, (float)180.0f);
            float pitch = Mth.m_14036_((float)data.m_128457_("pitch"), (float)-90.0f, (float)90.0f);
            this.be.setTargetAngles(yaw, pitch);
        }
        if (data.m_128441_("onFire")) {
            boolean isOnFire = data.m_128471_("onFire");
            this.be.setOnFire(null, isOnFire);
        }
    }

    public void setOnFire(boolean onFire) {
        boolean needSync = this.onFire != onFire;
        this.onFire = onFire;
        if (needSync) {
            this.syncDataToServer();
        }
    }

    public void setRenderAngles(float yaw, float pitch) {
        this.yaw = Mth.m_14177_((float)yaw);
        pitch = Mth.m_14177_((float)pitch);
        this.pitch = Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f);
        this.needsUpdate = true;
    }

    public float[] getRenderAngles() {
        if (!this.isInitialized) {
            this.yaw = this.getClientBe().getYaw();
            this.pitch = this.getClientBe().getPitch();
            this.isInitialized = true;
        }
        return new float[]{this.yaw, this.pitch};
    }

    public void setPlayer(ServerPlayer player) {
        this.player = player;
        cameraEntities.put(player, this);
    }

    public void setBe(AbstractTurretBE be) {
        this.be = be;
        this.f_19804_.m_135381_(DATA_BE_POS, (Object)be.m_58899_());
    }

    public BlockPos getBePos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_BE_POS);
    }

    public AbstractTurretBE getClientBe() {
        if (this.clientBe == null) {
            BlockPos bePos = this.getBePos();
            this.clientBe = (AbstractTurretBE)this.m_9236_().m_7702_(bePos);
        }
        return this.clientBe;
    }

    public float m_5675_(float pPartialTick) {
        return this.m_146908_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientShip getClientShip() {
        if (this.clientShip == null) {
            BlockPos bePos = this.getBePos();
            this.clientShip = VsUtil.getClientShip(bePos.m_123341_(), bePos.m_123342_(), bePos.m_123343_());
        }
        return this.clientShip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d getPositionIfOnShip() {
        if (this.positionIfOnShip == null) {
            ClientShip cs = this.getClientShip();
            this.positionIfOnShip = cs == null ? new Vector3d(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_) : VsUtil.getWorldToShip(cs, this.m_20182_());
        }
        return this.positionIfOnShip;
    }

    public double m_20188_() {
        return this.m_20182_().f_82480_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void remove() {
        if (this.be != null && !this.be.m_58901_()) {
            this.be.setOnFire(null, false);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        if (this.be != null && !this.be.m_58901_()) {
            this.be.deactivate();
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return false;
    }

    public boolean m_7998_(Entity entity, boolean force) {
        return false;
    }

    public boolean m_7310_(Entity passenger) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    protected void m_20101_() {
    }

    public static class Renderer
    extends EntityRenderer<TurretCameraEntity> {
        public ResourceLocation getTextureLocation(TurretCameraEntity pEntity) {
            return null;
        }

        public Renderer(EntityRendererProvider.Context pContext) {
            super(pContext);
        }

        public boolean shouldRender(TurretCameraEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
            return false;
        }
    }
}

